/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.provider;

import android.database.Cursor;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;
import com.raizlabs.android.dbflow.structure.provider.ContentUtils;
import com.raizlabs.android.dbflow.structure.provider.ModelProvider;

public abstract class BaseProviderModel
extends BaseModel
implements ModelProvider {
    @Override
    public boolean delete() {
        return ContentUtils.delete(this.getDeleteUri(), this) > 0;
    }

    @Override
    public boolean save() {
        int count = ContentUtils.update(this.getUpdateUri(), this);
        if (count == 0) {
            return ContentUtils.insert(this.getInsertUri(), this) != null;
        }
        return count > 0;
    }

    @Override
    public boolean update() {
        return ContentUtils.update(this.getUpdateUri(), this) > 0;
    }

    @Override
    public long insert() {
        ContentUtils.insert(this.getInsertUri(), this);
        return 0L;
    }

    @Override
    public boolean exists() {
        boolean exists;
        Cursor cursor = ContentUtils.query(FlowManager.getContext().getContentResolver(), this.getQueryUri(), this.getModelAdapter().getPrimaryConditionClause(this), "", new String[0]);
        boolean bl = exists = cursor != null && cursor.getCount() > 0;
        if (cursor != null) {
            cursor.close();
        }
        return exists;
    }

    @Override
    public void load(OperatorGroup whereConditions, String orderBy, String ... columns) {
        FlowCursor cursor = FlowCursor.from(ContentUtils.query(FlowManager.getContext().getContentResolver(), this.getQueryUri(), whereConditions, orderBy, columns));
        if (cursor != null && cursor.moveToFirst()) {
            this.getModelAdapter().loadFromCursor(cursor, this);
            cursor.close();
        }
    }

    @Override
    public void load() {
        this.load(this.getModelAdapter().getPrimaryConditionClause(this), "", new String[0]);
    }
}

