/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Set;

public class Update<TModel>
implements Query {
    private ConflictAction conflictAction = ConflictAction.NONE;
    private final Class<TModel> table;

    public Update(Class<TModel> table) {
        this.table = table;
    }

    @NonNull
    public Update<TModel> conflictAction(ConflictAction conflictAction) {
        this.conflictAction = conflictAction;
        return this;
    }

    @NonNull
    public Update<TModel> or(ConflictAction conflictAction) {
        return this.conflictAction(conflictAction);
    }

    @NonNull
    public Update<TModel> orRollback() {
        return this.conflictAction(ConflictAction.ROLLBACK);
    }

    @NonNull
    public Update<TModel> orAbort() {
        return this.conflictAction(ConflictAction.ABORT);
    }

    @NonNull
    public Update<TModel> orReplace() {
        return this.conflictAction(ConflictAction.REPLACE);
    }

    @NonNull
    public Update<TModel> orFail() {
        return this.conflictAction(ConflictAction.FAIL);
    }

    @NonNull
    public Update<TModel> orIgnore() {
        return this.conflictAction(ConflictAction.IGNORE);
    }

    @NonNull
    public Set<TModel> set(SQLOperator ... conditions) {
        return new Set<TModel>(this, this.table).conditions(conditions);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)"UPDATE ");
        if (this.conflictAction != null && !this.conflictAction.equals((Object)ConflictAction.NONE)) {
            queryBuilder.append((Object)"OR").appendSpaceSeparated((Object)this.conflictAction.name());
        }
        queryBuilder.append((Object)FlowManager.getTableName(this.table)).appendSpace();
        return queryBuilder.getQuery();
    }

    public Class<TModel> getTable() {
        return this.table;
    }
}

