/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.annotation.Collate;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class OrderBy
implements Query {
    public static final String ASCENDING = "ASC";
    public static final String DESCENDING = "DESC";
    private NameAlias column;
    private boolean isAscending;
    private Collate collation;
    private String orderByString;

    @NonNull
    public static OrderBy fromProperty(IProperty property) {
        return new OrderBy(property.getNameAlias());
    }

    @NonNull
    public static OrderBy fromNameAlias(NameAlias nameAlias) {
        return new OrderBy(nameAlias);
    }

    @NonNull
    public static OrderBy fromString(String orderByString) {
        return new OrderBy(orderByString);
    }

    OrderBy(NameAlias column) {
        this.column = column;
    }

    OrderBy(NameAlias column, boolean isAscending) {
        this(column);
        this.isAscending = isAscending;
    }

    OrderBy(String orderByString) {
        this.orderByString = orderByString;
    }

    @NonNull
    public OrderBy ascending() {
        this.isAscending = true;
        return this;
    }

    @NonNull
    public OrderBy descending() {
        this.isAscending = false;
        return this;
    }

    @NonNull
    public OrderBy collate(Collate collate) {
        this.collation = collate;
        return this;
    }

    public String getQuery() {
        if (this.orderByString == null) {
            StringBuilder query = new StringBuilder().append(this.column).append(" ");
            if (this.collation != null) {
                query.append("COLLATE").append(" ").append(this.collation).append(" ");
            }
            query.append(this.isAscending ? ASCENDING : DESCENDING);
            return query.toString();
        }
        return this.orderByString;
    }

    public String toString() {
        return this.getQuery();
    }
}

