/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseOperator;
import com.raizlabs.android.dbflow.sql.language.Case;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class CaseCondition<TReturn>
implements Query {
    private final Case<TReturn> caze;
    private TReturn whenValue;
    private SQLOperator sqlOperator;
    private TReturn thenValue;
    private IProperty property;
    private IProperty thenProperty;
    private boolean isThenPropertySet;

    CaseCondition(Case<TReturn> caze, @NonNull SQLOperator sqlOperator) {
        this.caze = caze;
        this.sqlOperator = sqlOperator;
    }

    CaseCondition(Case<TReturn> caze, TReturn whenValue) {
        this.caze = caze;
        this.whenValue = whenValue;
    }

    CaseCondition(Case<TReturn> caze, @NonNull IProperty property) {
        this.caze = caze;
        this.property = property;
    }

    @NonNull
    public Case<TReturn> then(TReturn value) {
        this.thenValue = value;
        return this.caze;
    }

    @NonNull
    public Case<TReturn> then(IProperty value) {
        this.thenProperty = value;
        this.isThenPropertySet = true;
        return this.caze;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)" WHEN ");
        if (this.caze.isEfficientCase()) {
            queryBuilder.append((Object)BaseOperator.convertValueToString(this.property != null ? this.property : this.whenValue, false));
        } else {
            this.sqlOperator.appendConditionToQuery(queryBuilder);
        }
        queryBuilder.append((Object)" THEN ").append((Object)BaseOperator.convertValueToString(this.isThenPropertySet ? this.thenProperty : this.thenValue, false));
        return queryBuilder.getQuery();
    }

    public String toString() {
        return this.getQuery();
    }
}

