/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseOperator;
import com.raizlabs.android.dbflow.sql.language.CaseCondition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.Operator;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.Property;
import java.util.ArrayList;
import java.util.List;

public class Case<TReturn>
implements Query {
    private IProperty caseColumn;
    private List<CaseCondition<TReturn>> caseConditions = new ArrayList<CaseCondition<TReturn>>();
    private String columnName;
    private TReturn elseValue;
    private boolean elseSpecified = false;
    private boolean efficientCase = false;
    private boolean endSpecified = false;

    Case() {
    }

    Case(IProperty caseColumn) {
        this.caseColumn = caseColumn;
        if (caseColumn != null) {
            this.efficientCase = true;
        }
    }

    @NonNull
    public CaseCondition<TReturn> when(SQLOperator sqlOperator) {
        if (this.efficientCase) {
            throw new IllegalStateException("When using the efficient CASE method,you must pass in value only, not condition.");
        }
        CaseCondition<SQLOperator> caseCondition = new CaseCondition<SQLOperator>((Case<SQLOperator>)this, sqlOperator);
        this.caseConditions.add(caseCondition);
        return caseCondition;
    }

    @NonNull
    public CaseCondition<TReturn> when(TReturn whenValue) {
        if (!this.efficientCase) {
            throw new IllegalStateException("When not using the efficient CASE method, you must pass in the SQLOperator as a parameter");
        }
        CaseCondition<TReturn> caseCondition = new CaseCondition<TReturn>(this, whenValue);
        this.caseConditions.add(caseCondition);
        return caseCondition;
    }

    @NonNull
    public CaseCondition<TReturn> when(IProperty property) {
        if (!this.efficientCase) {
            throw new IllegalStateException("When not using the efficient CASE method, you must pass in the SQLOperator as a parameter");
        }
        CaseCondition caseCondition = new CaseCondition(this, property);
        this.caseConditions.add(caseCondition);
        return caseCondition;
    }

    @NonNull
    public Case<TReturn> _else(TReturn elseValue) {
        this.elseValue = elseValue;
        this.elseSpecified = true;
        return this;
    }

    @NonNull
    public Property<Case<TReturn>> end(@Nullable String columnName) {
        this.endSpecified = true;
        if (columnName != null) {
            this.columnName = QueryBuilder.quoteIfNeeded((String)columnName);
        }
        return new Property<Case<TReturn>>(null, NameAlias.rawBuilder(this.getQuery()).build());
    }

    @NonNull
    public Property<Case<TReturn>> end() {
        return this.end(null);
    }

    @NonNull
    public Operator endAsOperator() {
        return Operator.op(this.end().getNameAlias());
    }

    boolean isEfficientCase() {
        return this.efficientCase;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)" CASE");
        if (this.isEfficientCase()) {
            queryBuilder.append((Object)(" " + BaseOperator.convertValueToString(this.caseColumn, false)));
        }
        queryBuilder.append((Object)QueryBuilder.join((CharSequence)"", this.caseConditions));
        if (this.elseSpecified) {
            queryBuilder.append((Object)" ELSE ").append((Object)BaseOperator.convertValueToString(this.elseValue, false));
        }
        if (this.endSpecified) {
            queryBuilder.append((Object)(" END " + (this.columnName != null ? this.columnName : "")));
        }
        return queryBuilder.getQuery();
    }
}

