/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database;

import android.content.Context;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.BaseDatabaseHelper;
import com.raizlabs.android.dbflow.structure.database.DatabaseHelperListener;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.OpenHelper;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DatabaseHelperDelegate
extends BaseDatabaseHelper {
    public static final String TEMP_DB_NAME = "temp-";
    private DatabaseHelperListener databaseHelperListener;
    @Nullable
    private final OpenHelper backupHelper;

    public static String getTempDbFileName(DatabaseDefinition databaseDefinition) {
        return TEMP_DB_NAME + databaseDefinition.getDatabaseName() + ".db";
    }

    public DatabaseHelperDelegate(DatabaseHelperListener databaseHelperListener, DatabaseDefinition databaseDefinition, @Nullable OpenHelper backupHelper) {
        super(databaseDefinition);
        this.databaseHelperListener = databaseHelperListener;
        this.backupHelper = backupHelper;
    }

    public void performRestoreFromBackup() {
        this.movePrepackagedDB(this.getDatabaseDefinition().getDatabaseFileName(), this.getDatabaseDefinition().getDatabaseFileName());
        if (this.getDatabaseDefinition().backupEnabled()) {
            if (this.backupHelper == null) {
                throw new IllegalStateException("the passed backup helper was null, even though backup is enabled. Ensure that its passed in.");
            }
            this.restoreDatabase(this.getTempDbFileName(), this.getDatabaseDefinition().getDatabaseFileName());
            this.backupHelper.getDatabase();
        }
    }

    public void setDatabaseHelperListener(DatabaseHelperListener databaseHelperListener) {
        this.databaseHelperListener = databaseHelperListener;
    }

    @Override
    public void onCreate(DatabaseWrapper db) {
        if (this.databaseHelperListener != null) {
            this.databaseHelperListener.onCreate(db);
        }
        super.onCreate(db);
    }

    @Override
    public void onUpgrade(DatabaseWrapper db, int oldVersion, int newVersion) {
        if (this.databaseHelperListener != null) {
            this.databaseHelperListener.onUpgrade(db, oldVersion, newVersion);
        }
        super.onUpgrade(db, oldVersion, newVersion);
    }

    @Override
    public void onOpen(DatabaseWrapper db) {
        if (this.databaseHelperListener != null) {
            this.databaseHelperListener.onOpen(db);
        }
        super.onOpen(db);
    }

    @Override
    public void onDowngrade(DatabaseWrapper db, int oldVersion, int newVersion) {
        if (this.databaseHelperListener != null) {
            this.databaseHelperListener.onDowngrade(db, oldVersion, newVersion);
        }
        super.onDowngrade(db, oldVersion, newVersion);
    }

    private String getTempDbFileName() {
        return DatabaseHelperDelegate.getTempDbFileName(this.getDatabaseDefinition());
    }

    public void movePrepackagedDB(String databaseName, String prepackagedName) {
        File dbPath = FlowManager.getContext().getDatabasePath(databaseName);
        if (dbPath.exists() && (!this.getDatabaseDefinition().areConsistencyChecksEnabled() || this.getDatabaseDefinition().areConsistencyChecksEnabled() && this.isDatabaseIntegrityOk(this.getWritableDatabase()))) {
            return;
        }
        dbPath.getParentFile().mkdirs();
        try {
            File existingDb = FlowManager.getContext().getDatabasePath(this.getTempDbFileName());
            InputStream inputStream = existingDb.exists() && (!this.getDatabaseDefinition().backupEnabled() || this.getDatabaseDefinition().backupEnabled() && this.backupHelper != null && this.isDatabaseIntegrityOk(this.backupHelper.getDatabase())) ? new FileInputStream(existingDb) : FlowManager.getContext().getAssets().open(prepackagedName);
            this.writeDB(dbPath, inputStream);
        }
        catch (IOException e) {
            FlowLog.log(FlowLog.Level.W, "Failed to open file", e);
        }
    }

    public boolean isDatabaseIntegrityOk() {
        return this.isDatabaseIntegrityOk(this.getWritableDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseIntegrityOk(DatabaseWrapper databaseWrapper) {
        boolean integrityOk = true;
        try (DatabaseStatement statement = null;){
            statement = databaseWrapper.compileStatement("PRAGMA quick_check(1)");
            String result = statement.simpleQueryForString();
            if (!result.equalsIgnoreCase("ok")) {
                FlowLog.log(FlowLog.Level.E, "PRAGMA integrity_check on " + this.getDatabaseDefinition().getDatabaseName() + " returned: " + result);
                integrityOk = false;
                if (this.getDatabaseDefinition().backupEnabled()) {
                    integrityOk = this.restoreBackUp();
                }
            }
        }
        return integrityOk;
    }

    public boolean restoreBackUp() {
        boolean success = true;
        File db = FlowManager.getContext().getDatabasePath(TEMP_DB_NAME + this.getDatabaseDefinition().getDatabaseName());
        File corrupt = FlowManager.getContext().getDatabasePath(this.getDatabaseDefinition().getDatabaseName());
        if (corrupt.delete()) {
            try {
                this.writeDB(corrupt, new FileInputStream(db));
            }
            catch (IOException e) {
                FlowLog.logError(e);
                success = false;
            }
        } else {
            FlowLog.log(FlowLog.Level.E, "Failed to delete DB");
        }
        return success;
    }

    private void writeDB(File dbPath, InputStream existingDB) throws IOException {
        int length;
        FileOutputStream output = new FileOutputStream(dbPath);
        byte[] buffer = new byte[1024];
        while ((length = existingDB.read(buffer)) > 0) {
            ((OutputStream)output).write(buffer, 0, length);
        }
        output.flush();
        ((OutputStream)output).close();
        existingDB.close();
    }

    public void restoreDatabase(String databaseName, String prepackagedName) {
        File dbPath = FlowManager.getContext().getDatabasePath(databaseName);
        if (dbPath.exists()) {
            return;
        }
        dbPath.getParentFile().mkdirs();
        try {
            File existingDb = FlowManager.getContext().getDatabasePath(this.getDatabaseDefinition().getDatabaseFileName());
            InputStream inputStream = existingDb.exists() && this.getDatabaseDefinition().backupEnabled() && this.backupHelper != null && this.isDatabaseIntegrityOk(this.backupHelper.getDatabase()) ? new FileInputStream(existingDb) : FlowManager.getContext().getAssets().open(prepackagedName);
            this.writeDB(dbPath, inputStream);
        }
        catch (IOException e) {
            FlowLog.logError(e);
        }
    }

    public void backupDB() {
        if (!this.getDatabaseDefinition().backupEnabled() || !this.getDatabaseDefinition().areConsistencyChecksEnabled()) {
            throw new IllegalStateException("Backups are not enabled for : " + this.getDatabaseDefinition().getDatabaseName() + ". Please consider adding both backupEnabled and consistency checks enabled to the Database annotation");
        }
        this.getDatabaseDefinition().beginTransactionAsync(new ITransaction(){

            @Override
            public void execute(DatabaseWrapper databaseWrapper) {
                Context context = FlowManager.getContext();
                File backup = context.getDatabasePath(DatabaseHelperDelegate.this.getTempDbFileName());
                File temp = context.getDatabasePath("temp--2-" + DatabaseHelperDelegate.this.getDatabaseDefinition().getDatabaseFileName());
                if (temp.exists()) {
                    temp.delete();
                }
                backup.renameTo(temp);
                if (backup.exists()) {
                    backup.delete();
                }
                File existing = context.getDatabasePath(DatabaseHelperDelegate.this.getDatabaseDefinition().getDatabaseFileName());
                try {
                    backup.getParentFile().mkdirs();
                    DatabaseHelperDelegate.this.writeDB(backup, new FileInputStream(existing));
                    temp.delete();
                }
                catch (Exception e) {
                    FlowLog.logError(e);
                }
            }
        }).build().execute();
    }

    public DatabaseWrapper getWritableDatabase() {
        return this.getDatabaseDefinition().getWritableDatabase();
    }
}

