/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseStatement;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.FlowCursor;

public class AndroidDatabase
implements DatabaseWrapper {
    private final SQLiteDatabase database;

    public static AndroidDatabase from(SQLiteDatabase database) {
        return new AndroidDatabase(database);
    }

    AndroidDatabase(@NonNull SQLiteDatabase database) {
        this.database = database;
    }

    @Override
    public void execSQL(String query) {
        this.database.execSQL(query);
    }

    @Override
    public void beginTransaction() {
        this.database.beginTransaction();
    }

    @Override
    public void setTransactionSuccessful() {
        this.database.setTransactionSuccessful();
    }

    @Override
    public void endTransaction() {
        this.database.endTransaction();
    }

    @Override
    public int getVersion() {
        return this.database.getVersion();
    }

    public SQLiteDatabase getDatabase() {
        return this.database;
    }

    @Override
    public DatabaseStatement compileStatement(String rawQuery) {
        return AndroidDatabaseStatement.from(this.database.compileStatement(rawQuery), this.database);
    }

    @Override
    public FlowCursor rawQuery(String query, String[] selectionArgs) {
        return FlowCursor.from(this.database.rawQuery(query, selectionArgs));
    }

    @Override
    public long updateWithOnConflict(String tableName, ContentValues contentValues, String where, String[] whereArgs, int conflictAlgorithm) {
        long count = Build.VERSION.SDK_INT >= 8 ? (long)this.database.updateWithOnConflict(tableName, contentValues, where, whereArgs, conflictAlgorithm) : (long)this.database.update(tableName, contentValues, where, whereArgs);
        return count;
    }

    @Override
    public long insertWithOnConflict(String tableName, String nullColumnHack, ContentValues values, int sqLiteDatabaseAlgorithmInt) {
        long count = Build.VERSION.SDK_INT >= 8 ? this.database.insertWithOnConflict(tableName, nullColumnHack, values, sqLiteDatabaseAlgorithmInt) : this.database.insert(tableName, nullColumnHack, values);
        return count;
    }

    @Override
    public FlowCursor query(@NonNull String tableName, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        return FlowCursor.from(this.database.query(tableName, columns, selection, selectionArgs, groupBy, having, orderBy));
    }

    @Override
    public int delete(@NonNull String tableName, @Nullable String whereClause, @Nullable String[] whereArgs) {
        return this.database.delete(tableName, whereClause, whereArgs);
    }
}

