/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.StringUtils;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;

public class UnSafeStringOperator
implements SQLOperator,
Query {
    private final String conditionString;
    private String separator = "";

    public UnSafeStringOperator(String selection, String[] selectionArgs) {
        String newSelection = selection;
        if (newSelection != null) {
            for (String selectionArg : selectionArgs) {
                newSelection = newSelection.replaceFirst("\\?", selectionArg);
            }
        }
        this.conditionString = newSelection;
    }

    @Override
    public void appendConditionToQuery(QueryBuilder queryBuilder) {
        queryBuilder.append((Object)this.conditionString);
    }

    @Override
    public String columnName() {
        return "";
    }

    @Override
    public String separator() {
        return this.separator;
    }

    @Override
    @NonNull
    public SQLOperator separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public boolean hasSeparator() {
        return StringUtils.isNotNullOrEmpty((String)this.separator);
    }

    @Override
    public String operation() {
        return "";
    }

    @Override
    public Object value() {
        return "";
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder();
        this.appendConditionToQuery(queryBuilder);
        return queryBuilder.getQuery();
    }
}

