/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseOperator;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.sql.language.From;
import com.raizlabs.android.dbflow.sql.language.OperatorGroup;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Insert<TModel>
extends BaseQueriable<TModel>
implements Query {
    private IProperty[] columns;
    private List<Collection<Object>> valuesList;
    private ConflictAction conflictAction = ConflictAction.NONE;
    private From<?> selectFrom;

    public Insert(Class<TModel> table) {
        super(table);
    }

    @NonNull
    public Insert<TModel> columns(String ... columns) {
        this.columns = new IProperty[columns.length];
        ModelAdapter modelClassModelAdapter = FlowManager.getModelAdapter(this.getTable());
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            this.columns[i] = modelClassModelAdapter.getProperty(column);
        }
        return this;
    }

    @NonNull
    public Insert<TModel> columns(IProperty ... properties) {
        this.columns = new IProperty[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.columns[i] = properties[i];
        }
        return this;
    }

    @NonNull
    public Insert<TModel> columns(@NonNull List<IProperty> properties) {
        return this.columns(properties.toArray(new IProperty[properties.size()]));
    }

    @NonNull
    public Insert<TModel> asColumns() {
        this.columns(FlowManager.getModelAdapter(this.getTable()).getAllColumnProperties());
        return this;
    }

    @NonNull
    public Insert<TModel> asColumnValues() {
        this.asColumns();
        if (this.columns != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < this.columns.length; ++i) {
                values.add("?");
            }
            this.valuesList.add(values);
        }
        return this;
    }

    @NonNull
    public Insert<TModel> values(Object ... values) {
        if (this.valuesList == null) {
            this.valuesList = new ArrayList<Collection<Object>>();
        }
        this.valuesList.add(Arrays.asList(values));
        return this;
    }

    @NonNull
    public Insert<TModel> values(Collection<Object> values) {
        if (this.valuesList == null) {
            this.valuesList = new ArrayList<Collection<Object>>();
        }
        this.valuesList.add(values);
        return this;
    }

    @NonNull
    public Insert<TModel> columnValues(SQLOperator ... conditions) {
        String[] columns = new String[conditions.length];
        Object[] values = new Object[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            SQLOperator condition = conditions[i];
            columns[i] = condition.columnName();
            values[i] = condition.value();
        }
        return this.columns(columns).values(values);
    }

    @NonNull
    public Insert<TModel> columnValues(OperatorGroup operatorGroup) {
        int size = operatorGroup.size();
        String[] columns = new String[size];
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            SQLOperator condition = operatorGroup.getConditions().get(i);
            columns[i] = condition.columnName();
            values[i] = condition.value();
        }
        return this.columns(columns).values(values);
    }

    @NonNull
    public Insert<TModel> columnValues(ContentValues contentValues) {
        Set entries = contentValues.valueSet();
        int count = 0;
        String[] columns = new String[contentValues.size()];
        Object[] values = new Object[contentValues.size()];
        for (Map.Entry entry : entries) {
            String key;
            columns[count] = key = (String)entry.getKey();
            values[count] = contentValues.get(key);
            ++count;
        }
        return this.columns(columns).values(values);
    }

    @NonNull
    public Insert<TModel> select(From<?> selectFrom) {
        this.selectFrom = selectFrom;
        return this;
    }

    @NonNull
    public Insert<TModel> or(ConflictAction action) {
        this.conflictAction = action;
        return this;
    }

    @NonNull
    public Insert<TModel> orReplace() {
        return this.or(ConflictAction.REPLACE);
    }

    @NonNull
    public Insert<TModel> orRollback() {
        return this.or(ConflictAction.ROLLBACK);
    }

    @NonNull
    public Insert<TModel> orAbort() {
        return this.or(ConflictAction.ABORT);
    }

    @NonNull
    public Insert<TModel> orFail() {
        return this.or(ConflictAction.FAIL);
    }

    @NonNull
    public Insert<TModel> orIgnore() {
        return this.or(ConflictAction.IGNORE);
    }

    @Override
    public long executeUpdateDelete(DatabaseWrapper databaseWrapper) {
        throw new IllegalStateException("Cannot call executeUpdateDelete() from an Insert");
    }

    @Override
    public long executeUpdateDelete() {
        throw new IllegalStateException("Cannot call executeUpdateDelete() from an Insert");
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)"INSERT ");
        if (this.conflictAction != null && !this.conflictAction.equals((Object)ConflictAction.NONE)) {
            queryBuilder.append((Object)"OR").appendSpaceSeparated((Object)this.conflictAction);
        }
        queryBuilder.append((Object)"INTO").appendSpace().append((Object)FlowManager.getTableName(this.getTable()));
        if (this.columns != null) {
            queryBuilder.append((Object)"(").appendArray((Object[])this.columns).append((Object)")");
        }
        if (this.selectFrom != null) {
            queryBuilder.appendSpace().append((Object)this.selectFrom.getQuery());
        } else {
            if (this.valuesList == null || this.valuesList.size() < 1) {
                throw new IllegalStateException("The insert of " + FlowManager.getTableName(this.getTable()) + " should haveat least one value specified for the insert");
            }
            if (this.columns != null) {
                for (Collection<Object> values : this.valuesList) {
                    if (values.size() == this.columns.length) continue;
                    throw new IllegalStateException("The Insert of " + FlowManager.getTableName(this.getTable()) + " when specifyingcolumns needs to have the same amount of values and columns");
                }
            }
            queryBuilder.append((Object)" VALUES(");
            for (int i = 0; i < this.valuesList.size(); ++i) {
                if (i > 0) {
                    queryBuilder.append((Object)",(");
                }
                queryBuilder.append((Object)BaseOperator.joinArguments((CharSequence)", ", this.valuesList.get(i))).append((Object)")");
            }
        }
        return queryBuilder.getQuery();
    }

    @Override
    public BaseModel.Action getPrimaryAction() {
        return BaseModel.Action.INSERT;
    }
}

