/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.list.FlowCursorIterator;
import com.raizlabs.android.dbflow.list.IFlowCursorIterator;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import java.util.ArrayList;
import java.util.List;

public class CursorResult<TModel>
implements IFlowCursorIterator<TModel> {
    private final InstanceAdapter<TModel> retrievalAdapter;
    @Nullable
    private Cursor cursor;

    CursorResult(Class<TModel> modelClass, @Nullable Cursor cursor) {
        this.cursor = cursor;
        this.retrievalAdapter = FlowManager.getInstanceAdapter(modelClass);
    }

    public void swapCursor(@Nullable Cursor cursor) {
        if (this.cursor != null && !this.cursor.isClosed()) {
            this.cursor.close();
        }
        this.cursor = cursor;
    }

    @NonNull
    public List<TModel> toList() {
        return this.cursor != null ? this.retrievalAdapter.getListModelLoader().convertToData(this.cursor, null) : new ArrayList();
    }

    @NonNull
    public List<TModel> toListClose() {
        ArrayList list = this.cursor != null ? this.retrievalAdapter.getListModelLoader().load(this.cursor) : new ArrayList();
        this.close();
        return list;
    }

    @NonNull
    public <TCustom> List<TCustom> toCustomList(Class<TCustom> customClass) {
        return this.cursor != null ? FlowManager.getQueryModelAdapter(customClass).getListModelLoader().convertToData(this.cursor, null) : new ArrayList();
    }

    @NonNull
    public <TCustom> List<TCustom> toCustomListClose(Class<TCustom> customClass) {
        ArrayList customList = this.cursor != null ? FlowManager.getQueryModelAdapter(customClass).getListModelLoader().load(this.cursor) : new ArrayList();
        this.close();
        return customList;
    }

    @Nullable
    public TModel toModel() {
        return this.cursor != null ? this.retrievalAdapter.getSingleModelLoader().convertToData(this.cursor, (Object)null) : null;
    }

    @Nullable
    public TModel toModelClose() {
        TModel model = this.cursor != null ? (TModel)this.retrievalAdapter.getSingleModelLoader().load(this.cursor) : null;
        this.close();
        return model;
    }

    @Nullable
    public <TCustom> TCustom toCustomModel(Class<TCustom> customClass) {
        return this.cursor != null ? FlowManager.getQueryModelAdapter(customClass).getSingleModelLoader().convertToData(this.cursor, (Object)null) : null;
    }

    @Nullable
    public <TCustom> TCustom toCustomModelClose(Class<TCustom> customClass) {
        TCustom customList = this.cursor != null ? (TCustom)FlowManager.getQueryModelAdapter(customClass).getSingleModelLoader().load(this.cursor) : null;
        this.close();
        return customList;
    }

    @Override
    @Nullable
    public TModel getItem(long position) {
        Object model = null;
        if (this.cursor != null && this.cursor.moveToPosition((int)position)) {
            model = this.retrievalAdapter.getSingleModelLoader().convertToData(this.cursor, null, false);
        }
        return model;
    }

    @Override
    public FlowCursorIterator<TModel> iterator() {
        return new FlowCursorIterator(this);
    }

    @Override
    public FlowCursorIterator<TModel> iterator(int startingLocation, long limit) {
        return new FlowCursorIterator(this, startingLocation, limit);
    }

    @Override
    public long getCount() {
        return this.cursor == null ? 0L : (long)this.cursor.getCount();
    }

    @Override
    @Nullable
    public Cursor cursor() {
        return this.cursor;
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

