/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabase;
import com.raizlabs.android.dbflow.structure.database.BaseDatabaseHelper;
import com.raizlabs.android.dbflow.structure.database.DatabaseHelperDelegate;
import com.raizlabs.android.dbflow.structure.database.DatabaseHelperListener;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.OpenHelper;

public class FlowSQLiteOpenHelper
extends SQLiteOpenHelper
implements OpenHelper {
    private DatabaseHelperDelegate databaseHelperDelegate;
    private AndroidDatabase androidDatabase;

    public FlowSQLiteOpenHelper(DatabaseDefinition databaseDefinition, DatabaseHelperListener listener) {
        super(FlowManager.getContext(), databaseDefinition.isInMemory() ? null : databaseDefinition.getDatabaseFileName(), null, databaseDefinition.getDatabaseVersion());
        BackupHelper backupHelper = null;
        if (databaseDefinition.backupEnabled()) {
            backupHelper = new BackupHelper(FlowManager.getContext(), DatabaseHelperDelegate.getTempDbFileName(databaseDefinition), databaseDefinition.getDatabaseVersion(), databaseDefinition);
        }
        this.databaseHelperDelegate = new DatabaseHelperDelegate(listener, databaseDefinition, backupHelper);
    }

    @Override
    public void performRestoreFromBackup() {
        this.databaseHelperDelegate.performRestoreFromBackup();
    }

    @Override
    public DatabaseHelperDelegate getDelegate() {
        return this.databaseHelperDelegate;
    }

    @Override
    public boolean isDatabaseIntegrityOk() {
        return this.databaseHelperDelegate.isDatabaseIntegrityOk();
    }

    @Override
    public void backupDB() {
        this.databaseHelperDelegate.backupDB();
    }

    @Override
    public DatabaseWrapper getDatabase() {
        if (this.androidDatabase == null || !this.androidDatabase.getDatabase().isOpen()) {
            this.androidDatabase = AndroidDatabase.from(this.getWritableDatabase());
        }
        return this.androidDatabase;
    }

    @Override
    public void setDatabaseListener(DatabaseHelperListener listener) {
        this.databaseHelperDelegate.setDatabaseHelperListener(listener);
    }

    public void onCreate(SQLiteDatabase db) {
        this.databaseHelperDelegate.onCreate(AndroidDatabase.from(db));
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.databaseHelperDelegate.onUpgrade(AndroidDatabase.from(db), oldVersion, newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
        this.databaseHelperDelegate.onOpen(AndroidDatabase.from(db));
    }

    @Override
    public void closeDB() {
        this.getDatabase();
        this.androidDatabase.getDatabase().close();
    }

    private class BackupHelper
    extends SQLiteOpenHelper
    implements OpenHelper {
        private AndroidDatabase androidDatabase;
        private final BaseDatabaseHelper baseDatabaseHelper;

        public BackupHelper(Context context, String name, int version, DatabaseDefinition databaseDefinition) {
            super(context, name, null, version);
            this.baseDatabaseHelper = new BaseDatabaseHelper(databaseDefinition);
        }

        @Override
        public DatabaseWrapper getDatabase() {
            if (this.androidDatabase == null) {
                this.androidDatabase = AndroidDatabase.from(this.getWritableDatabase());
            }
            return this.androidDatabase;
        }

        @Override
        public void performRestoreFromBackup() {
        }

        @Override
        public DatabaseHelperDelegate getDelegate() {
            return null;
        }

        @Override
        public boolean isDatabaseIntegrityOk() {
            return false;
        }

        @Override
        public void backupDB() {
        }

        @Override
        public void setDatabaseListener(DatabaseHelperListener helperListener) {
        }

        public void onCreate(SQLiteDatabase db) {
            this.baseDatabaseHelper.onCreate(AndroidDatabase.from(db));
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.baseDatabaseHelper.onUpgrade(AndroidDatabase.from(db), oldVersion, newVersion);
        }

        public void onOpen(SQLiteDatabase db) {
            this.baseDatabaseHelper.onOpen(AndroidDatabase.from(db));
        }

        @Override
        public void closeDB() {
        }
    }
}

