/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database.transaction;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.structure.InternalAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class FastStoreModelTransaction<TModel>
implements ITransaction {
    final List<TModel> models;
    final ProcessModelList<TModel> processModelList;
    final InternalAdapter<TModel> internalAdapter;

    public static <TModel> Builder<TModel> saveBuilder(@NonNull InternalAdapter<TModel> internalAdapter) {
        return new Builder<TModel>(new ProcessModelList<TModel>(){

            @Override
            public void processModel(@NonNull List<TModel> tModels, InternalAdapter<TModel> adapter, DatabaseWrapper wrapper) {
                adapter.saveAll(tModels, wrapper);
            }
        }, internalAdapter);
    }

    public static <TModel> Builder<TModel> insertBuilder(@NonNull InternalAdapter<TModel> internalAdapter) {
        return new Builder<TModel>(new ProcessModelList<TModel>(){

            @Override
            public void processModel(@NonNull List<TModel> tModels, InternalAdapter<TModel> adapter, DatabaseWrapper wrapper) {
                adapter.insertAll(tModels, wrapper);
            }
        }, internalAdapter);
    }

    public static <TModel> Builder<TModel> updateBuilder(@NonNull InternalAdapter<TModel> internalAdapter) {
        return new Builder<TModel>(new ProcessModelList<TModel>(){

            @Override
            public void processModel(@NonNull List<TModel> tModels, InternalAdapter<TModel> adapter, DatabaseWrapper wrapper) {
                adapter.updateAll(tModels, wrapper);
            }
        }, internalAdapter);
    }

    FastStoreModelTransaction(Builder<TModel> builder) {
        this.models = builder.models;
        this.processModelList = ((Builder)builder).processModelList;
        this.internalAdapter = ((Builder)builder).internalAdapter;
    }

    @Override
    public void execute(DatabaseWrapper databaseWrapper) {
        if (this.models != null) {
            this.processModelList.processModel(this.models, this.internalAdapter, databaseWrapper);
        }
    }

    public static final class Builder<TModel> {
        private final ProcessModelList<TModel> processModelList;
        @NonNull
        private final InternalAdapter<TModel> internalAdapter;
        List<TModel> models = new ArrayList<TModel>();

        Builder(@NonNull ProcessModelList<TModel> processModelList, @NonNull InternalAdapter<TModel> internalAdapter) {
            this.processModelList = processModelList;
            this.internalAdapter = internalAdapter;
        }

        public Builder<TModel> add(TModel model) {
            this.models.add(model);
            return this;
        }

        @SafeVarargs
        public final Builder<TModel> addAll(TModel ... models) {
            this.models.addAll(Arrays.asList(models));
            return this;
        }

        public Builder<TModel> addAll(Collection<? extends TModel> models) {
            if (models != null) {
                this.models.addAll(models);
            }
            return this;
        }

        public FastStoreModelTransaction<TModel> build() {
            return new FastStoreModelTransaction(this);
        }
    }

    static interface ProcessModelList<TModel> {
        public void processModel(@NonNull List<TModel> var1, InternalAdapter<TModel> var2, DatabaseWrapper var3);
    }
}

