/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import com.raizlabs.android.dbflow.StringUtils;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;

public class NameAlias
implements Query {
    private final String name;
    private final String aliasName;
    private final String tableName;
    private final String keyword;
    private final boolean shouldStripIdentifier;
    private final boolean shouldStripAliasName;
    private final boolean shouldAddIdentifierToQuery;
    private final boolean shouldAddIdentifierToAliasName;

    public static NameAlias joinNames(String operation, String ... names) {
        if (names.length == 0) {
            return null;
        }
        String newName = "";
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                newName = newName + " " + operation + " ";
            }
            newName = newName + names[i];
        }
        return NameAlias.rawBuilder(newName).build();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder rawBuilder(String name) {
        return new Builder(name).shouldStripIdentifier(false).shouldAddIdentifierToName(false);
    }

    private NameAlias(Builder builder) {
        this.name = builder.shouldStripIdentifier ? QueryBuilder.stripQuotes((String)builder.name) : builder.name;
        this.keyword = builder.keyword;
        this.aliasName = builder.shouldStripAliasName ? QueryBuilder.stripQuotes((String)builder.aliasName) : builder.aliasName;
        this.tableName = StringUtils.isNotNullOrEmpty((String)builder.tableName) ? QueryBuilder.quoteIfNeeded((String)builder.tableName) : null;
        this.shouldStripIdentifier = builder.shouldStripIdentifier;
        this.shouldStripAliasName = builder.shouldStripAliasName;
        this.shouldAddIdentifierToQuery = builder.shouldAddIdentifierToQuery;
        this.shouldAddIdentifierToAliasName = builder.shouldAddIdentifierToAliasName;
    }

    public String name() {
        return StringUtils.isNotNullOrEmpty((String)this.name) && this.shouldAddIdentifierToQuery ? QueryBuilder.quoteIfNeeded((String)this.name) : this.name;
    }

    public String nameRaw() {
        return this.shouldStripIdentifier ? this.name : QueryBuilder.stripQuotes((String)this.name);
    }

    public String aliasName() {
        return StringUtils.isNotNullOrEmpty((String)this.aliasName) && this.shouldAddIdentifierToAliasName ? QueryBuilder.quoteIfNeeded((String)this.aliasName) : this.aliasName;
    }

    public String aliasNameRaw() {
        return this.shouldStripAliasName ? this.aliasName : QueryBuilder.stripQuotes((String)this.aliasName);
    }

    public String tableName() {
        return this.tableName;
    }

    public String keyword() {
        return this.keyword;
    }

    public boolean shouldStripIdentifier() {
        return this.shouldStripIdentifier;
    }

    public boolean shouldStripAliasName() {
        return this.shouldStripAliasName;
    }

    public String fullName() {
        return (StringUtils.isNotNullOrEmpty((String)this.tableName) ? this.tableName() + "." : "") + this.name();
    }

    public String getQuery() {
        if (StringUtils.isNotNullOrEmpty((String)this.aliasName)) {
            return this.aliasName();
        }
        if (StringUtils.isNotNullOrEmpty((String)this.name)) {
            return this.fullName();
        }
        return "";
    }

    public String getNameAsKey() {
        if (StringUtils.isNotNullOrEmpty((String)this.aliasName)) {
            return this.aliasNameRaw();
        }
        return this.nameRaw();
    }

    public String toString() {
        return this.getFullQuery();
    }

    public String getFullQuery() {
        String query = this.fullName();
        if (StringUtils.isNotNullOrEmpty((String)this.aliasName)) {
            query = query + " AS " + this.aliasName();
        }
        if (StringUtils.isNotNullOrEmpty((String)this.keyword)) {
            query = this.keyword + " " + query;
        }
        return query;
    }

    public Builder newBuilder() {
        return new Builder(this.name).keyword(this.keyword).as(this.aliasName).shouldStripAliasName(this.shouldStripAliasName).shouldStripIdentifier(this.shouldStripIdentifier).shouldAddIdentifierToName(this.shouldAddIdentifierToQuery).shouldAddIdentifierToAliasName(this.shouldAddIdentifierToAliasName).withTable(this.tableName);
    }

    public static class Builder {
        private final String name;
        private String aliasName;
        private String tableName;
        private boolean shouldStripIdentifier = true;
        private boolean shouldStripAliasName = true;
        private boolean shouldAddIdentifierToQuery = true;
        private boolean shouldAddIdentifierToAliasName = true;
        private String keyword;

        public Builder(String name) {
            this.name = name;
        }

        public Builder distinct() {
            return this.keyword("DISTINCT");
        }

        public Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public Builder as(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public Builder withTable(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder shouldStripIdentifier(boolean shouldStripIdentifier) {
            this.shouldStripIdentifier = shouldStripIdentifier;
            return this;
        }

        public Builder shouldStripAliasName(boolean shouldStripAliasName) {
            this.shouldStripAliasName = shouldStripAliasName;
            return this;
        }

        public Builder shouldAddIdentifierToName(boolean shouldAddIdentifierToName) {
            this.shouldAddIdentifierToQuery = shouldAddIdentifierToName;
            return this;
        }

        public Builder shouldAddIdentifierToAliasName(boolean shouldAddIdentifierToAliasName) {
            this.shouldAddIdentifierToAliasName = shouldAddIdentifierToAliasName;
            return this;
        }

        public NameAlias build() {
            return new NameAlias(this);
        }
    }
}

