/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.Cursor;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.IndexedBy;
import com.raizlabs.android.dbflow.sql.language.Join;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Transformable;
import com.raizlabs.android.dbflow.sql.language.Update;
import com.raizlabs.android.dbflow.sql.language.Where;
import com.raizlabs.android.dbflow.sql.language.WhereBase;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.language.property.IndexProperty;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.List;

public class From<TModel>
extends BaseModelQueriable<TModel>
implements WhereBase<TModel>,
ModelQueriable<TModel>,
Transformable<TModel> {
    private Query queryBase;
    private NameAlias tableAlias;
    private List<Join> joins = new ArrayList<Join>();

    public From(Query querybase, Class<TModel> table) {
        super(table);
        this.queryBase = querybase;
        this.tableAlias = new NameAlias.Builder(FlowManager.getTableName(table)).build();
    }

    public From<TModel> as(String alias) {
        this.tableAlias = this.tableAlias.newBuilder().as(alias).build();
        return this;
    }

    public <TJoin> Join<TJoin, TModel> join(Class<TJoin> table, @NonNull Join.JoinType joinType) {
        Join join = new Join(this, table, joinType);
        this.joins.add(join);
        return join;
    }

    public <TJoin> Join<TJoin, TModel> join(ModelQueriable<TJoin> modelQueriable, @NonNull Join.JoinType joinType) {
        Join join = new Join(this, joinType, modelQueriable);
        this.joins.add(join);
        return join;
    }

    public <TJoin> Join<TJoin, TModel> crossJoin(Class<TJoin> table) {
        return this.join(table, Join.JoinType.CROSS);
    }

    public <TJoin> Join<TJoin, TModel> crossJoin(ModelQueriable<TJoin> modelQueriable) {
        return this.join(modelQueriable, Join.JoinType.CROSS);
    }

    public <TJoin> Join<TJoin, TModel> innerJoin(Class<TJoin> table) {
        return this.join(table, Join.JoinType.INNER);
    }

    public <TJoin> Join<TJoin, TModel> innerJoin(ModelQueriable<TJoin> modelQueriable) {
        return this.join(modelQueriable, Join.JoinType.INNER);
    }

    public <TJoin> Join<TJoin, TModel> leftOuterJoin(Class<TJoin> table) {
        return this.join(table, Join.JoinType.LEFT_OUTER);
    }

    public <TJoin> Join<TJoin, TModel> leftOuterJoin(ModelQueriable<TJoin> modelQueriable) {
        return this.join(modelQueriable, Join.JoinType.LEFT_OUTER);
    }

    public Where<TModel> where() {
        return new Where(this, new SQLCondition[0]);
    }

    public Where<TModel> where(SQLCondition ... conditions) {
        return this.where().andAll(conditions);
    }

    @Override
    public Cursor query() {
        return this.where().query();
    }

    @Override
    public Cursor query(DatabaseWrapper databaseWrapper) {
        return this.where().query(databaseWrapper);
    }

    @Override
    public long count() {
        return this.where().count();
    }

    @Override
    public long count(DatabaseWrapper databaseWrapper) {
        return this.where().count(databaseWrapper);
    }

    @Override
    public long executeUpdateDelete(DatabaseWrapper databaseWrapper) {
        return this.where().executeUpdateDelete(databaseWrapper);
    }

    public IndexedBy<TModel> indexedBy(IndexProperty<TModel> indexProperty) {
        return new IndexedBy<TModel>(indexProperty, this);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)this.queryBase.getQuery());
        if (!(this.queryBase instanceof Update)) {
            queryBuilder.append((Object)"FROM ");
        }
        queryBuilder.append((Object)this.tableAlias);
        if (this.queryBase instanceof Select) {
            for (Join join : this.joins) {
                queryBuilder.appendSpace();
                queryBuilder.append((Object)join.getQuery());
            }
        } else {
            queryBuilder.appendSpace();
        }
        return queryBuilder.getQuery();
    }

    @Override
    public Query getQueryBuilderBase() {
        return this.queryBase;
    }

    @Override
    public Where<TModel> groupBy(NameAlias ... nameAliases) {
        return this.where().groupBy(nameAliases);
    }

    @Override
    public Where<TModel> groupBy(IProperty ... properties) {
        return this.where().groupBy(properties);
    }

    @Override
    public Where<TModel> orderBy(NameAlias nameAlias, boolean ascending) {
        return this.where().orderBy(nameAlias, ascending);
    }

    @Override
    public Where<TModel> orderBy(IProperty property, boolean ascending) {
        return this.where().orderBy(property, ascending);
    }

    @Override
    public Where<TModel> orderBy(OrderBy orderBy) {
        return this.where().orderBy(orderBy);
    }

    @Override
    public Where<TModel> limit(int count) {
        return this.where().limit(count);
    }

    @Override
    public Where<TModel> offset(int offset) {
        return this.where().offset(offset);
    }

    @Override
    public Where<TModel> having(SQLCondition ... conditions) {
        return this.where().having(conditions);
    }
}

