/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseCondition;
import com.raizlabs.android.dbflow.sql.language.Case;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class CaseCondition<TReturn>
implements Query {
    private final Case<TReturn> caze;
    private TReturn whenValue;
    private SQLCondition sqlCondition;
    private TReturn thenValue;
    private IProperty property;
    private IProperty thenProperty;
    private boolean isThenPropertySet;

    CaseCondition(Case<TReturn> caze, @NonNull SQLCondition sqlCondition) {
        this.caze = caze;
        this.sqlCondition = sqlCondition;
    }

    CaseCondition(Case<TReturn> caze, TReturn whenValue) {
        this.caze = caze;
        this.whenValue = whenValue;
    }

    CaseCondition(Case<TReturn> caze, @NonNull IProperty property) {
        this.caze = caze;
        this.property = property;
    }

    public Case<TReturn> then(TReturn value) {
        this.thenValue = value;
        return this.caze;
    }

    public Case<TReturn> then(IProperty value) {
        this.thenProperty = value;
        this.isThenPropertySet = true;
        return this.caze;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)" WHEN ");
        if (this.caze.isEfficientCase()) {
            queryBuilder.append((Object)BaseCondition.convertValueToString(this.property != null ? this.property : this.whenValue, false));
        } else {
            this.sqlCondition.appendConditionToQuery(queryBuilder);
        }
        queryBuilder.append((Object)" THEN ").append((Object)BaseCondition.convertValueToString(this.isThenPropertySet ? this.thenProperty : this.thenValue, false));
        return queryBuilder.getQuery();
    }

    public String toString() {
        return this.getQuery();
    }
}

