/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

abstract class PrimitiveProperty<P extends IProperty>
extends BaseProperty<P> {
    protected PrimitiveProperty(Class<?> table, NameAlias nameAlias) {
        super(table, nameAlias);
    }

    public Condition is(P property) {
        return Condition.column(this.nameAlias).is(property);
    }

    public Condition isNot(P property) {
        return Condition.column(this.nameAlias).isNot(property);
    }

    public Condition eq(P property) {
        return this.is(property);
    }

    public Condition notEq(P property) {
        return this.isNot(property);
    }

    public Condition greaterThan(P property) {
        return Condition.column(this.nameAlias).greaterThan(property);
    }

    public Condition greaterThanOrEq(P property) {
        return Condition.column(this.nameAlias).greaterThanOrEq(property);
    }

    public Condition lessThan(P property) {
        return Condition.column(this.nameAlias).lessThan(property);
    }

    public Condition lessThanOrEq(P property) {
        return Condition.column(this.nameAlias).lessThanOrEq(property);
    }

    @Override
    public P as(String aliasName) {
        return this.newPropertyInstance(this.table, this.nameAlias.newBuilder().as(aliasName).build());
    }

    @Override
    public P plus(IProperty iProperty) {
        return this.newPropertyInstance(this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public P minus(IProperty iProperty) {
        return this.newPropertyInstance(this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public P dividedBy(IProperty iProperty) {
        return this.newPropertyInstance(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public P multipliedBy(IProperty iProperty) {
        return this.newPropertyInstance(this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public P mod(IProperty iProperty) {
        return this.newPropertyInstance(this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public P concatenate(IProperty iProperty) {
        return this.newPropertyInstance(this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public P distinct() {
        return this.newPropertyInstance(this.table, this.getDistinctAliasName());
    }

    @Override
    public P withTable(NameAlias tableNameAlias) {
        return this.newPropertyInstance(this.table, this.nameAlias.newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    protected abstract P newPropertyInstance(Class<?> var1, NameAlias var2);
}

