/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database.transaction;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.raizlabs.android.dbflow.structure.database.transaction.ITransaction;
import com.raizlabs.android.dbflow.structure.database.transaction.Transaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ProcessModelTransaction<TModel>
implements ITransaction {
    final OnModelProcessListener<TModel> processListener;
    final List<TModel> models;
    final ProcessModel<TModel> processModel;
    final boolean runProcessListenerOnSameThread;

    ProcessModelTransaction(Builder<TModel> builder) {
        this.processListener = builder.processListener;
        this.models = builder.models;
        this.processModel = ((Builder)builder).processModel;
        this.runProcessListenerOnSameThread = ((Builder)builder).runProcessListenerOnSameThread;
    }

    @Override
    public void execute(DatabaseWrapper databaseWrapper) {
        if (this.models != null) {
            final int size = this.models.size();
            for (int i = 0; i < size; ++i) {
                final TModel model = this.models.get(i);
                this.processModel.processModel(model);
                if (this.processListener == null) continue;
                if (this.runProcessListenerOnSameThread) {
                    this.processListener.onModelProcessed(i, size, model);
                    continue;
                }
                final int finalI = i;
                Transaction.getTransactionHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ProcessModelTransaction.this.processListener.onModelProcessed(finalI, size, model);
                    }
                });
            }
        }
    }

    public static final class Builder<TModel> {
        private final ProcessModel<TModel> processModel;
        OnModelProcessListener<TModel> processListener;
        List<TModel> models = new ArrayList<TModel>();
        private boolean runProcessListenerOnSameThread;

        public Builder(@NonNull ProcessModel<TModel> processModel) {
            this.processModel = processModel;
        }

        public Builder(Collection<TModel> models, @NonNull ProcessModel<TModel> processModel) {
            this.processModel = processModel;
            this.models = new ArrayList<TModel>(models);
        }

        public Builder<TModel> add(TModel model) {
            this.models.add(model);
            return this;
        }

        @SafeVarargs
        public final Builder<TModel> addAll(TModel ... models) {
            this.models.addAll(Arrays.asList(models));
            return this;
        }

        public Builder<TModel> addAll(Collection<? extends TModel> models) {
            if (models != null) {
                this.models.addAll(models);
            }
            return this;
        }

        public Builder<TModel> processListener(OnModelProcessListener<TModel> processListener) {
            this.processListener = processListener;
            return this;
        }

        public Builder<TModel> runProcessListenerOnSameThread(boolean runProcessListenerOnSameThread) {
            this.runProcessListenerOnSameThread = runProcessListenerOnSameThread;
            return this;
        }

        public ProcessModelTransaction<TModel> build() {
            return new ProcessModelTransaction(this);
        }
    }

    public static interface OnModelProcessListener<TModel> {
        public void onModelProcessed(long var1, long var3, TModel var5);
    }

    public static interface ProcessModel<TModel> {
        public void processModel(TModel var1);
    }
}

