/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.Cursor;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.BaseModelQueriable;
import com.raizlabs.android.dbflow.sql.language.ConditionGroup;
import com.raizlabs.android.dbflow.sql.language.ExistenceCondition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.OrderBy;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.sql.language.Select;
import com.raizlabs.android.dbflow.sql.language.Transformable;
import com.raizlabs.android.dbflow.sql.language.WhereBase;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Where<TModel>
extends BaseModelQueriable<TModel>
implements Query,
ModelQueriable<TModel>,
Transformable<TModel> {
    private static final int VALUE_UNSET = -1;
    private final WhereBase<TModel> whereBase;
    private ConditionGroup conditionGroup;
    private final List<NameAlias> groupByList = new ArrayList<NameAlias>();
    private final List<OrderBy> orderByList = new ArrayList<OrderBy>();
    private ConditionGroup havingGroup;
    private int limit = -1;
    private int offset = -1;

    Where(WhereBase<TModel> whereBase, SQLCondition ... conditions) {
        super(whereBase.getTable());
        this.whereBase = whereBase;
        this.conditionGroup = new ConditionGroup();
        this.havingGroup = new ConditionGroup();
        this.conditionGroup.andAll(conditions);
    }

    public Where<TModel> and(SQLCondition condition) {
        this.conditionGroup.and(condition);
        return this;
    }

    public Where<TModel> or(SQLCondition condition) {
        this.conditionGroup.or(condition);
        return this;
    }

    public Where<TModel> andAll(List<SQLCondition> conditions) {
        this.conditionGroup.andAll(conditions);
        return this;
    }

    public Where<TModel> andAll(SQLCondition ... conditions) {
        this.conditionGroup.andAll(conditions);
        return this;
    }

    @Override
    public Where<TModel> groupBy(NameAlias ... columns) {
        Collections.addAll(this.groupByList, columns);
        return this;
    }

    @Override
    public Where<TModel> groupBy(IProperty ... properties) {
        for (IProperty property : properties) {
            this.groupByList.add(property.getNameAlias());
        }
        return this;
    }

    @Override
    public Where<TModel> having(SQLCondition ... conditions) {
        this.havingGroup.andAll(conditions);
        return this;
    }

    @Override
    public Where<TModel> orderBy(NameAlias nameAlias, boolean ascending) {
        this.orderByList.add(new OrderBy(nameAlias, ascending));
        return this;
    }

    @Override
    public Where<TModel> orderBy(IProperty property, boolean ascending) {
        this.orderByList.add(new OrderBy(property.getNameAlias(), ascending));
        return this;
    }

    @Override
    public Where<TModel> orderBy(OrderBy orderBy) {
        this.orderByList.add(orderBy);
        return this;
    }

    public Where<TModel> orderByAll(List<OrderBy> orderBies) {
        if (orderBies != null) {
            this.orderByList.addAll(orderBies);
        }
        return this;
    }

    @Override
    public Where<TModel> limit(int count) {
        this.limit = count;
        return this;
    }

    @Override
    public Where<TModel> offset(int offset) {
        this.offset = offset;
        return this;
    }

    public Where<TModel> exists(@NonNull Where where) {
        this.conditionGroup.and(new ExistenceCondition().where(where));
        return this;
    }

    public String getQuery() {
        String fromQuery = this.whereBase.getQuery().trim();
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)fromQuery).appendSpace().appendQualifier("WHERE", this.conditionGroup.getQuery()).appendQualifier("GROUP BY", QueryBuilder.join((CharSequence)",", this.groupByList)).appendQualifier("HAVING", this.havingGroup.getQuery()).appendQualifier("ORDER BY", QueryBuilder.join((CharSequence)",", this.orderByList));
        if (this.limit > -1) {
            queryBuilder.appendQualifier("LIMIT", String.valueOf(this.limit));
        }
        if (this.offset > -1) {
            queryBuilder.appendQualifier("OFFSET", String.valueOf(this.offset));
        }
        return queryBuilder.getQuery();
    }

    @Override
    public Cursor query(DatabaseWrapper wrapper) {
        Cursor cursor = null;
        String query = this.getQuery();
        if (this.whereBase.getQueryBuilderBase() instanceof Select) {
            cursor = wrapper.rawQuery(query, null);
        } else {
            wrapper.execSQL(query);
        }
        return cursor;
    }

    @Override
    public Cursor query() {
        return this.query(FlowManager.getDatabaseForTable(this.getTable()).getWritableDatabase());
    }

    @Override
    public List<TModel> queryList() {
        this.checkSelect("query");
        return super.queryList();
    }

    protected void checkSelect(String methodName) {
        if (!(this.whereBase.getQueryBuilderBase() instanceof Select)) {
            throw new IllegalArgumentException("Please use " + methodName + "(). The beginning is not a Select");
        }
    }

    @Override
    public TModel querySingle() {
        this.checkSelect("query");
        this.limit(1);
        return super.querySingle();
    }
}

