/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.structure.BaseQueryModel;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;

public class CursorResult<TModel>
implements Closeable {
    private final InstanceAdapter<TModel> retrievalAdapter;
    @Nullable
    private Cursor cursor;

    CursorResult(Class<TModel> modelClass, @Nullable Cursor cursor) {
        this.cursor = cursor;
        this.retrievalAdapter = FlowManager.getInstanceAdapter(modelClass);
    }

    public void swapCursor(@Nullable Cursor cursor) {
        if (this.cursor != null && !this.cursor.isClosed()) {
            this.cursor.close();
        }
        this.cursor = cursor;
    }

    @NonNull
    public List<TModel> toList() {
        if (this.cursor != null) {
            ArrayList modelList = this.retrievalAdapter.getListModelLoader().convertToData(this.cursor, null);
            return modelList != null ? modelList : new ArrayList();
        }
        return new ArrayList();
    }

    @NonNull
    public List<TModel> toListClose() {
        if (this.cursor != null) {
            List load = (List)this.retrievalAdapter.getListModelLoader().load(this.cursor);
            return load != null ? load : new ArrayList();
        }
        return new ArrayList();
    }

    @NonNull
    public <TCustom extends BaseQueryModel> List<TCustom> toCustomList(Class<TCustom> customClass) {
        if (this.cursor != null) {
            ArrayList customList = FlowManager.getQueryModelAdapter(customClass).getListModelLoader().convertToData(this.cursor, null);
            return customList != null ? customList : new ArrayList();
        }
        return new ArrayList();
    }

    @NonNull
    public <TCustom extends BaseQueryModel> List<TCustom> toCustomListClose(Class<TCustom> customClass) {
        if (this.cursor != null) {
            List customList = (List)FlowManager.getQueryModelAdapter(customClass).getListModelLoader().load(this.cursor);
            return customList != null ? customList : new ArrayList();
        }
        return new ArrayList();
    }

    @Nullable
    public TModel toModel() {
        if (this.cursor != null) {
            return this.retrievalAdapter.getSingleModelLoader().convertToData(this.cursor, (Object)null);
        }
        return null;
    }

    @Nullable
    public TModel toModelClose() {
        if (this.cursor != null) {
            return (TModel)this.retrievalAdapter.getSingleModelLoader().load(this.cursor);
        }
        return null;
    }

    public long count() {
        return this.cursor == null ? 0L : (long)this.cursor.getCount();
    }

    @Nullable
    public Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

