/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.list.FlowCursorList;
import com.raizlabs.android.dbflow.list.FlowQueryList;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.language.BaseQueriable;
import com.raizlabs.android.dbflow.sql.language.CursorResult;
import com.raizlabs.android.dbflow.sql.queriable.AsyncQuery;
import com.raizlabs.android.dbflow.sql.queriable.ModelQueriable;
import com.raizlabs.android.dbflow.structure.BaseQueryModel;
import com.raizlabs.android.dbflow.structure.InstanceAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseModelQueriable<TModel>
extends BaseQueriable<TModel>
implements ModelQueriable<TModel>,
Query {
    private InstanceAdapter<TModel> retrievalAdapter;

    protected BaseModelQueriable(Class<TModel> table) {
        super(table);
    }

    private InstanceAdapter<TModel> getRetrievalAdapter() {
        if (this.retrievalAdapter == null) {
            this.retrievalAdapter = FlowManager.getInstanceAdapter(this.getTable());
        }
        return this.retrievalAdapter;
    }

    @Override
    public CursorResult<TModel> queryResults() {
        return new CursorResult(this.getRetrievalAdapter().getModelClass(), this.query());
    }

    @Override
    public List<TModel> queryList() {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return (List)this.getRetrievalAdapter().getListModelLoader().load(query);
    }

    @Override
    public TModel querySingle() {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return (TModel)this.getRetrievalAdapter().getSingleModelLoader().load(query);
    }

    @Override
    public TModel querySingle(DatabaseWrapper wrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return (TModel)this.getRetrievalAdapter().getSingleModelLoader().load(wrapper, query);
    }

    @Override
    @NonNull
    public List<TModel> queryList(DatabaseWrapper wrapper) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        List list = (List)this.getRetrievalAdapter().getListModelLoader().load(wrapper, query);
        return list == null ? new ArrayList() : list;
    }

    @Override
    public FlowCursorList<TModel> cursorList() {
        return new FlowCursorList.Builder(this.getTable()).modelQueriable(this).build();
    }

    @Override
    public FlowQueryList<TModel> flowQueryList() {
        return new FlowQueryList.Builder(this.getTable()).modelQueriable(this).build();
    }

    @Override
    public long executeUpdateDelete() {
        return this.executeUpdateDelete(FlowManager.getWritableDatabaseForTable(this.getTable()));
    }

    @Override
    public long executeUpdateDelete(DatabaseWrapper databaseWrapper) {
        return databaseWrapper.compileStatement(this.getQuery()).executeUpdateDelete();
    }

    @Override
    public AsyncQuery<TModel> async() {
        return new AsyncQuery(this);
    }

    @Override
    public <QueryClass extends BaseQueryModel> List<QueryClass> queryCustomList(Class<QueryClass> queryModelClass) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return (List)FlowManager.getQueryModelAdapter(queryModelClass).getListModelLoader().load(query);
    }

    @Override
    public <QueryClass extends BaseQueryModel> QueryClass queryCustomSingle(Class<QueryClass> queryModelClass) {
        String query = this.getQuery();
        FlowLog.log(FlowLog.Level.V, "Executing query: " + query);
        return (QueryClass)((BaseQueryModel)FlowManager.getQueryModelAdapter(queryModelClass).getSingleModelLoader().load(query));
    }
}

