/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language.property;

import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.property.BaseProperty;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class FloatProperty
extends BaseProperty<FloatProperty> {
    public FloatProperty(Class<?> table, NameAlias nameAlias) {
        super(table, nameAlias);
    }

    public FloatProperty(Class<?> table, String columnName) {
        this(table, new NameAlias.Builder(columnName).build());
    }

    public FloatProperty(Class<?> table, String columnName, String aliasName) {
        this(table, new NameAlias.Builder(columnName).as(aliasName).build());
    }

    @Override
    public FloatProperty plus(IProperty iProperty) {
        return new FloatProperty(this.table, NameAlias.joinNames("+", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public FloatProperty minus(IProperty iProperty) {
        return new FloatProperty(this.table, NameAlias.joinNames("-", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public FloatProperty dividedBy(IProperty iProperty) {
        return new FloatProperty(this.table, NameAlias.joinNames("/", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public FloatProperty multipliedBy(IProperty iProperty) {
        return new FloatProperty(this.table, NameAlias.joinNames("*", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public FloatProperty mod(IProperty iProperty) {
        return new FloatProperty(this.table, NameAlias.joinNames("%", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public FloatProperty concatenate(IProperty iProperty) {
        return new FloatProperty(this.table, NameAlias.joinNames("||", this.nameAlias.fullName(), iProperty.toString()));
    }

    @Override
    public FloatProperty as(String aliasName) {
        return new FloatProperty(this.table, this.nameAlias.newBuilder().as(aliasName).build());
    }

    @Override
    public FloatProperty distinct() {
        return new FloatProperty(this.table, this.getDistinctAliasName());
    }

    @Override
    public FloatProperty withTable(NameAlias tableNameAlias) {
        return new FloatProperty(this.table, this.nameAlias.newBuilder().withTable(tableNameAlias.getQuery()).build());
    }

    public Condition is(float value) {
        return Condition.column(this.nameAlias).is(Float.valueOf(value));
    }

    public Condition eq(float value) {
        return Condition.column(this.nameAlias).eq(Float.valueOf(value));
    }

    public Condition isNot(float value) {
        return Condition.column(this.nameAlias).isNot(Float.valueOf(value));
    }

    public Condition notEq(float value) {
        return Condition.column(this.nameAlias).notEq(Float.valueOf(value));
    }

    public Condition like(float value) {
        return Condition.column(this.nameAlias).like(String.valueOf(value));
    }

    public Condition notLike(float value) {
        return Condition.column(this.nameAlias).notLike(String.valueOf(value));
    }

    public Condition glob(float value) {
        return Condition.column(this.nameAlias).glob(String.valueOf(value));
    }

    public Condition greaterThan(float value) {
        return Condition.column(this.nameAlias).greaterThan(Float.valueOf(value));
    }

    public Condition greaterThanOrEq(float value) {
        return Condition.column(this.nameAlias).greaterThanOrEq(Float.valueOf(value));
    }

    public Condition lessThan(float value) {
        return Condition.column(this.nameAlias).lessThan(Float.valueOf(value));
    }

    public Condition lessThanOrEq(float value) {
        return Condition.column(this.nameAlias).lessThanOrEq(Float.valueOf(value));
    }

    public Condition.Between between(float value) {
        return Condition.column(this.nameAlias).between(Float.valueOf(value));
    }

    public Condition.In in(float firstValue, float ... values) {
        Condition.In in = Condition.column(this.nameAlias).in(Float.valueOf(firstValue), new Object[0]);
        for (float value : values) {
            in.and(Float.valueOf(value));
        }
        return in;
    }

    public Condition.In notIn(float firstValue, float ... values) {
        Condition.In in = Condition.column(this.nameAlias).notIn(Float.valueOf(firstValue), new Object[0]);
        for (float value : values) {
            in.and(Float.valueOf(value));
        }
        return in;
    }

    public Condition concatenate(float value) {
        return Condition.column(this.nameAlias).concatenate(Float.valueOf(value));
    }

    public Condition is(FloatProperty property) {
        return Condition.column(this.nameAlias).is(property);
    }

    public Condition isNot(FloatProperty property) {
        return Condition.column(this.nameAlias).isNot(property);
    }

    public Condition eq(FloatProperty property) {
        return this.is(property);
    }

    public Condition notEq(FloatProperty property) {
        return this.isNot(property);
    }

    public Condition greaterThan(FloatProperty property) {
        return Condition.column(this.nameAlias).greaterThan(property);
    }

    public Condition greaterThanOrEq(FloatProperty property) {
        return Condition.column(this.nameAlias).greaterThanOrEq(property);
    }

    public Condition lessThan(FloatProperty property) {
        return Condition.column(this.nameAlias).lessThan(property);
    }

    public Condition lessThanOrEq(FloatProperty property) {
        return Condition.column(this.nameAlias).lessThanOrEq(property);
    }
}

