/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.runtime;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.SqlUtils;
import com.raizlabs.android.dbflow.sql.language.Condition;
import com.raizlabs.android.dbflow.sql.language.NameAlias;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;
import com.raizlabs.android.dbflow.structure.BaseModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class FlowContentObserver
extends ContentObserver {
    private static final AtomicInteger REGISTERED_COUNT = new AtomicInteger(0);
    private static boolean forceNotify = false;
    private final Set<OnModelStateChangedListener> modelChangeListeners = new CopyOnWriteArraySet<OnModelStateChangedListener>();
    private final Set<OnTableChangedListener> onTableChangedListeners = new CopyOnWriteArraySet<OnTableChangedListener>();
    private final Map<String, Class<?>> registeredTables = new HashMap();
    private final Set<Uri> notificationUris = new HashSet<Uri>();
    private final Set<Uri> tableUris = new HashSet<Uri>();
    protected boolean isInTransaction = false;
    private boolean notifyAllUris = false;

    public static boolean shouldNotify() {
        return forceNotify || REGISTERED_COUNT.get() > 0;
    }

    public static void clearRegisteredObserverCount() {
        REGISTERED_COUNT.set(0);
    }

    public static void setShouldForceNotify(boolean forceNotify) {
        FlowContentObserver.forceNotify = forceNotify;
    }

    public FlowContentObserver() {
        super(null);
    }

    public FlowContentObserver(Handler handler) {
        super(handler);
    }

    public void setNotifyAllUris(boolean notifyAllUris) {
        this.notifyAllUris = notifyAllUris;
    }

    public void beginTransaction() {
        if (!this.isInTransaction) {
            this.isInTransaction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransactionAndNotify() {
        if (this.isInTransaction) {
            this.isInTransaction = false;
            if (Build.VERSION.SDK_INT < 16) {
                this.onChange(true);
            } else {
                Set<Uri> set = this.notificationUris;
                synchronized (set) {
                    for (Uri uri : this.notificationUris) {
                        this.onChange(true, uri, true);
                    }
                    this.notificationUris.clear();
                }
                set = this.tableUris;
                synchronized (set) {
                    for (Uri uri : this.tableUris) {
                        for (OnTableChangedListener onTableChangedListener : this.onTableChangedListeners) {
                            onTableChangedListener.onTableChanged(this.registeredTables.get(uri.getAuthority()), BaseModel.Action.valueOf(uri.getFragment()));
                        }
                    }
                    this.tableUris.clear();
                }
            }
        }
    }

    public void addModelChangeListener(OnModelStateChangedListener modelChangeListener) {
        this.modelChangeListeners.add(modelChangeListener);
    }

    public void removeModelChangeListener(OnModelStateChangedListener modelChangeListener) {
        this.modelChangeListeners.remove(modelChangeListener);
    }

    public void addOnTableChangedListener(OnTableChangedListener onTableChangedListener) {
        this.onTableChangedListeners.add(onTableChangedListener);
    }

    public void removeTableChangedListener(OnTableChangedListener onTableChangedListener) {
        this.onTableChangedListeners.remove(onTableChangedListener);
    }

    public void registerForContentChanges(Context context, Class<?> table) {
        this.registerForContentChanges(context.getContentResolver(), table);
    }

    public void registerForContentChanges(ContentResolver contentResolver, Class<?> table) {
        contentResolver.registerContentObserver(SqlUtils.getNotificationUri(table, null), true, (ContentObserver)this);
        REGISTERED_COUNT.incrementAndGet();
        if (!this.registeredTables.containsValue(table)) {
            this.registeredTables.put(FlowManager.getTableName(table), table);
        }
    }

    public void unregisterForContentChanges(Context context) {
        context.getContentResolver().unregisterContentObserver((ContentObserver)this);
        REGISTERED_COUNT.decrementAndGet();
        this.registeredTables.clear();
    }

    public void onChange(boolean selfChange) {
        for (OnModelStateChangedListener modelChangeListener : this.modelChangeListeners) {
            modelChangeListener.onModelStateChanged(null, BaseModel.Action.CHANGE, new SQLCondition[0]);
        }
        for (OnTableChangedListener onTableChangedListener : this.onTableChangedListeners) {
            onTableChangedListener.onTableChanged(null, BaseModel.Action.CHANGE);
        }
    }

    @TargetApi(value=16)
    public void onChange(boolean selfChange, Uri uri) {
        this.onChange(selfChange, uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    private void onChange(boolean selfChanges, Uri uri, boolean calledInternally) {
        block13: {
            BaseModel.Action action;
            Class<?> table;
            block12: {
                String fragment = uri.getFragment();
                String tableName = uri.getAuthority();
                Set queryNames = uri.getQueryParameterNames();
                SQLCondition[] columnsChanged = new SQLCondition[queryNames.size()];
                if (!queryNames.isEmpty()) {
                    int index = 0;
                    for (String key : queryNames) {
                        String param = Uri.decode((String)uri.getQueryParameter(key));
                        String columnName = Uri.decode((String)key);
                        columnsChanged[index] = Condition.column(new NameAlias.Builder(columnName).build()).value(param);
                        ++index;
                    }
                }
                table = this.registeredTables.get(tableName);
                action = BaseModel.Action.valueOf(fragment);
                if (this.isInTransaction) break block12;
                if (action != null) {
                    for (OnModelStateChangedListener modelChangeListener : this.modelChangeListeners) {
                        modelChangeListener.onModelStateChanged(table, action, columnsChanged);
                    }
                }
                if (calledInternally) break block13;
                for (OnTableChangedListener onTableChangeListener : this.onTableChangedListeners) {
                    onTableChangeListener.onTableChanged(table, action);
                }
                break block13;
            }
            if (!this.notifyAllUris) {
                action = BaseModel.Action.CHANGE;
                uri = SqlUtils.getNotificationUri(table, action);
            }
            Object object = this.notificationUris;
            synchronized (object) {
                this.notificationUris.add(uri);
            }
            object = this.tableUris;
            synchronized (object) {
                this.tableUris.add(SqlUtils.getNotificationUri(table, action));
            }
        }
    }

    public static interface OnTableChangedListener {
        public void onTableChanged(@Nullable Class<?> var1, BaseModel.Action var2);
    }

    public static interface OnModelStateChangedListener {
        public void onModelStateChanged(@Nullable Class<?> var1, BaseModel.Action var2, @NonNull SQLCondition[] var3);
    }
}

