/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor;

import com.raizlabs.android.dbflow.processor.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ElementExtensionsKt;
import com.raizlabs.android.dbflow.processor.utils.ElementUtility;
import com.squareup.javapoet.ClassName;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\bJ \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0018"}, d2={"Lcom/raizlabs/android/dbflow/processor/ProcessorUtils;", "", "()V", "ensureVisibleStatic", "", "element", "Ljavax/lang/model/element/Element;", "typeElement", "Ljavax/lang/model/element/TypeElement;", "name", "", "fromTypeMirror", "Lcom/squareup/javapoet/ClassName;", "typeMirror", "Ljavax/lang/model/type/TypeMirror;", "processorManager", "Lcom/raizlabs/android/dbflow/processor/ProcessorManager;", "getTypeElement", "implementsClass", "", "processingEnvironment", "Ljavax/annotation/processing/ProcessingEnvironment;", "fqTn", "isSubclass", "dbflow-processor"})
public final class ProcessorUtils {
    public static final ProcessorUtils INSTANCE;

    public final boolean implementsClass(@NotNull ProcessingEnvironment processingEnvironment, @NotNull String fqTn, @Nullable TypeElement element) {
        TypeMirror classMirror;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)processingEnvironment, (String)"processingEnvironment");
                Intrinsics.checkParameterIsNotNull((Object)fqTn, (String)"fqTn");
                TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(fqTn);
                if (typeElement == null) {
                    processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Type Element was null for: " + fqTn + " ensure that the visibility of the class is not private.");
                    return false;
                }
                classMirror = ElementExtensionsKt.erasure$default(typeElement.asType(), null, 1, null);
                if (classMirror == null) break block4;
                TypeElement typeElement2 = element;
                if ((typeElement2 != null ? typeElement2.asType() : null) != null) break block5;
            }
            return false;
        }
        TypeMirror elementType = element.asType();
        return elementType != null && (processingEnvironment.getTypeUtils().isAssignable(elementType, classMirror) || Intrinsics.areEqual((Object)elementType, (Object)classMirror));
    }

    public final boolean isSubclass(@NotNull ProcessingEnvironment processingEnvironment, @NotNull String fqTn, @Nullable TypeElement element) {
        Intrinsics.checkParameterIsNotNull((Object)processingEnvironment, (String)"processingEnvironment");
        Intrinsics.checkParameterIsNotNull((Object)fqTn, (String)"fqTn");
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(fqTn);
        if (typeElement == null) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Type Element was null for: " + fqTn + " ensure that the visibility of the class is not private.");
            return false;
        }
        TypeMirror classMirror = typeElement.asType();
        return classMirror != null && element != null && element.asType() != null && processingEnvironment.getTypeUtils().isSubtype(element.asType(), classMirror);
    }

    @Nullable
    public final ClassName fromTypeMirror(@NotNull TypeMirror typeMirror, @NotNull ProcessorManager processorManager) {
        Intrinsics.checkParameterIsNotNull((Object)typeMirror, (String)"typeMirror");
        Intrinsics.checkParameterIsNotNull((Object)processorManager, (String)"processorManager");
        TypeElement element = this.getTypeElement(typeMirror);
        return element != null ? ClassName.get((TypeElement)element) : ElementUtility.INSTANCE.getClassName(((Object)typeMirror).toString(), processorManager);
    }

    @Nullable
    public final TypeElement getTypeElement(@NotNull Element element) {
        TypeElement typeElement;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof TypeElement) {
            typeElement = (TypeElement)element;
        } else {
            TypeMirror typeMirror = element.asType();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"element.asType()");
            typeElement = this.getTypeElement(typeMirror);
        }
        return typeElement;
    }

    @Nullable
    public final TypeElement getTypeElement(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkParameterIsNotNull((Object)typeMirror, (String)"typeMirror");
        ProcessorManager manager = ProcessorManager.Companion.getManager();
        TypeElement typeElement = ElementExtensionsKt.toTypeElement(typeMirror, manager);
        if (typeElement == null) {
            Element el = manager.getTypeUtils().asElement(typeMirror);
            typeElement = el != null ? (TypeElement)el : null;
        }
        return typeElement;
    }

    public final void ensureVisibleStatic(@NotNull Element element, @NotNull TypeElement typeElement, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)typeElement, (String)"typeElement");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (element.getModifiers().contains((Object)Modifier.PRIVATE) || element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            ProcessorManager.Companion.getManager().logError("" + name + " must be visible from: " + typeElement, new Object[0]);
        }
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            ProcessorManager.Companion.getManager().logError("" + name + " must be static from: " + typeElement, new Object[0]);
        }
        if (!element.getModifiers().contains((Object)Modifier.FINAL)) {
            ProcessorManager.Companion.getManager().logError("The " + name + " must be final", new Object[0]);
        }
    }

    private ProcessorUtils() {
        INSTANCE = this;
    }

    static {
        new ProcessorUtils();
    }
}

