/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.raizlabs.android.dbflow.processor.definition.ContentProviderDefinition;
import com.raizlabs.android.dbflow.processor.definition.FlowManagerHolderDefinition;
import com.raizlabs.android.dbflow.processor.definition.ManyToManyDefinition;
import com.raizlabs.android.dbflow.processor.definition.MigrationDefinition;
import com.raizlabs.android.dbflow.processor.definition.ModelViewDefinition;
import com.raizlabs.android.dbflow.processor.definition.QueryModelDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableEndpointDefinition;
import com.raizlabs.android.dbflow.processor.definition.TypeConverterDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.DatabaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.DatabaseHolderDefinition;
import com.raizlabs.android.dbflow.processor.handler.BaseContainerHandler;
import com.raizlabs.android.dbflow.processor.handler.Handler;
import com.raizlabs.android.dbflow.processor.utils.WriterUtils;
import com.raizlabs.android.dbflow.processor.validator.ContentProviderValidator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class ProcessorManager
implements Handler {
    private static ProcessorManager manager;
    private ProcessingEnvironment processingEnvironment;
    private List<TypeName> uniqueDatabases = Lists.newArrayList();
    private Map<TypeName, TypeName> modelToDatabaseMap = Maps.newHashMap();
    private Map<TypeName, TypeConverterDefinition> typeConverters = Maps.newHashMap();
    private Map<TypeName, Map<Integer, List<MigrationDefinition>>> migrations = Maps.newHashMap();
    private Map<TypeName, DatabaseHolderDefinition> databaseDefinitionMap = Maps.newHashMap();
    private List<BaseContainerHandler> handlers = new ArrayList<BaseContainerHandler>();
    private Map<TypeName, ContentProviderDefinition> providerMap = Maps.newHashMap();

    public static ProcessorManager getManager() {
        return manager;
    }

    public static void setManager(ProcessorManager manager) {
        ProcessorManager.manager = manager;
    }

    public ProcessorManager(ProcessingEnvironment processingEnv) {
        this.processingEnvironment = processingEnv;
        ProcessorManager.setManager(this);
    }

    public void addHandlers(BaseContainerHandler ... containerHandlers) {
        for (BaseContainerHandler containerHandler : containerHandlers) {
            if (this.handlers.contains(containerHandler)) continue;
            this.handlers.add(containerHandler);
        }
    }

    public Messager getMessager() {
        return this.processingEnvironment.getMessager();
    }

    public Types getTypeUtils() {
        return this.processingEnvironment.getTypeUtils();
    }

    public Elements getElements() {
        return this.processingEnvironment.getElementUtils();
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }

    public void addDatabase(TypeName database) {
        if (!this.uniqueDatabases.contains(database)) {
            this.uniqueDatabases.add(database);
        }
    }

    public void addFlowManagerWriter(DatabaseDefinition databaseDefinition) {
        DatabaseHolderDefinition holderDefinition = this.getOrPutDatabase((TypeName)databaseDefinition.elementClassName);
        holderDefinition.setDatabaseDefinition(databaseDefinition);
    }

    public List<DatabaseHolderDefinition> getDatabaseDefinitionMap() {
        return new ArrayList<DatabaseHolderDefinition>(this.databaseDefinitionMap.values());
    }

    public DatabaseHolderDefinition getDatabaseHolderDefinition(TypeName databaseName) {
        return this.databaseDefinitionMap.get(databaseName);
    }

    public void addTypeConverterDefinition(TypeConverterDefinition definition) {
        this.typeConverters.put(definition.getModelTypeName(), definition);
    }

    public TypeConverterDefinition getTypeConverterDefinition(TypeName typeName) {
        return this.typeConverters.get(typeName);
    }

    public void addModelToDatabase(TypeName modelType, TypeName databaseName) {
        this.addDatabase(databaseName);
        this.modelToDatabaseMap.put(modelType, databaseName);
    }

    public TypeName getDatabase(TypeName modelType) {
        return this.modelToDatabaseMap.get(modelType);
    }

    public String getDatabaseName(TypeName databaseTypeName) {
        return this.getOrPutDatabase((TypeName)databaseTypeName).getDatabaseDefinition().databaseName;
    }

    public void addQueryModelDefinition(QueryModelDefinition queryModelDefinition) {
        this.getOrPutDatabase((TypeName)queryModelDefinition.databaseTypeName).queryModelDefinitionMap.put((TypeName)queryModelDefinition.elementClassName, queryModelDefinition);
    }

    public void addTableDefinition(TableDefinition tableDefinition) {
        DatabaseHolderDefinition holderDefinition = this.getOrPutDatabase(tableDefinition.databaseTypeName);
        holderDefinition.tableDefinitionMap.put((TypeName)tableDefinition.elementClassName, tableDefinition);
        if (holderDefinition.tableNameMap.containsKey(tableDefinition.tableName)) {
            this.logError("Found duplicate table %1s for database %1s", tableDefinition.tableName, holderDefinition.getDatabaseDefinition().databaseName);
        } else {
            holderDefinition.tableNameMap.put(tableDefinition.tableName, tableDefinition);
        }
    }

    public void addManyToManyDefinition(ManyToManyDefinition manyToManyDefinition) {
        DatabaseHolderDefinition databaseHolderDefinition = this.getOrPutDatabase(manyToManyDefinition.databaseTypeName);
        List<ManyToManyDefinition> manyToManyDefinitions = databaseHolderDefinition.manyToManyDefinitionMap.get(manyToManyDefinition.elementClassName);
        if (manyToManyDefinitions == null) {
            manyToManyDefinitions = new ArrayList<ManyToManyDefinition>();
            databaseHolderDefinition.manyToManyDefinitionMap.put((TypeName)manyToManyDefinition.elementClassName, manyToManyDefinitions);
        }
        manyToManyDefinitions.add(manyToManyDefinition);
    }

    public TableDefinition getTableDefinition(TypeName databaseName, TypeName typeName) {
        return this.getOrPutDatabase((TypeName)databaseName).tableDefinitionMap.get(typeName);
    }

    public TableDefinition getTableDefinition(TypeName databaseName, String tableName) {
        return this.getOrPutDatabase((TypeName)databaseName).tableNameMap.get(tableName);
    }

    public void addModelViewDefinition(ModelViewDefinition modelViewDefinition) {
        this.getOrPutDatabase((TypeName)modelViewDefinition.databaseName).modelViewDefinitionMap.put((TypeName)modelViewDefinition.elementClassName, modelViewDefinition);
    }

    public Set<TypeConverterDefinition> getTypeConverters() {
        return Sets.newHashSet(this.typeConverters.values());
    }

    public Set<TableDefinition> getTableDefinitions(TypeName databaseName) {
        DatabaseHolderDefinition databaseHolderDefinition = this.getOrPutDatabase(databaseName);
        return Sets.newHashSet(databaseHolderDefinition.tableDefinitionMap.values());
    }

    public void setTableDefinitions(Map<TypeName, TableDefinition> tableDefinitionSet, TypeName databaseName) {
        DatabaseHolderDefinition databaseDefinition = this.getOrPutDatabase(databaseName);
        databaseDefinition.tableDefinitionMap = tableDefinitionSet;
    }

    public Set<ModelViewDefinition> getModelViewDefinitions(TypeName databaseName) {
        DatabaseHolderDefinition databaseDefinition = this.getOrPutDatabase(databaseName);
        return Sets.newHashSet(databaseDefinition.modelViewDefinitionMap.values());
    }

    public void setModelViewDefinitions(Map<TypeName, ModelViewDefinition> modelViewDefinitionMap, ClassName elementClassName) {
        DatabaseHolderDefinition databaseDefinition = this.getOrPutDatabase((TypeName)elementClassName);
        databaseDefinition.modelViewDefinitionMap = modelViewDefinitionMap;
    }

    public Set<QueryModelDefinition> getQueryModelDefinitions(TypeName databaseName) {
        DatabaseHolderDefinition databaseDefinition = this.getOrPutDatabase(databaseName);
        return Sets.newHashSet(databaseDefinition.queryModelDefinitionMap.values());
    }

    public void addMigrationDefinition(MigrationDefinition migrationDefinition) {
        List migrationDefinitions;
        HashMap migrationDefinitionMap = this.migrations.get(migrationDefinition.databaseName);
        if (migrationDefinitionMap == null) {
            migrationDefinitionMap = Maps.newHashMap();
            this.migrations.put(migrationDefinition.databaseName, migrationDefinitionMap);
        }
        if ((migrationDefinitions = (List)migrationDefinitionMap.get(migrationDefinition.version)) == null) {
            migrationDefinitions = Lists.newArrayList();
            migrationDefinitionMap.put(migrationDefinition.version, migrationDefinitions);
        }
        if (!migrationDefinitions.contains(migrationDefinition)) {
            migrationDefinitions.add(migrationDefinition);
        }
    }

    public Map<Integer, List<MigrationDefinition>> getMigrationsForDatabase(TypeName databaseName) {
        Map<Integer, List<MigrationDefinition>> migrationDefinitions = this.migrations.get(databaseName);
        if (migrationDefinitions != null) {
            return migrationDefinitions;
        }
        return Maps.newHashMap();
    }

    public void addContentProviderDefinition(ContentProviderDefinition contentProviderDefinition) {
        DatabaseHolderDefinition holderDefinition = this.getOrPutDatabase(contentProviderDefinition.databaseName);
        holderDefinition.providerMap.put(contentProviderDefinition.elementTypeName, contentProviderDefinition);
        this.providerMap.put(contentProviderDefinition.elementTypeName, contentProviderDefinition);
    }

    public void putTableEndpointForProvider(TableEndpointDefinition tableEndpointDefinition) {
        ContentProviderDefinition contentProviderDefinition = this.providerMap.get(tableEndpointDefinition.contentProviderName);
        if (contentProviderDefinition == null) {
            this.logError("Content Provider %1s was not found for the @TableEndpoint %1s", tableEndpointDefinition.contentProviderName, tableEndpointDefinition.elementClassName);
        } else {
            contentProviderDefinition.endpointDefinitions.add(tableEndpointDefinition);
        }
    }

    public void logError(String error, Object ... args) {
        StackTraceElement[] stackTraceElements;
        this.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("*==========*\n" + error + "\n*==========*", args));
        for (StackTraceElement stackTrace : stackTraceElements = Thread.currentThread().getStackTrace()) {
            this.getMessager().printMessage(Diagnostic.Kind.ERROR, stackTrace + "");
        }
    }

    public void logError(Class callingClass, String error, Object ... args) {
        this.logError(callingClass + ": " + error, args);
    }

    public void logWarning(String error, Object ... args) {
        this.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("*==========*\n" + error + "\n*==========*", args));
    }

    public void logWarning(Class callingClass, String error, Object ... args) {
        this.logWarning(callingClass + ":" + error, args);
    }

    private DatabaseHolderDefinition getOrPutDatabase(TypeName databaseName) {
        DatabaseHolderDefinition holderDefinition = this.databaseDefinitionMap.get(databaseName);
        if (holderDefinition == null) {
            holderDefinition = new DatabaseHolderDefinition();
            this.databaseDefinitionMap.put(databaseName, holderDefinition);
        }
        return holderDefinition;
    }

    @Override
    public void handle(ProcessorManager processorManager, RoundEnvironment roundEnvironment) {
        for (BaseContainerHandler baseContainerHandler : this.handlers) {
            baseContainerHandler.handle(processorManager, roundEnvironment);
        }
        List<DatabaseHolderDefinition> databaseDefinitions = this.getDatabaseDefinitionMap();
        for (DatabaseHolderDefinition databaseDefinition : databaseDefinitions) {
            try {
                if (databaseDefinition.getDatabaseDefinition() == null) {
                    ProcessorManager.getManager().logError("Found null db with: %1s tables, %1s modelviews. Attempt to rebuild project should fix this intermittant issue.", databaseDefinition.tableNameMap.values().size(), databaseDefinition.modelViewDefinitionMap.values().size());
                    ProcessorManager.getManager().logError("Found tables: " + databaseDefinition.tableNameMap.values(), new Object[0]);
                    continue;
                }
                Collection<List<ManyToManyDefinition>> manyToManyDefinitions = databaseDefinition.manyToManyDefinitionMap.values();
                for (List<ManyToManyDefinition> manyToManyList : manyToManyDefinitions) {
                    for (ManyToManyDefinition manyToManyDefinition : manyToManyList) {
                        manyToManyDefinition.prepareForWrite();
                        WriterUtils.writeBaseDefinition(manyToManyDefinition, processorManager);
                    }
                }
                if (!manyToManyDefinitions.isEmpty()) {
                    manyToManyDefinitions.clear();
                    continue;
                }
                ContentProviderValidator validator = new ContentProviderValidator();
                Collection<ContentProviderDefinition> contentProviderDefinitions = databaseDefinition.providerMap.values();
                for (ContentProviderDefinition contentProviderDefinition : contentProviderDefinitions) {
                    contentProviderDefinition.prepareForWrite();
                    if (!validator.validate(processorManager, contentProviderDefinition)) continue;
                    WriterUtils.writeBaseDefinition(contentProviderDefinition, processorManager);
                }
                databaseDefinition.getDatabaseDefinition().validateAndPrepareToWrite();
                if (roundEnvironment.processingOver()) {
                    JavaFile.builder((String)databaseDefinition.getDatabaseDefinition().packageName, (TypeSpec)databaseDefinition.getDatabaseDefinition().getTypeSpec()).build().writeTo(processorManager.getProcessingEnvironment().getFiler());
                }
                Collection<TableDefinition> tableDefinitions = databaseDefinition.tableDefinitionMap.values();
                for (TableDefinition tableDefinition : tableDefinitions) {
                    WriterUtils.writeBaseDefinition(tableDefinition, processorManager);
                }
                tableDefinitions = databaseDefinition.tableDefinitionMap.values();
                for (TableDefinition tableDefinition : tableDefinitions) {
                    try {
                        tableDefinition.writeAdapter(processorManager.getProcessingEnvironment());
                    }
                    catch (FilerException filerException) {
                        // empty catch block
                    }
                    if (tableDefinition.modelContainerDefinition == null) continue;
                    WriterUtils.writeBaseDefinition(tableDefinition.modelContainerDefinition, processorManager);
                }
                ArrayList<ModelViewDefinition> arrayList = new ArrayList<ModelViewDefinition>(databaseDefinition.modelViewDefinitionMap.values());
                Collections.sort(arrayList);
                for (ModelViewDefinition modelViewDefinition : arrayList) {
                    WriterUtils.writeBaseDefinition(modelViewDefinition, processorManager);
                    try {
                        modelViewDefinition.writeViewTable();
                    }
                    catch (FilerException filerException) {}
                }
                Collection<QueryModelDefinition> collection = databaseDefinition.queryModelDefinitionMap.values();
                for (QueryModelDefinition queryModelDefinition : collection) {
                    WriterUtils.writeBaseDefinition(queryModelDefinition, processorManager);
                    try {
                        queryModelDefinition.writeAdapter(processorManager.getProcessingEnvironment());
                    }
                    catch (FilerException filerException) {}
                }
                for (TableDefinition tableDefinition3 : tableDefinitions) {
                    try {
                        tableDefinition3.writePackageHelper(processorManager.getProcessingEnvironment());
                    }
                    catch (FilerException filerException) {}
                }
                for (ModelViewDefinition modelViewDefinition : arrayList) {
                    try {
                        modelViewDefinition.writePackageHelper(processorManager.getProcessingEnvironment());
                    }
                    catch (FilerException filerException) {}
                }
                for (QueryModelDefinition queryModelDefinition : collection) {
                    try {
                        queryModelDefinition.writePackageHelper(processorManager.getProcessingEnvironment());
                    }
                    catch (FilerException filerException) {}
                }
            }
            catch (IOException iOException) {
            }
        }
        if (roundEnvironment.processingOver()) {
            try {
                JavaFile.builder((String)"com.raizlabs.android.dbflow.config", (TypeSpec)new FlowManagerHolderDefinition(processorManager).getTypeSpec()).build().writeTo(processorManager.getProcessingEnvironment().getFiler());
            }
            catch (IOException iOException) {
                this.logError(iOException.getMessage(), new Object[0]);
            }
        }
    }
}

