/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method.provider;

import com.raizlabs.android.dbflow.annotation.provider.ContentUri;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.ContentUriDefinition;
import com.squareup.javapoet.CodeBlock;
import java.util.List;

public class ProviderMethodUtils {
    static CodeBlock getSegmentsPreparation(ContentUriDefinition uriDefinition) {
        if (uriDefinition.segments.length == 0) {
            return CodeBlock.builder().build();
        }
        return CodeBlock.builder().addStatement("$T<$T> segments = uri.getPathSegments()", new Object[]{List.class, String.class}).build();
    }

    static CodeBlock getSelectionAndSelectionArgs(ContentUriDefinition uriDefinition) {
        ContentUri.PathSegment[] segments = uriDefinition.segments;
        if (segments.length == 0) {
            return CodeBlock.builder().add("selection, selectionArgs", new Object[0]).build();
        }
        CodeBlock.Builder selectionBuilder = CodeBlock.builder().add("$T.concatenateWhere(selection, \"", new Object[]{ClassNames.DATABASE_UTILS});
        CodeBlock.Builder selectionArgsBuilder = CodeBlock.builder().add("$T.appendSelectionArgs(selectionArgs, new $T[] {", new Object[]{ClassNames.DATABASE_UTILS, String.class});
        boolean isFirst = true;
        for (ContentUri.PathSegment segment : segments) {
            if (!isFirst) {
                selectionBuilder.add(" AND ", new Object[0]);
                selectionArgsBuilder.add(", ", new Object[0]);
            }
            selectionBuilder.add("$L = ?", new Object[]{segment.column()});
            selectionArgsBuilder.add("segments.get($L)", new Object[]{segment.segment()});
            isFirst = false;
        }
        selectionBuilder.add("\")", new Object[0]);
        selectionArgsBuilder.add("})", new Object[0]);
        return CodeBlock.builder().add(selectionBuilder.build()).add(", ", new Object[0]).add(selectionArgsBuilder.build()).build();
    }
}

