/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method.provider;

import com.raizlabs.android.dbflow.annotation.provider.Notify;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.ContentProviderDefinition;
import com.raizlabs.android.dbflow.processor.definition.ContentUriDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableEndpointDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.provider.NotifyMethod;
import com.raizlabs.android.dbflow.processor.definition.method.provider.ProviderMethodUtils;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class DeleteMethod
implements MethodDefinition {
    private static final String PARAM_URI = "uri";
    private static final String PARAM_SELECTION = "selection";
    private static final String PARAM_SELECTION_ARGS = "selectionArgs";
    private final ContentProviderDefinition contentProviderDefinition;
    private ProcessorManager manager;

    public DeleteMethod(ContentProviderDefinition contentProviderDefinition, ProcessorManager manager) {
        this.contentProviderDefinition = contentProviderDefinition;
        this.manager = manager;
    }

    @Override
    public MethodSpec getMethodSpec() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.beginControlFlow("switch(MATCHER.match($L))", new Object[]{PARAM_URI});
        for (TableEndpointDefinition tableEndpointDefinition : this.contentProviderDefinition.endpointDefinitions) {
            for (ContentUriDefinition uriDefinition : tableEndpointDefinition.contentUriDefinitions) {
                if (!uriDefinition.deleteEnabled) continue;
                String databaseName = this.manager.getDatabaseName(this.contentProviderDefinition.databaseName);
                code.beginControlFlow("case $L:", new Object[]{uriDefinition.name});
                code.add(ProviderMethodUtils.getSegmentsPreparation(uriDefinition));
                code.add("long count = $T.getDatabase($S).getWritableDatabase().delete($S, ", new Object[]{ClassNames.FLOW_MANAGER, this.manager.getDatabaseName(this.contentProviderDefinition.databaseName), tableEndpointDefinition.tableName});
                code.add(ProviderMethodUtils.getSelectionAndSelectionArgs(uriDefinition));
                code.add(");\n", new Object[0]);
                new NotifyMethod(tableEndpointDefinition, uriDefinition, Notify.Method.DELETE).addCode(code);
                code.addStatement("return (int) count", new Object[0]);
                code.endControlFlow();
            }
        }
        code.beginControlFlow("default:", new Object[0]).addStatement("throw new $T($S + $L)", new Object[]{ClassName.get(IllegalArgumentException.class), "Unknown URI", PARAM_URI}).endControlFlow();
        code.endControlFlow();
        return MethodSpec.methodBuilder((String)"delete").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ClassNames.URI, PARAM_URI, new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), PARAM_SELECTION, new Modifier[0]).addParameter((TypeName)ArrayTypeName.of(String.class), PARAM_SELECTION_ARGS, new Modifier[0]).addCode(code.build()).returns(TypeName.INT).build();
    }
}

