/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class PrimaryConditionMethod
implements MethodDefinition {
    static final String PARAM_MODEL = "model";
    private final BaseTableDefinition tableDefinition;
    private final boolean isModelContainerAdapter;

    public PrimaryConditionMethod(BaseTableDefinition tableDefinition, boolean isModelContainerAdapter) {
        this.tableDefinition = tableDefinition;
        this.isModelContainerAdapter = isModelContainerAdapter;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getPrimaryConditionClause").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(this.tableDefinition.getParameterClassName(this.isModelContainerAdapter), ModelUtils.getVariable(this.isModelContainerAdapter), new Modifier[0]).returns((TypeName)ClassNames.CONDITION_GROUP);
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("$T clause = $T.clause();", new Object[]{ClassNames.CONDITION_GROUP, ClassNames.CONDITION_GROUP});
        for (ColumnDefinition columnDefinition : this.tableDefinition.getPrimaryColumnDefinitions()) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            columnDefinition.appendPropertyComparisonAccessStatement(this.isModelContainerAdapter, codeBuilder);
            code.add(codeBuilder.build());
        }
        methodBuilder.addCode(code.build());
        methodBuilder.addStatement("return clause", new Object[0]);
        return methodBuilder.build();
    }
}

