/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.OneToManyDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Modifier;

public class LoadFromCursorMethod
implements MethodDefinition {
    public static final String PARAM_MODEL = "model";
    public static final String PARAM_CURSOR = "cursor";
    private BaseTableDefinition baseTableDefinition;
    private final boolean isModelContainerAdapter;
    private final boolean implementsLoadFromCursorListener;
    private final boolean putNullForContainerAdapter;

    public LoadFromCursorMethod(BaseTableDefinition baseTableDefinition, boolean isModelContainerAdapter, boolean implementsLoadFromCursorListener, boolean putNullForContainerAdapter) {
        this.baseTableDefinition = baseTableDefinition;
        this.isModelContainerAdapter = isModelContainerAdapter;
        this.implementsLoadFromCursorListener = implementsLoadFromCursorListener;
        this.putNullForContainerAdapter = putNullForContainerAdapter;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"loadFromCursor").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ClassNames.CURSOR, PARAM_CURSOR, new Modifier[0]).addParameter(this.baseTableDefinition.getParameterClassName(this.isModelContainerAdapter), ModelUtils.getVariable(this.isModelContainerAdapter), new Modifier[0]).returns(TypeName.VOID);
        List<ColumnDefinition> columnDefinitionList = this.baseTableDefinition.getColumnDefinitions();
        AtomicInteger index = new AtomicInteger(0);
        for (ColumnDefinition columnDefinition : columnDefinitionList) {
            methodBuilder.addCode(columnDefinition.getLoadFromCursorMethod(this.isModelContainerAdapter, this.putNullForContainerAdapter, true, index));
            index.incrementAndGet();
        }
        if (this.baseTableDefinition instanceof TableDefinition && !this.isModelContainerAdapter) {
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            List<OneToManyDefinition> oneToManyDefinitions = ((TableDefinition)this.baseTableDefinition).oneToManyDefinitions;
            for (OneToManyDefinition oneToMany : oneToManyDefinitions) {
                if (!oneToMany.isLoad()) continue;
                oneToMany.writeLoad(codeBuilder);
            }
            methodBuilder.addCode(codeBuilder.build());
        }
        if (this.baseTableDefinition instanceof TableDefinition && ((TableDefinition)this.baseTableDefinition).implementsLoadFromCursorListener) {
            methodBuilder.addStatement("$L.onLoadFromCursor($L)", new Object[]{ModelUtils.getVariable(this.isModelContainerAdapter), PARAM_CURSOR});
        }
        return methodBuilder.build();
    }
}

