/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class ExistenceMethod
implements MethodDefinition {
    public static final String PARAM_MODEL = "model";
    private final BaseTableDefinition tableDefinition;
    private final boolean isModelContainerAdapter;

    public ExistenceMethod(BaseTableDefinition tableDefinition, boolean isModelContainerAdapter) {
        this.tableDefinition = tableDefinition;
        this.isModelContainerAdapter = isModelContainerAdapter;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"exists").addAnnotation(Override.class).addParameter(this.tableDefinition.getParameterClassName(this.isModelContainerAdapter), ModelUtils.getVariable(this.isModelContainerAdapter), new Modifier[0]).addParameter((TypeName)ClassNames.DATABASE_WRAPPER, "wrapper", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(TypeName.BOOLEAN);
        if (this.tableDefinition.hasAutoIncrement() || this.tableDefinition.hasRowID()) {
            ColumnDefinition columnDefinition = this.tableDefinition.getAutoIncrementColumn();
            CodeBlock.Builder incrementBuilder = CodeBlock.builder().add("return ", new Object[0]);
            String columnAccess = columnDefinition.getColumnAccessString(this.isModelContainerAdapter, false);
            if (!columnDefinition.elementTypeName.isPrimitive()) {
                incrementBuilder.add("($L != null && ", new Object[]{columnAccess});
            }
            incrementBuilder.add("$L > 0", new Object[]{columnAccess});
            if (!columnDefinition.elementTypeName.isPrimitive()) {
                incrementBuilder.add(" || $L == null)", new Object[]{columnAccess});
            }
            methodBuilder.addCode(incrementBuilder.build());
        }
        if (!this.tableDefinition.hasRowID() && !this.tableDefinition.hasAutoIncrement() || !this.tableDefinition.getAutoIncrementColumn().isQuickCheckPrimaryKeyAutoIncrement) {
            if (this.tableDefinition.hasAutoIncrement() || this.tableDefinition.hasRowID()) {
                methodBuilder.addCode(" && ", new Object[0]);
            } else {
                methodBuilder.addCode("return ", new Object[0]);
            }
            methodBuilder.addCode("new $T($T.count()).from($T.class).where(getPrimaryConditionClause($L)).count(wrapper) > 0", new Object[]{ClassNames.SELECT, ClassNames.METHOD, this.tableDefinition.elementClassName, ModelUtils.getVariable(this.isModelContainerAdapter)});
        }
        methodBuilder.addCode(";\n", new Object[0]);
        return methodBuilder.build();
    }
}

