/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.annotation.Database;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.MigrationDefinition;
import com.raizlabs.android.dbflow.processor.definition.ModelViewDefinition;
import com.raizlabs.android.dbflow.processor.definition.QueryModelDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.TypeDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.DatabaseHolderDefinition;
import com.raizlabs.android.dbflow.processor.handler.DatabaseHandler;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.raizlabs.android.dbflow.processor.validator.ModelViewValidator;
import com.raizlabs.android.dbflow.processor.validator.TableValidator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public class DatabaseDefinition
extends BaseDefinition
implements TypeDefinition {
    public String databaseName;
    public int databaseVersion;
    boolean foreignKeysSupported;
    boolean consistencyChecksEnabled;
    boolean backupEnabled;
    public ConflictAction insertConflict;
    public ConflictAction updateConflict;
    public String classSeparator;
    public String fieldRefSeparator;
    public boolean isInMemory;
    private DatabaseHolderDefinition holderDefinition;

    public DatabaseDefinition(ProcessorManager manager, Element element) {
        super(element, manager);
        this.packageName = "com.raizlabs.android.dbflow.config";
        Database database = element.getAnnotation(Database.class);
        if (database != null) {
            this.databaseName = database.name();
            if (this.databaseName == null || this.databaseName.isEmpty()) {
                this.databaseName = element.getSimpleName().toString();
            }
            if (!DatabaseDefinition.isValidDatabaseName(this.databaseName)) {
                throw new Error("Database name [ " + this.databaseName + " ] is not valid. It must pass [A-Za-z_$]+[a-zA-Z0-9_$]* " + "regex so it can't start with a number or contain any special character except '$'. Especially a dot character is not allowed!");
            }
            this.consistencyChecksEnabled = database.consistencyCheckEnabled();
            this.backupEnabled = database.backupEnabled();
            this.classSeparator = database.generatedClassSeparator();
            this.fieldRefSeparator = !StringUtils.isNullOrEmpty(this.classSeparator) ? (this.classSeparator.matches("[$]+") ? this.classSeparator + this.classSeparator : this.classSeparator) : this.classSeparator;
            this.setOutputClassName(this.databaseName + this.classSeparator + "Database");
            this.databaseVersion = database.version();
            this.foreignKeysSupported = database.foreignKeysSupported();
            this.insertConflict = database.insertConflict();
            this.updateConflict = database.updateConflict();
            this.isInMemory = database.inMemory();
        }
    }

    public DatabaseHolderDefinition getHolderDefinition() {
        return this.holderDefinition;
    }

    public void setHolderDefinition(DatabaseHolderDefinition holderDefinition) {
        this.holderDefinition = holderDefinition;
    }

    @Override
    protected TypeName getExtendsClass() {
        return ClassNames.BASE_DATABASE_DEFINITION_CLASSNAME;
    }

    @Override
    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
        this.writeConstructor(typeBuilder);
        this.writeGetters(typeBuilder);
    }

    public void validateAndPrepareToWrite() {
        this.prepareDefinitions();
        this.validateDefinitions();
    }

    private void validateDefinitions() {
        HashMap<TypeName, TableDefinition> map = new HashMap<TypeName, TableDefinition>();
        TableValidator tableValidator = new TableValidator();
        for (TableDefinition tableDefinition : this.manager.getTableDefinitions((TypeName)this.elementClassName)) {
            if (!tableValidator.validate(ProcessorManager.getManager(), tableDefinition)) continue;
            map.put((TypeName)tableDefinition.elementClassName, tableDefinition);
        }
        this.manager.setTableDefinitions(map, (TypeName)this.elementClassName);
        HashMap<TypeName, ModelViewDefinition> modelViewDefinitionMap = new HashMap<TypeName, ModelViewDefinition>();
        ModelViewValidator modelViewValidator = new ModelViewValidator();
        for (ModelViewDefinition modelViewDefinition : this.manager.getModelViewDefinitions((TypeName)this.elementClassName)) {
            if (!modelViewValidator.validate(ProcessorManager.getManager(), modelViewDefinition)) continue;
            modelViewDefinitionMap.put((TypeName)modelViewDefinition.elementClassName, modelViewDefinition);
        }
        this.manager.setModelViewDefinitions(modelViewDefinitionMap, this.elementClassName);
    }

    private void prepareDefinitions() {
        for (TableDefinition tableDefinition : this.manager.getTableDefinitions((TypeName)this.elementClassName)) {
            tableDefinition.prepareForWrite();
        }
        for (ModelViewDefinition modelViewDefinition : this.manager.getModelViewDefinitions((TypeName)this.elementClassName)) {
            modelViewDefinition.prepareForWrite();
        }
        for (QueryModelDefinition queryModelDefinition : this.manager.getQueryModelDefinitions((TypeName)this.elementClassName)) {
            queryModelDefinition.prepareForWrite();
        }
    }

    private void writeConstructor(TypeSpec.Builder builder) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassNames.DATABASE_HOLDER, "holder", new Modifier[0]);
        for (TableDefinition tableDefinition : this.manager.getTableDefinitions((TypeName)this.elementClassName)) {
            constructor.addStatement("holder.putDatabaseForTable($T.class, this)", new Object[]{tableDefinition.elementClassName});
        }
        for (ModelViewDefinition modelViewDefinition : this.manager.getModelViewDefinitions((TypeName)this.elementClassName)) {
            constructor.addStatement("holder.putDatabaseForTable($T.class, this)", new Object[]{modelViewDefinition.elementClassName});
        }
        for (QueryModelDefinition queryModelDefinition : this.manager.getQueryModelDefinitions((TypeName)this.elementClassName)) {
            constructor.addStatement("holder.putDatabaseForTable($T.class, this)", new Object[]{queryModelDefinition.elementClassName});
        }
        Map<Integer, List<MigrationDefinition>> migrationDefinitionMap = this.manager.getMigrationsForDatabase((TypeName)this.elementClassName);
        if (migrationDefinitionMap != null && !migrationDefinitionMap.isEmpty()) {
            ArrayList<Integer> versionSet = new ArrayList<Integer>(migrationDefinitionMap.keySet());
            Collections.sort(versionSet);
            for (Integer version : versionSet) {
                List<MigrationDefinition> migrationDefinitions = migrationDefinitionMap.get(version);
                Collections.sort(migrationDefinitions, new Comparator<MigrationDefinition>(){

                    @Override
                    public int compare(MigrationDefinition o1, MigrationDefinition o2) {
                        return Integer.valueOf(o2.priority).compareTo(o1.priority);
                    }
                });
                constructor.addStatement("$T migrations$L = new $T()", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassNames.MIGRATION}), version, ParameterizedTypeName.get(ArrayList.class)});
                constructor.addStatement("$L.put($L, migrations$L)", new Object[]{"migrationMap", version, version});
                for (MigrationDefinition migrationDefinition : migrationDefinitions) {
                    constructor.addStatement("migrations$L.add(new $T$L)", new Object[]{version, migrationDefinition.elementClassName, migrationDefinition.getConstructorName()});
                }
            }
        }
        for (TableDefinition tableDefinition : this.manager.getTableDefinitions((TypeName)this.elementClassName)) {
            constructor.addStatement("$L.add($T.class)", new Object[]{"models", tableDefinition.elementClassName});
            constructor.addStatement("$L.put($S, $T.class)", new Object[]{"modelTableNames", tableDefinition.tableName, tableDefinition.elementClassName});
            constructor.addStatement("$L.put($T.class, new $T(holder, this))", new Object[]{"modelAdapters", tableDefinition.elementClassName, tableDefinition.getAdapterClassName()});
            if (tableDefinition.modelContainerDefinition == null) continue;
            constructor.addStatement("$L.put($T.class, new $T(holder, this))", new Object[]{"modelContainerAdapters", tableDefinition.modelContainerDefinition.elementClassName, tableDefinition.modelContainerDefinition.outputClassName});
        }
        for (ModelViewDefinition modelViewDefinition : this.manager.getModelViewDefinitions((TypeName)this.elementClassName)) {
            constructor.addStatement("$L.add($T.class)", new Object[]{"modelViews", modelViewDefinition.elementClassName});
            constructor.addStatement("$L.put($T.class, new $T(holder, this))", new Object[]{"modelViewAdapterMap", modelViewDefinition.elementClassName, modelViewDefinition.outputClassName});
        }
        for (QueryModelDefinition queryModelDefinition : this.manager.getQueryModelDefinitions((TypeName)this.elementClassName)) {
            constructor.addStatement("$L.put($T.class, new $T(holder, this))", new Object[]{"queryModelAdapterMap", queryModelDefinition.elementClassName, queryModelDefinition.getAdapterClassName()});
        }
        builder.addMethod(constructor.build());
    }

    private void writeGetters(TypeSpec.Builder typeBuilder) {
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getAssociatedDatabaseClassFile").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $T.class", new Object[]{this.elementTypeName}).returns(ParameterizedTypeName.get(Class.class)).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"isForeignKeysSupported").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $L", new Object[]{this.foreignKeysSupported}).returns(TypeName.BOOLEAN).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"isInMemory").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $L", new Object[]{this.isInMemory}).returns(TypeName.BOOLEAN).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"backupEnabled").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $L", new Object[]{this.backupEnabled}).returns(TypeName.BOOLEAN).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"areConsistencyChecksEnabled").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $L", new Object[]{this.consistencyChecksEnabled}).returns(TypeName.BOOLEAN).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getDatabaseVersion").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $L", new Object[]{this.databaseVersion}).returns(TypeName.INT).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getDatabaseName").addAnnotation(Override.class).addModifiers(DatabaseHandler.METHOD_MODIFIERS).addStatement("return $S", new Object[]{this.databaseName}).returns((TypeName)ClassName.get(String.class)).build());
    }

    private static boolean isValidDatabaseName(String databaseName) {
        Pattern javaClassNamePattern = Pattern.compile("[A-Za-z_$]+[a-zA-Z0-9_$]*");
        return javaClassNamePattern.matcher(databaseName).matches();
    }
}

