/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.CodeAdder;
import com.raizlabs.android.dbflow.processor.definition.TypeAdder;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class CustomTypeConverterPropertyMethod
implements TypeAdder,
CodeAdder {
    private final BaseTableDefinition baseTableDefinition;

    public CustomTypeConverterPropertyMethod(BaseTableDefinition baseTableDefinition) {
        this.baseTableDefinition = baseTableDefinition;
    }

    @Override
    public void addToType(TypeSpec.Builder typeBuilder) {
        Set<ClassName> customTypeConverters = this.baseTableDefinition.getAssociatedTypeConverters().keySet();
        for (ClassName className : customTypeConverters) {
            typeBuilder.addField(FieldSpec.builder((TypeName)className, (String)("typeConverter" + className.simpleName()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{className}).build());
        }
        Set<ClassName> globalTypeConverters = this.baseTableDefinition.getGlobalTypeConverters().keySet();
        for (ClassName className : globalTypeConverters) {
            typeBuilder.addField(FieldSpec.builder((TypeName)className, (String)("global_typeConverter" + className.simpleName()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        }
    }

    @Override
    public void addCode(CodeBlock.Builder code) {
        Set<ClassName> globalTypeConverters = this.baseTableDefinition.getGlobalTypeConverters().keySet();
        for (ClassName className : globalTypeConverters) {
            List<ColumnDefinition> def = this.baseTableDefinition.getGlobalTypeConverters().get(className);
            TypeName firstTypeName = def.get((int)0).elementTypeName;
            code.addStatement("global_typeConverter$L = ($T) $L.getTypeConverterForClass($T.class)", new Object[]{className.simpleName(), className, "holder", firstTypeName}).build();
        }
    }
}

