/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.method;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.UniqueGroupsDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyReferenceDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;

public class CreationQueryMethod
implements MethodDefinition {
    private TableDefinition tableDefinition;

    public CreationQueryMethod(TableDefinition tableDefinition) {
        this.tableDefinition = tableDefinition;
    }

    @Override
    public MethodSpec getMethodSpec() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getCreationQuery").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)ClassName.get(String.class));
        CodeBlock.Builder creationBuilder = CodeBlock.builder().add("CREATE TABLE IF NOT EXISTS ", new Object[0]).add(QueryBuilder.quote((String)this.tableDefinition.tableName), new Object[0]).add("(", new Object[0]);
        for (int i = 0; i < this.tableDefinition.getColumnDefinitions().size(); ++i) {
            if (i > 0) {
                creationBuilder.add(",", new Object[0]);
            }
            ColumnDefinition columnDefinition = this.tableDefinition.getColumnDefinitions().get(i);
            creationBuilder.add(columnDefinition.getCreationName());
        }
        for (UniqueGroupsDefinition definition : this.tableDefinition.uniqueGroupsDefinitions) {
            if (definition.columnDefinitionList.isEmpty()) continue;
            creationBuilder.add(definition.getCreationName());
        }
        if (!this.tableDefinition.hasAutoIncrement) {
            int primarySize = this.tableDefinition.getPrimaryColumnDefinitions().size();
            for (int i = 0; i < primarySize; ++i) {
                if (i == 0) {
                    creationBuilder.add(", PRIMARY KEY(", new Object[0]);
                }
                if (i > 0) {
                    creationBuilder.add(",", new Object[0]);
                }
                ColumnDefinition primaryDefinition = this.tableDefinition.getPrimaryColumnDefinitions().get(i);
                creationBuilder.add(primaryDefinition.getPrimaryKeyName(), new Object[0]);
                if (i != primarySize - 1) continue;
                creationBuilder.add(")", new Object[0]);
                if (StringUtils.isNullOrEmpty(this.tableDefinition.primaryKeyConflictActionName)) continue;
                creationBuilder.add(" ON CONFLICT " + this.tableDefinition.primaryKeyConflictActionName, new Object[0]);
            }
        }
        int foreignSize = this.tableDefinition.foreignKeyDefinitions.size();
        ArrayList<CodeBlock> foreignKeyBlocks = new ArrayList<CodeBlock>();
        ArrayList<CodeBlock> tableNameBlocks = new ArrayList<CodeBlock>();
        ArrayList<CodeBlock> referenceKeyBlocks = new ArrayList<CodeBlock>();
        for (int i = 0; i < foreignSize; ++i) {
            ForeignKeyReferenceDefinition referenceDefinition;
            int j;
            CodeBlock.Builder foreignKeyBuilder = CodeBlock.builder();
            CodeBlock.Builder referenceBuilder = CodeBlock.builder();
            ForeignKeyColumnDefinition foreignKeyColumnDefinition = this.tableDefinition.foreignKeyDefinitions.get(i);
            foreignKeyBuilder.add(", FOREIGN KEY(", new Object[0]);
            for (j = 0; j < foreignKeyColumnDefinition.foreignKeyReferenceDefinitionList.size(); ++j) {
                if (j > 0) {
                    foreignKeyBuilder.add(",", new Object[0]);
                }
                referenceDefinition = foreignKeyColumnDefinition.foreignKeyReferenceDefinitionList.get(j);
                foreignKeyBuilder.add("$L", new Object[]{QueryBuilder.quote((String)referenceDefinition.columnName)});
            }
            foreignKeyBuilder.add(") REFERENCES ", new Object[0]);
            foreignKeyBlocks.add(foreignKeyBuilder.build());
            tableNameBlocks.add(CodeBlock.builder().add("$T.getTableName($T.class)", new Object[]{ClassNames.FLOW_MANAGER, foreignKeyColumnDefinition.referencedTableClassName}).build());
            referenceBuilder.add("(", new Object[0]);
            for (j = 0; j < foreignKeyColumnDefinition.foreignKeyReferenceDefinitionList.size(); ++j) {
                if (j > 0) {
                    referenceBuilder.add(", ", new Object[0]);
                }
                referenceDefinition = foreignKeyColumnDefinition.foreignKeyReferenceDefinitionList.get(j);
                referenceBuilder.add("$L", new Object[]{QueryBuilder.quote((String)referenceDefinition.foreignColumnName)});
            }
            referenceBuilder.add(") ON UPDATE $L ON DELETE $L", new Object[]{foreignKeyColumnDefinition.onUpdate.name().replace("_", " "), foreignKeyColumnDefinition.onDelete.name().replace("_", " ")});
            referenceKeyBlocks.add(referenceBuilder.build());
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder().add("return $S", new Object[]{creationBuilder.build().toString()});
        if (foreignSize > 0) {
            for (int i = 0; i < foreignSize; ++i) {
                codeBuilder.add("+ $S + $L + $S", new Object[]{foreignKeyBlocks.get(i), tableNameBlocks.get(i), referenceKeyBlocks.get(i)});
            }
        }
        codeBuilder.add(" + $S", new Object[]{");"}).add(";\n", new Object[0]);
        methodBuilder.addCode(codeBuilder.build());
        return methodBuilder.build();
    }
}

