/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.processor.definition.column.BaseColumnAccess;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;

public class SimpleColumnAccess
extends BaseColumnAccess {
    private final boolean dontAppendModel;

    public SimpleColumnAccess() {
        this(false);
    }

    public SimpleColumnAccess(boolean dontAppendModel) {
        this.dontAppendModel = dontAppendModel;
    }

    @Override
    public String getColumnAccessString(TypeName fieldType, String elementName, String fullElementName, String variableNameString, boolean isModelContainerAdapter, boolean isSqliteStatement) {
        if (isModelContainerAdapter) {
            String method = SQLiteHelper.getModelContainerMethod(fieldType);
            if (method == null) {
                method = "get";
            }
            return variableNameString + "." + method + "Value(\"" + elementName + "\")";
        }
        return this.dontAppendModel ? elementName : variableNameString + "." + fullElementName;
    }

    @Override
    public String getShortAccessString(TypeName fieldType, String elementName, boolean isModelContainerAdapter, boolean isSqliteStatement) {
        return elementName;
    }

    @Override
    public String setColumnAccessString(TypeName fieldType, String elementName, String fullElementName, boolean isModelContainerAdapter, String variableNameString, CodeBlock formattedAccess, boolean toModel) {
        if (isModelContainerAdapter) {
            return variableNameString + ".put(\"" + elementName + "\", " + formattedAccess + ")";
        }
        return this.getColumnAccessString(fieldType, elementName, fullElementName, variableNameString, false, false) + " = " + formattedAccess;
    }
}

