/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.data.Blob;
import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.processor.definition.column.BaseColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.BlobColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.BooleanTypeColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.EnumColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.TypeConverterAccess;
import com.raizlabs.android.dbflow.processor.definition.column.WrapperColumnAccess;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.concurrent.atomic.AtomicInteger;

public class DefinitionUtils {
    public static CodeBlock.Builder getContentValuesStatement(String elementName, String fullElementName, String columnName, TypeName elementTypeName, boolean isModelContainerAdapter, BaseColumnAccess columnAccess, String variableNameString, String defaultValue, ClassName tableTableClassName) {
        String statement = columnAccess.getColumnAccessString(elementTypeName, elementName, fullElementName, variableNameString, isModelContainerAdapter, false);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        String finalAccessStatement = statement;
        boolean isBlobRaw = false;
        Object finalTypeName = elementTypeName;
        if (columnAccess instanceof WrapperColumnAccess && !(columnAccess instanceof BooleanTypeColumnAccess) || isModelContainerAdapter && !elementTypeName.isPrimitive()) {
            String string = finalAccessStatement = isModelContainerAdapter ? variableNameString + elementName : "ref" + fullElementName;
            if (columnAccess instanceof TypeConverterAccess) {
                if (((TypeConverterAccess)columnAccess).typeConverterDefinition != null) {
                    finalTypeName = ((TypeConverterAccess)columnAccess).typeConverterDefinition.getDbTypeName();
                }
                isBlobRaw = finalTypeName.equals((Object)ClassName.get(Blob.class));
            } else {
                finalTypeName = columnAccess instanceof EnumColumnAccess ? ClassName.get(String.class) : (columnAccess instanceof BlobColumnAccess ? ArrayTypeName.of((TypeName)TypeName.BYTE) : elementTypeName);
            }
            if (!isModelContainerAdapter && !elementTypeName.isPrimitive()) {
                String shortAccess = ((WrapperColumnAccess)columnAccess).existingColumnAccess.getShortAccessString(elementTypeName, elementName, isModelContainerAdapter, false);
                codeBuilder.addStatement("$T $L = model.$L != null ? $L : null", new Object[]{finalTypeName, finalAccessStatement, shortAccess, statement});
            } else {
                codeBuilder.addStatement("$T $L = $L", new Object[]{finalTypeName, finalAccessStatement, statement});
            }
        }
        String putAccess = DefinitionUtils.applyAndGetPutAccess(finalAccessStatement, isBlobRaw, elementTypeName, finalTypeName, isModelContainerAdapter, columnAccess, codeBuilder, variableNameString, elementName);
        codeBuilder.addStatement("$L.put($T.$L.getCursorKey(), $L)", new Object[]{"values", tableTableClassName, columnName, putAccess});
        if (!finalTypeName.isPrimitive()) {
            codeBuilder.nextControlFlow("else", new Object[0]);
            if (defaultValue != null && !defaultValue.isEmpty()) {
                codeBuilder.addStatement("$L.put($T.$L.getCursorKey(), $L)", new Object[]{"values", tableTableClassName, columnName, defaultValue});
            } else {
                codeBuilder.addStatement("$L.putNull($T.$L.getCursorKey())", new Object[]{"values", tableTableClassName, columnName});
            }
            codeBuilder.endControlFlow();
        }
        return codeBuilder;
    }

    public static CodeBlock.Builder getSQLiteStatementMethod(AtomicInteger index, String elementName, String fullElementName, TypeName elementTypeName, boolean isModelContainerAdapter, BaseColumnAccess columnAccess, String variableNameString, boolean isAutoIncrement, String defaultValue) {
        String statement = columnAccess.getColumnAccessString(elementTypeName, elementName, fullElementName, variableNameString, isModelContainerAdapter, true);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        String finalAccessStatement = statement;
        boolean isBlobRaw = false;
        Object finalTypeName = elementTypeName;
        if (columnAccess instanceof WrapperColumnAccess && !(columnAccess instanceof BooleanTypeColumnAccess) || isModelContainerAdapter && !elementTypeName.isPrimitive()) {
            String string = finalAccessStatement = isModelContainerAdapter ? variableNameString + elementName : "ref" + fullElementName;
            if (columnAccess instanceof TypeConverterAccess) {
                if (((TypeConverterAccess)columnAccess).typeConverterDefinition != null) {
                    finalTypeName = ((TypeConverterAccess)columnAccess).typeConverterDefinition.getDbTypeName();
                }
                isBlobRaw = finalTypeName.equals((Object)ClassName.get(Blob.class));
            } else {
                finalTypeName = columnAccess instanceof EnumColumnAccess ? ClassName.get(String.class) : (columnAccess instanceof BlobColumnAccess ? ArrayTypeName.of((TypeName)TypeName.BYTE) : elementTypeName);
            }
            if (!isModelContainerAdapter && !elementTypeName.isPrimitive()) {
                String shortAccess = ((WrapperColumnAccess)columnAccess).existingColumnAccess.getShortAccessString(elementTypeName, elementName, isModelContainerAdapter, true);
                codeBuilder.addStatement("$T $L = model.$L != null ? $L : null", new Object[]{finalTypeName, finalAccessStatement, shortAccess, statement});
            } else {
                codeBuilder.addStatement("$T $L = $L", new Object[]{finalTypeName, finalAccessStatement, statement});
            }
        }
        String putAccess = DefinitionUtils.applyAndGetPutAccess(finalAccessStatement, isBlobRaw, elementTypeName, finalTypeName, isModelContainerAdapter, columnAccess, codeBuilder, variableNameString, elementName);
        codeBuilder.addStatement("$L.bind$L($L, $L)", new Object[]{"statement", columnAccess.getSqliteTypeForTypeName(elementTypeName, isModelContainerAdapter).getSQLiteStatementMethod(), index.intValue() + (!isAutoIncrement ? " + start" : ""), putAccess});
        if (!finalTypeName.isPrimitive()) {
            codeBuilder.nextControlFlow("else", new Object[0]);
            if (defaultValue != null && !defaultValue.isEmpty()) {
                codeBuilder.addStatement("$L.bind$L($L, $L)", new Object[]{"statement", columnAccess.getSqliteTypeForTypeName(elementTypeName, isModelContainerAdapter).getSQLiteStatementMethod(), index.intValue() + (!isAutoIncrement ? " + start" : ""), defaultValue});
            } else {
                codeBuilder.addStatement("$L.bindNull($L)", new Object[]{"statement", index.intValue() + (!isAutoIncrement ? " + start" : "")});
            }
            codeBuilder.endControlFlow();
        }
        return codeBuilder;
    }

    private static String applyAndGetPutAccess(String finalAccessStatement, boolean isBlobRaw, TypeName elementTypeName, TypeName finalTypeName, boolean isModelContainerAdapter, BaseColumnAccess columnAccess, CodeBlock.Builder codeBuilder, String variableNameString, String elementName) {
        String putAccess = finalAccessStatement;
        if (isBlobRaw) {
            putAccess = putAccess + ".getBlob()";
        } else if (elementTypeName.box().equals((Object)TypeName.CHAR.box())) {
            putAccess = "new String(new char[]{" + putAccess + "})";
        }
        if (!finalTypeName.isPrimitive()) {
            if (!isModelContainerAdapter && isBlobRaw) {
                codeBuilder.beginControlFlow("if (($L != null) && ($L != null))", new Object[]{variableNameString + "." + elementName, putAccess});
            } else {
                codeBuilder.beginControlFlow("if ($L != null)", new Object[]{putAccess});
            }
        }
        return putAccess;
    }

    public static CodeBlock.Builder getLoadFromCursorMethod(int index, String fullElementName, TypeName elementTypeName, String columnName, boolean isModelContainerAdapter, boolean putDefaultValue, BaseColumnAccess columnAccess, boolean orderedCursorLookUp, boolean assignDefaultValuesFromCursor, String elementName) {
        String indexName;
        String method = DefinitionUtils.getLoadFromCursorMethodString(elementTypeName, columnAccess);
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        if (!orderedCursorLookUp || index == -1) {
            indexName = "index" + columnName;
            codeBuilder.addStatement("int $L = $L.getColumnIndex($S)", new Object[]{indexName, "cursor", columnName});
            codeBuilder.beginControlFlow("if ($L != -1 && !$L.isNull($L))", new Object[]{indexName, "cursor", indexName});
        } else {
            indexName = index + "";
            codeBuilder.beginControlFlow("if (!$L.isNull($L))", new Object[]{"cursor", indexName});
        }
        CodeBlock.Builder cursorAssignment = CodeBlock.builder();
        if (elementTypeName.box().equals((Object)TypeName.BYTE.box())) {
            cursorAssignment.add("($T)", new Object[]{TypeName.BYTE});
        }
        cursorAssignment.add("$L.$L($L)", new Object[]{"cursor", method, indexName});
        if (elementTypeName.box().equals((Object)TypeName.CHAR.box())) {
            cursorAssignment.add(".charAt(0)", new Object[0]);
        }
        codeBuilder.addStatement(columnAccess.setColumnAccessString(elementTypeName, elementName, fullElementName, isModelContainerAdapter, ModelUtils.getVariable(isModelContainerAdapter), cursorAssignment.build(), false), new Object[0]);
        if (putDefaultValue && assignDefaultValuesFromCursor) {
            codeBuilder.nextControlFlow("else", new Object[0]);
            if (isModelContainerAdapter) {
                codeBuilder.addStatement("$L.putDefault($S)", new Object[]{ModelUtils.getVariable(true), columnName});
            } else {
                BaseColumnAccess baseColumnAccess = columnAccess;
                if (columnAccess instanceof WrapperColumnAccess) {
                    baseColumnAccess = ((WrapperColumnAccess)columnAccess).existingColumnAccess;
                }
                codeBuilder.addStatement(baseColumnAccess.setColumnAccessString(elementTypeName, elementName, fullElementName, isModelContainerAdapter, ModelUtils.getVariable(isModelContainerAdapter), CodeBlock.builder().add(DefinitionUtils.getDefaultValueString(elementTypeName), new Object[0]).build(), false), new Object[0]);
            }
        }
        codeBuilder.endControlFlow();
        return codeBuilder;
    }

    public static CodeBlock.Builder getUpdateAutoIncrementMethod(String elementName, String fullElementName, TypeName elementTypeName, boolean isModelContainerAdapter, BaseColumnAccess columnAccess) {
        String method = "";
        boolean shouldCastUp = false;
        if (SQLiteHelper.containsNumberMethod(elementTypeName.unbox())) {
            method = elementTypeName.unbox().toString();
            shouldCastUp = !elementTypeName.isPrimitive();
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        CodeBlock.Builder accessBuilder = CodeBlock.builder();
        if (shouldCastUp) {
            accessBuilder.add("($T)", new Object[]{elementTypeName});
        }
        accessBuilder.add("id.$LValue()", new Object[]{method});
        codeBuilder.addStatement(columnAccess.setColumnAccessString(elementTypeName, elementName, fullElementName, isModelContainerAdapter, ModelUtils.getVariable(isModelContainerAdapter), accessBuilder.build(), false), new Object[0]);
        return codeBuilder;
    }

    public static CodeBlock.Builder getCreationStatement(TypeName elementTypeName, BaseColumnAccess columnAccess, String columnName) {
        String statement = null;
        if (SQLiteHelper.containsType(elementTypeName)) {
            statement = SQLiteHelper.get(elementTypeName).toString();
        } else if (columnAccess instanceof TypeConverterAccess && ((TypeConverterAccess)columnAccess).typeConverterDefinition != null) {
            statement = SQLiteHelper.get(((TypeConverterAccess)columnAccess).typeConverterDefinition.getDbTypeName()).toString();
        }
        return CodeBlock.builder().add("$L $L", new Object[]{QueryBuilder.quote((String)columnName), statement});
    }

    public static String getLoadFromCursorMethodString(TypeName elementTypeName, BaseColumnAccess columnAccess) {
        String method = "";
        if (SQLiteHelper.containsMethod(elementTypeName)) {
            method = SQLiteHelper.getMethod(elementTypeName);
        } else if (columnAccess instanceof TypeConverterAccess && ((TypeConverterAccess)columnAccess).typeConverterDefinition != null) {
            method = SQLiteHelper.getMethod(((TypeConverterAccess)columnAccess).typeConverterDefinition.getDbTypeName());
        } else if (columnAccess instanceof EnumColumnAccess) {
            method = SQLiteHelper.getMethod((TypeName)ClassName.get(String.class));
        }
        return method;
    }

    public static String getDefaultValueString(TypeName elementTypeName) {
        String defaultValue = "null";
        if (elementTypeName.isPrimitive()) {
            if (elementTypeName.equals((Object)TypeName.BOOLEAN)) {
                defaultValue = "false";
            } else if (elementTypeName.equals((Object)TypeName.BYTE) || elementTypeName.equals((Object)TypeName.INT) || elementTypeName.equals((Object)TypeName.DOUBLE) || elementTypeName.equals((Object)TypeName.FLOAT) || elementTypeName.equals((Object)TypeName.LONG) || elementTypeName.equals((Object)TypeName.SHORT)) {
                defaultValue = "0";
            } else if (elementTypeName.equals((Object)TypeName.CHAR)) {
                defaultValue = "'\\u0000'";
            }
        }
        return defaultValue;
    }
}

