/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition.column;

import com.raizlabs.android.dbflow.annotation.Collate;
import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.annotation.ContainerKey;
import com.raizlabs.android.dbflow.annotation.ForeignKeyReference;
import com.raizlabs.android.dbflow.annotation.Index;
import com.raizlabs.android.dbflow.annotation.NotNull;
import com.raizlabs.android.dbflow.annotation.PrimaryKey;
import com.raizlabs.android.dbflow.annotation.Unique;
import com.raizlabs.android.dbflow.data.Blob;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.SQLiteHelper;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.BaseTableDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.TypeConverterDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.BaseColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.BlobColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.BooleanColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.BooleanTypeColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.DefinitionUtils;
import com.raizlabs.android.dbflow.processor.definition.column.EnumColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PackagePrivateAccess;
import com.raizlabs.android.dbflow.processor.definition.column.PrivateColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.SimpleColumnAccess;
import com.raizlabs.android.dbflow.processor.definition.column.TypeConverterAccess;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.tools.Diagnostic;

public class ColumnDefinition
extends BaseDefinition {
    public String columnName;
    public String containerKeyName;
    public boolean putContainerDefaultValue;
    public boolean excludeFromToModelMethod;
    public boolean hasTypeConverter;
    public boolean isPrimaryKey;
    private boolean isPrimaryKeyAutoIncrement;
    public boolean isQuickCheckPrimaryKeyAutoIncrement;
    public boolean isRowId;
    public Column column;
    public int length = -1;
    public boolean notNull = false;
    public ConflictAction onNullConflict;
    public ConflictAction onUniqueConflict;
    public boolean unique = false;
    public List<Integer> uniqueGroups = new ArrayList<Integer>();
    public List<Integer> indexGroups = new ArrayList<Integer>();
    public Collate collate = Collate.NONE;
    public String defaultValue;
    public boolean isBoolean = false;
    public BaseColumnAccess columnAccess;
    public boolean hasCustomConverter;
    public BaseTableDefinition tableDefinition;

    public ColumnDefinition(ProcessorManager processorManager, Element element, BaseTableDefinition baseTableDefinition, boolean isPackagePrivate, Column column, PrimaryKey primaryKey) {
        super(element, processorManager);
        ContainerKey containerKey;
        NotNull notNullAnno;
        Unique uniqueColumn;
        this.tableDefinition = baseTableDefinition;
        this.column = column;
        if (column != null) {
            this.columnName = column.name().equals("") ? element.getSimpleName().toString() : column.name();
            this.length = column.length();
            this.collate = column.collate();
            this.defaultValue = column.defaultValue();
            this.excludeFromToModelMethod = column.excludeFromToModelMethod();
        } else {
            this.columnName = element.getSimpleName().toString();
        }
        if (isPackagePrivate) {
            this.columnAccess = PackagePrivateAccess.from(processorManager, element, baseTableDefinition.databaseDefinition.classSeparator);
            PackagePrivateAccess.putElement(((PackagePrivateAccess)this.columnAccess).helperClassName, this.columnName);
        } else {
            boolean isPrivate = element.getModifiers().contains((Object)Modifier.PRIVATE);
            if (isPrivate) {
                boolean useIs = this.elementTypeName.box().equals((Object)TypeName.BOOLEAN.box()) && baseTableDefinition instanceof TableDefinition && ((TableDefinition)baseTableDefinition).useIsForPrivateBooleans;
                this.columnAccess = new PrivateColumnAccess(column, useIs);
            } else {
                this.columnAccess = new SimpleColumnAccess();
            }
        }
        if (primaryKey != null) {
            if (primaryKey.rowID()) {
                this.isRowId = true;
            } else if (primaryKey.autoincrement()) {
                this.isPrimaryKeyAutoIncrement = true;
                this.isQuickCheckPrimaryKeyAutoIncrement = primaryKey.quickCheckAutoIncrement();
            } else {
                this.isPrimaryKey = true;
            }
        }
        if ((uniqueColumn = element.getAnnotation(Unique.class)) != null) {
            int[] groups;
            this.unique = uniqueColumn.unique();
            this.onUniqueConflict = uniqueColumn.onUniqueConflict();
            for (int group : groups = uniqueColumn.uniqueGroups()) {
                this.uniqueGroups.add(group);
            }
        }
        if ((notNullAnno = element.getAnnotation(NotNull.class)) != null) {
            this.notNull = true;
            this.onNullConflict = notNullAnno.onNullConflict();
        }
        if ((containerKey = element.getAnnotation(ContainerKey.class)) != null) {
            this.containerKeyName = containerKey.value();
            if (StringUtils.isNullOrEmpty(this.containerKeyName)) {
                this.containerKeyName = this.elementName;
            }
            this.putContainerDefaultValue = containerKey.putDefault();
        } else {
            this.containerKeyName = this.elementName;
            this.putContainerDefaultValue = true;
        }
        Index index = element.getAnnotation(Index.class);
        if (index != null) {
            if (index.indexGroups().length == 0) {
                this.indexGroups.add(-1);
            } else {
                for (int group : index.indexGroups()) {
                    this.indexGroups.add(group);
                }
            }
        }
        ClassName typeConverterClassName = null;
        TypeElement typeConverterElement = null;
        if (column != null) {
            try {
                column.typeConverter();
            }
            catch (MirroredTypeException mte) {
                typeConverterElement = this.manager.getElements().getTypeElement(mte.getTypeMirror().toString());
                typeConverterClassName = ClassName.get((TypeElement)typeConverterElement);
            }
        }
        this.hasCustomConverter = false;
        if (typeConverterClassName != null && !typeConverterClassName.equals((Object)ClassNames.TYPE_CONVERTER)) {
            TypeConverterDefinition typeConverterDefinition = new TypeConverterDefinition(typeConverterElement, this.manager);
            if (!typeConverterDefinition.getModelTypeName().equals((Object)this.elementTypeName)) {
                this.manager.logError("The specified custom TypeConverter's Model Value %1s from %1s must match the type of the column %1s. ", typeConverterDefinition.getModelTypeName(), typeConverterClassName, this.elementTypeName);
            } else {
                this.hasCustomConverter = true;
                String fieldName = baseTableDefinition.addColumnForCustomTypeConverter(this, typeConverterClassName);
                this.hasTypeConverter = true;
                this.columnAccess = new TypeConverterAccess(this.manager, this, typeConverterDefinition, fieldName);
            }
        }
        if (!this.hasCustomConverter) {
            TypeElement typeElement = this.manager.getElements().getTypeElement(element.asType().toString());
            if (typeElement != null && typeElement.getKind() == ElementKind.ENUM) {
                this.columnAccess = new EnumColumnAccess(this);
            } else if (this.elementTypeName.equals((Object)ClassName.get(Blob.class))) {
                this.columnAccess = new BlobColumnAccess(this);
            } else if (!(this.elementTypeName instanceof ParameterizedTypeName)) {
                if (this.elementTypeName instanceof ArrayTypeName) {
                    processorManager.getMessager().printMessage(Diagnostic.Kind.ERROR, "Columns cannot be of array type.");
                } else if (this.elementTypeName.equals((Object)TypeName.BOOLEAN.box())) {
                    this.isBoolean = true;
                    this.columnAccess = new BooleanColumnAccess(this.manager, this);
                } else if (this.elementTypeName.equals((Object)TypeName.BOOLEAN)) {
                    this.columnAccess = new BooleanTypeColumnAccess(this);
                } else {
                    TypeConverterDefinition typeConverterDefinition = processorManager.getTypeConverterDefinition(this.elementTypeName);
                    if (typeConverterDefinition != null || !SQLiteHelper.containsType(this.elementTypeName)) {
                        this.hasTypeConverter = true;
                        if (typeConverterDefinition != null) {
                            String fieldName = baseTableDefinition.addColumnForTypeConverter(this, typeConverterDefinition.getClassName());
                            this.columnAccess = new TypeConverterAccess(this.manager, this, typeConverterDefinition, fieldName);
                        } else {
                            this.columnAccess = new TypeConverterAccess(this.manager, this);
                        }
                    }
                }
            }
        }
    }

    public ColumnDefinition(ProcessorManager processorManager, Element element, BaseTableDefinition baseTableDefinition, boolean isPackagePrivate) {
        this(processorManager, element, baseTableDefinition, isPackagePrivate, element.getAnnotation(Column.class), element.getAnnotation(PrimaryKey.class));
    }

    @Override
    protected ClassName getElementClassName(Element element) {
        return null;
    }

    public String toString() {
        return QueryBuilder.quoteIfNeeded((String)this.columnName);
    }

    public void addPropertyDefinition(TypeSpec.Builder typeBuilder, TypeName tableClass) {
        Object propParam = this.elementTypeName.isPrimitive() && !this.elementTypeName.equals((Object)TypeName.BOOLEAN) ? ClassName.get((String)"com.raizlabs.android.dbflow.sql.language.property", (String)(StringUtils.capitalize(this.elementTypeName.toString()) + "Property"), (String[])new String[0]) : ParameterizedTypeName.get((ClassName)ClassNames.PROPERTY, (TypeName[])new TypeName[]{this.elementTypeName.box()});
        typeBuilder.addField(FieldSpec.builder((TypeName)propParam, (String)this.columnName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T($T.class, $S)", new Object[]{propParam, tableClass, this.columnName}).build());
    }

    public void addPropertyCase(MethodSpec.Builder methodBuilder) {
        methodBuilder.beginControlFlow("case $S: ", new Object[]{QueryBuilder.quote((String)this.columnName)});
        methodBuilder.addStatement("return $L", new Object[]{this.columnName});
        methodBuilder.endControlFlow();
    }

    public void addColumnName(CodeBlock.Builder codeBuilder) {
        codeBuilder.add(this.columnName, new Object[0]);
    }

    public CodeBlock getInsertStatementColumnName() {
        return CodeBlock.builder().add("$L", new Object[]{QueryBuilder.quote((String)this.columnName)}).build();
    }

    public CodeBlock getInsertStatementValuesString() {
        return CodeBlock.builder().add("?", new Object[0]).build();
    }

    public CodeBlock getContentValuesStatement(boolean isModelContainerAdapter) {
        return DefinitionUtils.getContentValuesStatement(this.containerKeyName, this.elementName, this.columnName, this.elementTypeName, isModelContainerAdapter, this.columnAccess, ModelUtils.getVariable(isModelContainerAdapter), this.defaultValue, this.tableDefinition.outputClassName).build();
    }

    public CodeBlock getSQLiteStatementMethod(AtomicInteger index, boolean isModelContainerAdapter) {
        return DefinitionUtils.getSQLiteStatementMethod(index, this.containerKeyName, this.elementName, this.elementTypeName, isModelContainerAdapter, this.columnAccess, ModelUtils.getVariable(isModelContainerAdapter), this.isPrimaryKeyAutoIncrement || this.isRowId, this.defaultValue).build();
    }

    public CodeBlock getLoadFromCursorMethod(boolean isModelContainerAdapter, boolean putNullForContainerAdapter, boolean endNonPrimitiveIf, AtomicInteger index) {
        boolean putDefaultValue = putNullForContainerAdapter;
        if (this.putContainerDefaultValue != putDefaultValue && isModelContainerAdapter) {
            putDefaultValue = this.putContainerDefaultValue;
        } else if (!isModelContainerAdapter) {
            putDefaultValue = true;
        }
        return DefinitionUtils.getLoadFromCursorMethod(index.intValue(), this.elementName, this.elementTypeName, this.columnName, isModelContainerAdapter, putDefaultValue, this.columnAccess, this.tableDefinition.orderedCursorLookUp, this.tableDefinition.assignDefaultValuesFromCursor, this.containerKeyName).build();
    }

    public CodeBlock getUpdateAutoIncrementMethod(boolean isModelContainerAdapter) {
        return DefinitionUtils.getUpdateAutoIncrementMethod(this.containerKeyName, this.elementName, this.elementTypeName, isModelContainerAdapter, this.columnAccess).build();
    }

    public String setColumnAccessString(CodeBlock formattedAccess, boolean toModelMethod) {
        return this.columnAccess.setColumnAccessString(this.elementTypeName, this.containerKeyName, this.elementName, false, ModelUtils.getVariable(false), formattedAccess, toModelMethod);
    }

    public CodeBlock getToModelMethod() {
        String method = SQLiteHelper.getModelContainerMethod(this.elementTypeName);
        if (method == null) {
            if (this.columnAccess instanceof EnumColumnAccess) {
                method = SQLiteHelper.getModelContainerMethod((TypeName)ClassName.get(String.class));
            } else {
                if (this.columnAccess instanceof TypeConverterAccess && ((TypeConverterAccess)this.columnAccess).typeConverterDefinition != null) {
                    method = SQLiteHelper.getModelContainerMethod(((TypeConverterAccess)this.columnAccess).typeConverterDefinition.getDbTypeName());
                }
                if (method == null) {
                    this.manager.logError("ToModel typename: %1s", this.elementTypeName);
                    method = "get";
                }
            }
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder().add("$L.$LValue($S)", new Object[]{ModelUtils.getVariable(true), method, this.containerKeyName});
        BaseColumnAccess columnAccessToUse = this.columnAccess;
        if (this.columnAccess instanceof BooleanColumnAccess || this.columnAccess instanceof TypeConverterAccess && ((TypeConverterAccess)this.columnAccess).typeConverterDefinition != null && ((TypeConverterAccess)this.columnAccess).typeConverterDefinition.getModelTypeName().equals((Object)TypeName.BOOLEAN.box())) {
            columnAccessToUse = ((TypeConverterAccess)this.columnAccess).existingColumnAccess;
        }
        return CodeBlock.builder().addStatement(columnAccessToUse.setColumnAccessString(this.elementTypeName, this.containerKeyName, this.elementName, false, ModelUtils.getVariable(false), codeBuilder.build(), true), new Object[0]).build();
    }

    public String getColumnAccessString(boolean isModelContainerAdapter, boolean isSqliteStatment) {
        return this.columnAccess.getColumnAccessString(this.elementTypeName, this.containerKeyName, this.elementName, ModelUtils.getVariable(isModelContainerAdapter), isModelContainerAdapter, isSqliteStatment);
    }

    public void appendPropertyComparisonAccessStatement(boolean isModelContainerAdapter, CodeBlock.Builder codeBuilder) {
        codeBuilder.add("\nclause.and($T.$L.eq(", new Object[]{this.tableDefinition.getPropertyClassName(), this.columnName});
        if (this.columnAccess instanceof TypeConverterAccess) {
            TypeConverterAccess converterAccess = (TypeConverterAccess)this.columnAccess;
            TypeConverterDefinition converterDefinition = converterAccess.typeConverterDefinition;
            if (!isModelContainerAdapter) {
                codeBuilder.add(converterAccess.existingColumnAccess.getColumnAccessString(converterDefinition.getDbTypeName(), this.containerKeyName, this.elementName, ModelUtils.getVariable(isModelContainerAdapter), isModelContainerAdapter, false), new Object[0]);
            } else {
                codeBuilder.add(CodeBlock.builder().add("$L.getTypeConvertedPropertyValue($T.class, $S)", new Object[]{ModelUtils.getVariable(isModelContainerAdapter), converterAccess.typeConverterDefinition.getModelTypeName(), this.containerKeyName}).build());
            }
        } else {
            String columnAccessString = this.getColumnAccessString(isModelContainerAdapter, false);
            if (this.columnAccess instanceof BlobColumnAccess) {
                columnAccessString = columnAccessString.substring(0, columnAccessString.lastIndexOf(".getBlob()"));
            } else if (this.columnAccess instanceof EnumColumnAccess) {
                columnAccessString = columnAccessString.substring(0, columnAccessString.lastIndexOf(".name()"));
            } else if (this.columnAccess instanceof BooleanTypeColumnAccess) {
                columnAccessString = columnAccessString.substring(0, columnAccessString.lastIndexOf(" ? 1 : 0"));
            }
            codeBuilder.add(columnAccessString, new Object[0]);
        }
        codeBuilder.add("));", new Object[0]);
    }

    public String getReferenceColumnName(ForeignKeyReference reference) {
        return (this.columnName + "_" + reference.columnName()).toUpperCase();
    }

    public CodeBlock getCreationName() {
        CodeBlock.Builder codeBlockBuilder = DefinitionUtils.getCreationStatement(this.elementTypeName, this.columnAccess, this.columnName);
        if (this.isPrimaryKeyAutoIncrement && !this.isRowId) {
            codeBlockBuilder.add(" PRIMARY KEY ", new Object[0]);
            if (this.tableDefinition instanceof TableDefinition && !StringUtils.isNullOrEmpty(((TableDefinition)this.tableDefinition).primaryKeyConflictActionName)) {
                codeBlockBuilder.add("ON CONFLICT $L ", new Object[]{((TableDefinition)this.tableDefinition).primaryKeyConflictActionName});
            }
            codeBlockBuilder.add("AUTOINCREMENT", new Object[0]);
        }
        if (this.length > -1) {
            codeBlockBuilder.add("($L)", new Object[]{this.length});
        }
        if (!this.collate.equals((Object)Collate.NONE)) {
            codeBlockBuilder.add(" COLLATE $L", new Object[]{this.collate});
        }
        if (this.unique) {
            codeBlockBuilder.add(" UNIQUE ON CONFLICT $L", new Object[]{this.onUniqueConflict});
        }
        if (this.notNull) {
            codeBlockBuilder.add(" NOT NULL", new Object[0]);
        }
        return codeBlockBuilder.build();
    }

    public String getPrimaryKeyName() {
        return QueryBuilder.quote((String)this.columnName);
    }

    public CodeBlock getForeignKeyContainerMethod(ClassName tableClassName) {
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("$L.put($T.$L, $L)", new Object[]{ModelUtils.getVariable(true), tableClassName, this.columnName, this.columnAccess.getColumnAccessString(this.elementTypeName, this.containerKeyName, this.elementName, ModelUtils.getVariable(false), false, false)});
        return codeBuilder.build();
    }

    public boolean isPrimaryKeyAutoIncrement() {
        return this.isPrimaryKeyAutoIncrement;
    }
}

