/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.ConflictAction;
import com.raizlabs.android.dbflow.annotation.UniqueGroup;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyReferenceDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.List;

public class UniqueGroupsDefinition {
    private final ProcessorManager manager;
    public List<ColumnDefinition> columnDefinitionList = new ArrayList<ColumnDefinition>();
    public int number;
    private ConflictAction uniqueConflict;

    public UniqueGroupsDefinition(ProcessorManager manager, UniqueGroup uniqueGroup) {
        this.manager = manager;
        this.number = uniqueGroup.groupNumber();
        this.uniqueConflict = uniqueGroup.uniqueConflict();
    }

    public void addColumnDefinition(ColumnDefinition columnDefinition) {
        this.columnDefinitionList.add(columnDefinition);
    }

    public CodeBlock getCreationName() {
        CodeBlock.Builder codeBuilder = CodeBlock.builder().add(", UNIQUE(", new Object[0]);
        int count = 0;
        for (ColumnDefinition columnDefinition : this.columnDefinitionList) {
            if (count > 0) {
                codeBuilder.add(",", new Object[0]);
            }
            if (columnDefinition instanceof ForeignKeyColumnDefinition) {
                for (ForeignKeyReferenceDefinition reference : ((ForeignKeyColumnDefinition)columnDefinition).getForeignKeyReferenceDefinitionList()) {
                    codeBuilder.add(QueryBuilder.quote((String)reference.columnName), new Object[0]);
                }
            } else {
                codeBuilder.add(QueryBuilder.quote((String)columnDefinition.columnName), new Object[0]);
            }
            ++count;
        }
        codeBuilder.add(") ON CONFLICT $L", new Object[]{this.uniqueConflict});
        return codeBuilder.build();
    }
}

