/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.raizlabs.android.dbflow.annotation.provider.ContentUri;
import com.raizlabs.android.dbflow.annotation.provider.Notify;
import com.raizlabs.android.dbflow.annotation.provider.TableEndpoint;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.ContentUriDefinition;
import com.raizlabs.android.dbflow.processor.definition.NotifyDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.TypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class TableEndpointDefinition
extends BaseDefinition {
    public List<ContentUriDefinition> contentUriDefinitions = Lists.newArrayList();
    Map<String, ContentUriDefinition> pathValidationMap = Maps.newHashMap();
    public Map<String, Map<Notify.Method, List<NotifyDefinition>>> notifyDefinitionPathMap = Maps.newHashMap();
    public String tableName;
    public TypeName contentProviderName;
    public boolean isTopLevel = false;

    public TableEndpointDefinition(Element typeElement, ProcessorManager processorManager) {
        super(typeElement, processorManager);
        TableEndpoint endpoint = typeElement.getAnnotation(TableEndpoint.class);
        if (endpoint != null) {
            this.tableName = endpoint.name();
            try {
                endpoint.contentProvider();
            }
            catch (MirroredTypeException mte) {
                this.contentProviderName = TypeName.get((TypeMirror)mte.getTypeMirror());
            }
        }
        this.isTopLevel = typeElement.getEnclosingElement() instanceof PackageElement;
        List<? extends Element> elements = processorManager.getElements().getAllMembers((TypeElement)typeElement);
        for (Element element : elements) {
            if (element.getAnnotation(ContentUri.class) != null) {
                ContentUriDefinition contentUriDefinition = new ContentUriDefinition(element, processorManager);
                if (!this.pathValidationMap.containsKey(contentUriDefinition.path)) {
                    this.contentUriDefinitions.add(contentUriDefinition);
                    continue;
                }
                processorManager.logError("There must be unique paths for the specified @ContentUri %1s from %1s", contentUriDefinition.name, this.contentProviderName);
                continue;
            }
            if (element.getAnnotation(Notify.class) == null) continue;
            NotifyDefinition notifyDefinition = new NotifyDefinition(element, processorManager);
            for (String path : notifyDefinition.paths) {
                List notifyDefinitionList;
                HashMap methodListMap = this.notifyDefinitionPathMap.get(path);
                if (methodListMap == null) {
                    methodListMap = Maps.newHashMap();
                    this.notifyDefinitionPathMap.put(path, methodListMap);
                }
                if ((notifyDefinitionList = (List)methodListMap.get(notifyDefinition.method)) == null) {
                    notifyDefinitionList = Lists.newArrayList();
                    methodListMap.put(notifyDefinition.method, notifyDefinitionList);
                }
                notifyDefinitionList.add(notifyDefinition);
            }
        }
    }
}

