/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.Migration;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class MigrationDefinition
extends BaseDefinition {
    public TypeName databaseName;
    public Integer version;
    public int priority = -1;
    private String constructorName;

    public MigrationDefinition(ProcessorManager processorManager, TypeElement typeElement) {
        super(typeElement, processorManager);
        this.setOutputClassName("");
        Migration migration = typeElement.getAnnotation(Migration.class);
        if (migration == null) {
            processorManager.logError("Migration was null for:" + typeElement, new Object[0]);
        } else {
            try {
                migration.database();
            }
            catch (MirroredTypeException mte) {
                this.databaseName = TypeName.get((TypeMirror)mte.getTypeMirror());
            }
            this.version = migration.version();
            this.priority = migration.priority();
            List<? extends Element> elements = typeElement.getEnclosedElements();
            for (Element element : elements) {
                if (!(element instanceof ExecutableElement) || !element.getSimpleName().toString().equals("<init>")) continue;
                if (!StringUtils.isNullOrEmpty(this.constructorName)) {
                    this.manager.logError(MigrationDefinition.class, "Migrations cannot have more than one constructor. They can only have an Empty() or single-parameter constructor Empty(Empty.class) that specifies the .class of this migration class.", new Object[0]);
                }
                if (((ExecutableElement)element).getParameters().isEmpty()) {
                    this.constructorName = "()";
                    continue;
                }
                if (((ExecutableElement)element).getParameters().size() != 1) continue;
                List<? extends VariableElement> params = ((ExecutableElement)element).getParameters();
                Element param = params.get(0);
                TypeName type = TypeName.get((TypeMirror)param.asType());
                if (type instanceof ParameterizedTypeName && ((ParameterizedTypeName)type).rawType.equals((Object)ClassName.get(Class.class))) {
                    TypeName containedType = (TypeName)((ParameterizedTypeName)type).typeArguments.get(0);
                    this.constructorName = CodeBlock.builder().add("($T.class)", new Object[]{containedType}).build().toString();
                    continue;
                }
                this.manager.logError(MigrationDefinition.class, "Wrong parameter type found for %1s. Found %1sbut required ModelClass.class", typeElement, type);
            }
        }
    }

    public String getConstructorName() {
        return this.constructorName;
    }
}

