/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.DefinitionUtils;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;

public class InternalAdapterHelper {
    public static void writeGetModelClass(TypeSpec.Builder typeBuilder, ClassName modelClassName) {
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getModelClass").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $T.class", new Object[]{modelClassName}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{modelClassName})).build());
    }

    public static void writeGetTableName(TypeSpec.Builder typeBuilder, String tableName) {
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getTableName").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $S", new Object[]{QueryBuilder.quote((String)tableName)}).returns((TypeName)ClassName.get(String.class)).build());
    }

    public static void writeUpdateAutoIncrement(TypeSpec.Builder typeBuilder, TypeName modelClassName, ColumnDefinition autoIncrementDefinition, boolean isModelContainer) {
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"updateAutoIncrement").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(modelClassName, ModelUtils.getVariable(isModelContainer), new Modifier[0]).addParameter((TypeName)ClassName.get(Number.class), "id", new Modifier[0]).addCode(autoIncrementDefinition.getUpdateAutoIncrementMethod(isModelContainer)).build());
    }

    public static void writeGetCachingId(TypeSpec.Builder typeBuilder, TypeName modelClassName, List<ColumnDefinition> primaryColumns, boolean isModelContainer) {
        if (primaryColumns.size() > 1) {
            ColumnDefinition column;
            int i;
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getCachingColumnValuesFromModel").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ArrayTypeName.of(Object.class), "inValues", new Modifier[0]).addParameter(modelClassName, ModelUtils.getVariable(isModelContainer), new Modifier[0]);
            for (i = 0; i < primaryColumns.size(); ++i) {
                column = primaryColumns.get(i);
                methodBuilder.addStatement("inValues[$L] = $L", new Object[]{i, column.getColumnAccessString(isModelContainer, false)});
            }
            methodBuilder.addStatement("return $L", new Object[]{"inValues"}).returns((TypeName)ArrayTypeName.of(Object.class));
            typeBuilder.addMethod(methodBuilder.build());
            methodBuilder = MethodSpec.methodBuilder((String)"getCachingColumnValuesFromCursor").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ArrayTypeName.of(Object.class), "inValues", new Modifier[0]).addParameter((TypeName)ClassNames.CURSOR, "cursor", new Modifier[0]);
            for (i = 0; i < primaryColumns.size(); ++i) {
                column = primaryColumns.get(i);
                String method = DefinitionUtils.getLoadFromCursorMethodString(column.elementTypeName, column.columnAccess);
                methodBuilder.addStatement("inValues[$L] = $L.$L($L.getColumnIndex($S))", new Object[]{i, "cursor", method, "cursor", column.columnName});
            }
            methodBuilder.addStatement("return $L", new Object[]{"inValues"}).returns((TypeName)ArrayTypeName.of(Object.class));
            typeBuilder.addMethod(methodBuilder.build());
        } else {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getCachingColumnValueFromModel").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(modelClassName, ModelUtils.getVariable(isModelContainer), new Modifier[0]);
            methodBuilder.addStatement("return $L", new Object[]{primaryColumns.get(0).getColumnAccessString(isModelContainer, false)}).returns(Object.class);
            typeBuilder.addMethod(methodBuilder.build());
            methodBuilder = MethodSpec.methodBuilder((String)"getCachingColumnValueFromCursor").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)ClassNames.CURSOR, "cursor", new Modifier[0]);
            ColumnDefinition column = primaryColumns.get(0);
            String method = DefinitionUtils.getLoadFromCursorMethodString(column.elementTypeName, column.columnAccess);
            methodBuilder.addStatement("return $L.$L($L.getColumnIndex($S))", new Object[]{"cursor", method, "cursor", column.columnName}).returns(Object.class);
            typeBuilder.addMethod(methodBuilder.build());
            methodBuilder = MethodSpec.methodBuilder((String)"getCachingId").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(modelClassName, ModelUtils.getVariable(isModelContainer), new Modifier[0]).addStatement("return getCachingColumnValueFromModel($L)", new Object[]{ModelUtils.getVariable(isModelContainer)}).returns((TypeName)TypeName.OBJECT);
            typeBuilder.addMethod(methodBuilder.build());
        }
    }
}

