/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.IndexGroup;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

public class IndexGroupsDefinition {
    private ProcessorManager manager;
    private TableDefinition tableDefinition;
    public final String indexName;
    public final int indexNumber;
    public final boolean isUnique;
    public final List<ColumnDefinition> columnDefinitionList = new ArrayList<ColumnDefinition>();

    public IndexGroupsDefinition(ProcessorManager manager, TableDefinition tableDefinition, IndexGroup indexGroup) {
        this.manager = manager;
        this.tableDefinition = tableDefinition;
        this.indexName = indexGroup.name();
        this.indexNumber = indexGroup.number();
        this.isUnique = indexGroup.unique();
    }

    public FieldSpec getFieldSpec() {
        FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.INDEX_PROPERTY, (TypeName[])new TypeName[]{this.tableDefinition.elementClassName}), (String)("index_" + this.indexName), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder initializer = CodeBlock.builder().add("new $T<>($S, $L, $T.class", new Object[]{ClassNames.INDEX_PROPERTY, this.indexName, this.isUnique, this.tableDefinition.elementTypeName});
        for (ColumnDefinition columnDefinition : this.columnDefinitionList) {
            initializer.add(", $L", new Object[]{columnDefinition.columnName});
        }
        initializer.add(")", new Object[0]);
        fieldBuilder.initializer(initializer.build());
        return fieldBuilder.build();
    }
}

