/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.raizlabs.android.dbflow.annotation.provider.ContentUri;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.squareup.javapoet.ClassName;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class ContentUriDefinition
extends BaseDefinition {
    public String name;
    public String classQualifiedName;
    public String path;
    public String type;
    public boolean queryEnabled;
    public boolean insertEnabled;
    public boolean deleteEnabled;
    public boolean updateEnabled;
    public ContentUri.PathSegment[] segments;

    public ContentUriDefinition(Element typeElement, ProcessorManager processorManager) {
        super(typeElement, processorManager);
        ContentUri contentUri = typeElement.getAnnotation(ContentUri.class);
        this.path = contentUri.path();
        this.type = contentUri.type();
        this.name = typeElement.getEnclosingElement().getSimpleName().toString() + "_" + typeElement.getSimpleName().toString();
        this.queryEnabled = contentUri.queryEnabled();
        this.insertEnabled = contentUri.insertEnabled();
        this.deleteEnabled = contentUri.deleteEnabled();
        this.updateEnabled = contentUri.updateEnabled();
        this.segments = contentUri.segments();
        if (typeElement instanceof VariableElement) {
            if (!ClassNames.URI.equals((Object)this.elementTypeName)) {
                processorManager.logError("Content Uri field returned wrong type. It must return a Uri", new Object[0]);
            }
        } else if (typeElement instanceof ExecutableElement && !ClassNames.URI.equals((Object)this.elementTypeName)) {
            processorManager.logError("ContentUri method returns wrong type. It must return Uri", new Object[0]);
        }
    }

    @Override
    protected ClassName getElementClassName(Element element) {
        return null;
    }
}

