/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.google.common.collect.Lists;
import com.raizlabs.android.dbflow.annotation.provider.ContentProvider;
import com.raizlabs.android.dbflow.annotation.provider.TableEndpoint;
import com.raizlabs.android.dbflow.processor.ClassNames;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.ContentUriDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableEndpointDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.DatabaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.MethodDefinition;
import com.raizlabs.android.dbflow.processor.definition.method.provider.DeleteMethod;
import com.raizlabs.android.dbflow.processor.definition.method.provider.InsertMethod;
import com.raizlabs.android.dbflow.processor.definition.method.provider.QueryMethod;
import com.raizlabs.android.dbflow.processor.definition.method.provider.UpdateMethod;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.validator.TableEndpointValidator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class ContentProviderDefinition
extends BaseDefinition {
    static final String DEFINITION_NAME = "Provider";
    static final String DATABASE_FIELD = "database";
    public static final String URI_MATCHER = "MATCHER";
    private static final String AUTHORITY = "AUTHORITY";
    public TypeName databaseName;
    public String databaseNameString;
    public String authority;
    public List<TableEndpointDefinition> endpointDefinitions = Lists.newArrayList();
    private MethodDefinition[] methods;

    public ContentProviderDefinition(Element typeElement, ProcessorManager processorManager) {
        super(typeElement, processorManager);
        ContentProvider provider = this.element.getAnnotation(ContentProvider.class);
        if (provider != null) {
            try {
                provider.database();
            }
            catch (MirroredTypeException mte) {
                this.databaseName = TypeName.get((TypeMirror)mte.getTypeMirror());
            }
            this.authority = provider.authority();
            TableEndpointValidator validator = new TableEndpointValidator();
            List<? extends Element> elements = this.manager.getElements().getAllMembers((TypeElement)typeElement);
            for (Element element : elements) {
                TableEndpointDefinition endpointDefinition;
                if (element.getAnnotation(TableEndpoint.class) == null || !validator.validate(processorManager, endpointDefinition = new TableEndpointDefinition(element, this.manager))) continue;
                this.endpointDefinitions.add(endpointDefinition);
            }
        }
        this.methods = new MethodDefinition[]{new QueryMethod(this, this.manager), new InsertMethod(this, false), new InsertMethod(this, true), new DeleteMethod(this, this.manager), new UpdateMethod(this, this.manager)};
    }

    @Override
    protected TypeName getExtendsClass() {
        return ClassNames.BASE_CONTENT_PROVIDER;
    }

    public void prepareForWrite() {
        DatabaseDefinition databaseDefinition = this.manager.getDatabaseHolderDefinition(this.databaseName).getDatabaseDefinition();
        this.databaseNameString = databaseDefinition.databaseName;
        this.setOutputClassName(databaseDefinition.classSeparator + DEFINITION_NAME);
    }

    @Override
    public void onWriteDefinition(TypeSpec.Builder typeBuilder) {
        typeBuilder.addField(FieldSpec.builder((TypeName)ClassName.get(String.class), (String)AUTHORITY, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.authority}).build());
        int code = 0;
        for (TableEndpointDefinition endpointDefinition : this.endpointDefinitions) {
            for (ContentUriDefinition contentUriDefinition : endpointDefinition.contentUriDefinitions) {
                typeBuilder.addField(FieldSpec.builder((TypeName)TypeName.INT, (String)contentUriDefinition.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(String.valueOf(code), new Object[0]).build());
                ++code;
            }
        }
        FieldSpec.Builder uriField = FieldSpec.builder((TypeName)ClassNames.URI_MATCHER, (String)URI_MATCHER, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder initializer = CodeBlock.builder().addStatement("new $T($T.NO_MATCH)", new Object[]{ClassNames.URI_MATCHER, ClassNames.URI_MATCHER}).add("static {\n", new Object[0]);
        for (TableEndpointDefinition endpointDefinition : this.endpointDefinitions) {
            for (ContentUriDefinition contentUriDefinition : endpointDefinition.contentUriDefinitions) {
                String path = contentUriDefinition.path != null ? "\"" + contentUriDefinition.path + "\"" : CodeBlock.builder().add("$L.$L.getPath()", new Object[]{contentUriDefinition.elementClassName, contentUriDefinition.name}).build().toString();
                initializer.addStatement("$L.addURI($L, $L, $L)", new Object[]{URI_MATCHER, AUTHORITY, path, contentUriDefinition.name});
            }
        }
        initializer.add("}\n", new Object[0]);
        typeBuilder.addField(uriField.initializer(initializer.build()).build());
        typeBuilder.addMethod(MethodSpec.methodBuilder((String)"getDatabaseName").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return $S", new Object[]{this.databaseNameString}).returns((TypeName)ClassName.get(String.class)).build());
        MethodSpec.Builder getTypeBuilder = MethodSpec.methodBuilder((String)"getType").addAnnotation(Override.class).addParameter((TypeName)ClassNames.URI, "uri", new Modifier[0]).returns((TypeName)ClassName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        CodeBlock.Builder getTypeCode = CodeBlock.builder().addStatement("$T type = null", new Object[]{ClassName.get(String.class)}).beginControlFlow("switch($L.match(uri))", new Object[]{URI_MATCHER});
        for (TableEndpointDefinition tableEndpointDefinition : this.endpointDefinitions) {
            for (ContentUriDefinition contentUriDefinition : tableEndpointDefinition.contentUriDefinitions) {
                getTypeCode.beginControlFlow("case $L:", new Object[]{contentUriDefinition.name}).addStatement("type = $S", new Object[]{contentUriDefinition.type}).addStatement("break", new Object[0]).endControlFlow();
            }
        }
        getTypeCode.beginControlFlow("default:", new Object[0]).addStatement("throw new $T($S + $L)", new Object[]{ClassName.get(IllegalArgumentException.class), "Unknown URI", "uri"}).endControlFlow();
        getTypeCode.endControlFlow();
        getTypeCode.addStatement("return type", new Object[0]);
        getTypeBuilder.addCode(getTypeCode.build());
        typeBuilder.addMethod(getTypeBuilder.build());
        for (Iterator<BaseDefinition> iterator : this.methods) {
            MethodSpec methodSpec = iterator.getMethodSpec();
            if (methodSpec == null) continue;
            typeBuilder.addMethod(methodSpec);
        }
    }
}

