/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.processor.definition;

import com.google.common.collect.Lists;
import com.raizlabs.android.dbflow.processor.definition.BaseDefinition;
import com.raizlabs.android.dbflow.processor.definition.TableDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.ForeignKeyColumnDefinition;
import com.raizlabs.android.dbflow.processor.definition.column.PackagePrivateAccess;
import com.raizlabs.android.dbflow.processor.definition.method.DatabaseDefinition;
import com.raizlabs.android.dbflow.processor.model.ProcessorManager;
import com.raizlabs.android.dbflow.processor.utils.ElementUtility;
import com.raizlabs.android.dbflow.processor.utils.ModelUtils;
import com.raizlabs.android.dbflow.processor.utils.StringUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public abstract class BaseTableDefinition
extends BaseDefinition {
    protected List<ColumnDefinition> columnDefinitions;
    protected Map<ClassName, List<ColumnDefinition>> associatedTypeConverters = new HashMap<ClassName, List<ColumnDefinition>>();
    protected Map<ClassName, List<ColumnDefinition>> globalTypeConverters = new HashMap<ClassName, List<ColumnDefinition>>();
    protected final List<ColumnDefinition> packagePrivateList = Lists.newArrayList();
    public boolean orderedCursorLookUp;
    public boolean assignDefaultValuesFromCursor = true;
    public Map<String, Element> classElementLookUpMap = new HashMap<String, Element>();
    private String modelClassName;
    public DatabaseDefinition databaseDefinition;

    public BaseTableDefinition(Element typeElement, ProcessorManager processorManager) {
        super(typeElement, processorManager);
        this.modelClassName = typeElement.getSimpleName().toString();
        this.columnDefinitions = new ArrayList<ColumnDefinition>();
    }

    protected abstract void createColumnDefinitions(TypeElement var1);

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public abstract List<ColumnDefinition> getPrimaryColumnDefinitions();

    public abstract ClassName getPropertyClassName();

    public abstract void prepareForWrite();

    public TypeName getParameterClassName(boolean isModelContainerAdapter) {
        return isModelContainerAdapter ? ModelUtils.getModelContainerType(this.manager, (TypeName)this.elementClassName) : this.elementClassName;
    }

    public String addColumnForCustomTypeConverter(ColumnDefinition columnDefinition, ClassName typeConverterName) {
        List<ColumnDefinition> columnDefinitions = this.associatedTypeConverters.get(typeConverterName);
        if (columnDefinitions == null) {
            columnDefinitions = new ArrayList<ColumnDefinition>();
            this.associatedTypeConverters.put(typeConverterName, columnDefinitions);
        }
        columnDefinitions.add(columnDefinition);
        return "typeConverter" + typeConverterName.simpleName();
    }

    public String addColumnForTypeConverter(ColumnDefinition columnDefinition, ClassName typeConverterName) {
        List<ColumnDefinition> columnDefinitions = this.globalTypeConverters.get(typeConverterName);
        if (columnDefinitions == null) {
            columnDefinitions = new ArrayList<ColumnDefinition>();
            this.globalTypeConverters.put(typeConverterName, columnDefinitions);
        }
        columnDefinitions.add(columnDefinition);
        return "global_typeConverter" + typeConverterName.simpleName();
    }

    public void writePackageHelper(ProcessingEnvironment processingEnvironment) throws IOException {
        int count = 0;
        if (!this.packagePrivateList.isEmpty()) {
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)(this.elementClassName.simpleName() + this.databaseDefinition.classSeparator + "Helper")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            for (ColumnDefinition columnDefinition : this.packagePrivateList) {
                ClassName className;
                TableDefinition tableDefinition;
                String helperClassName = this.manager.getElements().getPackageOf(columnDefinition.element).toString() + "." + ClassName.get((TypeElement)((TypeElement)columnDefinition.element.getEnclosingElement())).simpleName() + this.databaseDefinition.classSeparator + "Helper";
                if (columnDefinition instanceof ForeignKeyColumnDefinition && (tableDefinition = this.databaseDefinition.getHolderDefinition().tableDefinitionMap.get(((ForeignKeyColumnDefinition)columnDefinition).referencedTableClassName)) != null) {
                    helperClassName = this.manager.getElements().getPackageOf(tableDefinition.element).toString() + "." + ClassName.get((TypeElement)((TypeElement)tableDefinition.element)).simpleName() + this.databaseDefinition.classSeparator + "Helper";
                }
                if (!PackagePrivateAccess.containsColumn(className = ClassName.bestGuess((String)helperClassName), columnDefinition.columnName)) continue;
                MethodSpec.Builder method = MethodSpec.methodBuilder((String)("get" + StringUtils.capitalize(columnDefinition.columnName))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addParameter(this.elementTypeName, ModelUtils.getVariable(false), new Modifier[0]).returns(columnDefinition.elementTypeName);
                boolean samePackage = ElementUtility.isInSamePackage(this.manager, columnDefinition.element, this.element);
                if (samePackage) {
                    method.addStatement("return $L.$L", new Object[]{ModelUtils.getVariable(false), columnDefinition.elementName});
                } else {
                    method.addStatement("return $T.get$L($L)", new Object[]{className, StringUtils.capitalize(columnDefinition.columnName), ModelUtils.getVariable(false)});
                }
                typeBuilder.addMethod(method.build());
                method = MethodSpec.methodBuilder((String)("set" + StringUtils.capitalize(columnDefinition.columnName))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addParameter(this.elementTypeName, ModelUtils.getVariable(false), new Modifier[0]).addParameter(columnDefinition.elementTypeName, "var", new Modifier[0]);
                if (samePackage) {
                    method.addStatement("$L.$L = $L", new Object[]{ModelUtils.getVariable(false), columnDefinition.elementName, "var"});
                } else {
                    method.addStatement("$T.set$L($L, $L)", new Object[]{className, StringUtils.capitalize(columnDefinition.columnName), ModelUtils.getVariable(false), "var"});
                }
                typeBuilder.addMethod(method.build());
                ++count;
            }
            if (count > 0) {
                JavaFile.Builder javaFileBuilder = JavaFile.builder((String)this.packageName, (TypeSpec)typeBuilder.build());
                javaFileBuilder.build().writeTo(processingEnvironment.getFiler());
            }
        }
    }

    public Map<ClassName, List<ColumnDefinition>> getAssociatedTypeConverters() {
        return this.associatedTypeConverters;
    }

    public Map<ClassName, List<ColumnDefinition>> getGlobalTypeConverters() {
        return this.globalTypeConverters;
    }

    public boolean hasAutoIncrement() {
        return false;
    }

    public boolean hasRowID() {
        return false;
    }

    public ColumnDefinition getAutoIncrementColumn() {
        return null;
    }

    public String getModelClassName() {
        return this.modelClassName;
    }
}

