/*
 * Decompiled with CFR 0.152.
 */
package com.owen.tab;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.owen.tab.AnimationUtils;
import com.owen.tab.MathUtils;
import com.owen.tab.ValueAnimatorCompat;

class ValueAnimatorCompatImplEclairMr1
extends ValueAnimatorCompat.Impl {
    private static final int HANDLER_DELAY = 10;
    private static final int DEFAULT_DURATION = 200;
    private static final Handler sHandler = new Handler(Looper.getMainLooper());
    private long mStartTime;
    private boolean mIsRunning;
    private final int[] mIntValues = new int[2];
    private final float[] mFloatValues = new float[2];
    private long mDuration = 200L;
    private Interpolator mInterpolator;
    private ValueAnimatorCompat.Impl.AnimatorListenerProxy mListener;
    private ValueAnimatorCompat.Impl.AnimatorUpdateListenerProxy mUpdateListener;
    private float mAnimatedFraction;
    private long mStartDelay = 0L;
    private final Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            ValueAnimatorCompatImplEclairMr1.this.update();
        }
    };

    ValueAnimatorCompatImplEclairMr1() {
    }

    @Override
    public void start() {
        if (this.mIsRunning) {
            return;
        }
        if (this.mInterpolator == null) {
            this.mInterpolator = new AccelerateDecelerateInterpolator();
        }
        this.mStartTime = SystemClock.uptimeMillis();
        this.mIsRunning = true;
        this.mAnimatedFraction = 0.0f;
        if (this.mListener != null) {
            this.mListener.onAnimationStart();
        }
        sHandler.postDelayed(this.mRunnable, 10L + this.mStartDelay);
    }

    @Override
    public boolean isRunning() {
        return this.mIsRunning;
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    @Override
    public void setListener(ValueAnimatorCompat.Impl.AnimatorListenerProxy listener) {
        this.mListener = listener;
    }

    @Override
    public void setUpdateListener(ValueAnimatorCompat.Impl.AnimatorUpdateListenerProxy updateListener) {
        this.mUpdateListener = updateListener;
    }

    @Override
    public void setIntValues(int from, int to) {
        this.mIntValues[0] = from;
        this.mIntValues[1] = to;
    }

    @Override
    public int getAnimatedIntValue() {
        return AnimationUtils.lerp(this.mIntValues[0], this.mIntValues[1], this.getAnimatedFraction());
    }

    @Override
    public void setFloatValues(float from, float to) {
        this.mFloatValues[0] = from;
        this.mFloatValues[1] = to;
    }

    @Override
    public float getAnimatedFloatValue() {
        return AnimationUtils.lerp(this.mFloatValues[0], this.mFloatValues[1], this.getAnimatedFraction());
    }

    @Override
    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    @Override
    public void cancel() {
        this.mIsRunning = false;
        sHandler.removeCallbacks(this.mRunnable);
        if (this.mListener != null) {
            this.mListener.onAnimationCancel();
            this.mListener.onAnimationEnd();
        }
    }

    @Override
    public float getAnimatedFraction() {
        return this.mAnimatedFraction;
    }

    @Override
    public void end() {
        if (this.mIsRunning) {
            this.mIsRunning = false;
            sHandler.removeCallbacks(this.mRunnable);
            this.mAnimatedFraction = 1.0f;
            if (this.mUpdateListener != null) {
                this.mUpdateListener.onAnimationUpdate();
            }
            if (this.mListener != null) {
                this.mListener.onAnimationEnd();
            }
        }
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    void setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
    }

    private void update() {
        if (this.mIsRunning) {
            long elapsed = SystemClock.uptimeMillis() - this.mStartTime;
            float linearFraction = MathUtils.constrain((float)elapsed / (float)this.mDuration, 0.0f, 1.0f);
            float f = this.mAnimatedFraction = this.mInterpolator != null ? this.mInterpolator.getInterpolation(linearFraction) : linearFraction;
            if (this.mUpdateListener != null) {
                this.mUpdateListener.onAnimationUpdate();
            }
            if (SystemClock.uptimeMillis() >= this.mStartTime + this.mDuration) {
                this.mIsRunning = false;
                if (this.mListener != null) {
                    this.mListener.onAnimationEnd();
                }
            }
        }
        if (this.mIsRunning) {
            sHandler.postDelayed(this.mRunnable, 10L);
        }
    }
}

