/*
 * Decompiled with CFR 0.152.
 */
package com.owen.tab;

import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewPropertyAnimator;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.util.Pools;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.owen.tab.AnimationUtils;
import com.owen.tab.R;
import com.owen.tab.TabItem;
import com.owen.tab.ValueAnimatorCompat;
import com.owen.tab.ViewUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class TvTabLayout
extends HorizontalScrollView {
    private static final int DEFAULT_HEIGHT_WITH_TEXT_ICON = 72;
    private static final int DEFAULT_GAP_TEXT_ICON = 8;
    private static final int INVALID_WIDTH = -1;
    private static final int DEFAULT_HEIGHT = 48;
    private static final int TAB_MIN_WIDTH_MARGIN = 56;
    private static final int FIXED_WRAP_GUTTER_MIN = 16;
    private static final int MOTION_NON_ADJACENT_OFFSET = 24;
    private static final int ANIMATION_DURATION = 300;
    private boolean mTabTextSelectedCentered;
    private float mTabTextSelectedScaleValue;
    private static final Pools.Pool<Tab> sTabPool = new Pools.SynchronizedPool(16);
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    public static final int GRAVITY_FILL = 3;
    public static final int GRAVITY_TOP = 0;
    public static final int GRAVITY_CENTER = 1;
    public static final int GRAVITY_BOTTOM = 2;
    private final ArrayList<Tab> mTabs = new ArrayList();
    private Tab mSelectedTab;
    protected final SlidingTabStrip mTabStrip;
    private int mTabPaddingStart;
    private int mTabPaddingTop;
    private int mTabPaddingEnd;
    private int mTabPaddingBottom;
    private ColorStateList mTabTextColors;
    private float mTabTextSize;
    private float mTabTextMultiLineSize;
    private final int mTabBackgroundResId;
    private int mTabMaxWidth = 0x3FFFFFFF;
    private final int mRequestedTabMinWidth;
    private final int mRequestedTabMaxWidth;
    private final int mScrollableTabMinWidth;
    private int mContentInsetStart;
    private int mContentInsetBottom;
    private int mScrollMode;
    private int mIndicatorGravity;
    private int mTabGravity;
    private OnTabSelectedListener mSelectedListener;
    private final ArrayList<OnTabSelectedListener> mSelectedListeners = new ArrayList();
    private OnTabSelectedListener mCurrentVpSelectedListener;
    private ValueAnimatorCompat mScrollAnimator;
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    private DataSetObserver mPagerAdapterObserver;
    private ViewPager.OnPageChangeListener mPageChangeListener;
    private AdapterChangeListener mAdapterChangeListener;
    private boolean mSetupViewPagerImplicitly;
    private final Pools.Pool<TabView> mTabViewPool = new Pools.SimplePool(12);

    public TvTabLayout(Context context) {
        this(context, null);
    }

    public TvTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TvTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHorizontalScrollBarEnabled(false);
        this.setDescendantFocusability(393216);
        this.setWillNotDraw(true);
        this.setClickable(false);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mTabStrip = new SlidingTabStrip(context);
        super.addView((View)this.mTabStrip, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TvTabLayout, defStyleAttr, 0);
        Drawable mStateListDrawable = a.getDrawable(R.styleable.TvTabLayout_tabIndicatorResId);
        if (null != mStateListDrawable) {
            mStateListDrawable.setCallback((Drawable.Callback)this);
            this.mTabStrip.setIndicatorDrawable(mStateListDrawable);
        }
        this.mIndicatorGravity = a.getInt(R.styleable.TvTabLayout_tabIndicatorGravityVal, 2);
        this.mTabStrip.setCircleDotRadius(a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabCircleDotRadius, 0));
        this.mTabStrip.setCircleDotColor(a.getColor(R.styleable.TvTabLayout_tabCircleDotColor, 0));
        this.mTabStrip.setIndicatorWidth(a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabIndicatorWidth, 0));
        this.mTabStrip.setIndicatorHeight(a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabIndicatorHeight, 0));
        this.mTabStrip.setIndicatorBackgroundColor(a.getColor(R.styleable.TvTabLayout_tabIndicatorBackgroundColor, 0));
        this.mTabStrip.setIndicatorBackgroundHeight(a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabIndicatorBackgroundHeight, 0));
        this.mTabPaddingEnd = this.mTabPaddingBottom = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabPadding, 0);
        this.mTabPaddingTop = this.mTabPaddingBottom;
        this.mTabPaddingStart = this.mTabPaddingBottom;
        this.mTabPaddingStart = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabPaddingStart, this.mTabPaddingStart);
        this.mTabPaddingTop = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabPaddingTop, this.mTabPaddingTop);
        this.mTabPaddingEnd = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabPaddingEnd, this.mTabPaddingEnd);
        this.mTabPaddingBottom = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabPaddingBottom, this.mTabPaddingBottom);
        this.mTabTextSize = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabTexSize, this.getResources().getDimensionPixelOffset(R.dimen.tablayout_tab_text_size));
        this.mTabTextColors = a.getColorStateList(R.styleable.TvTabLayout_tabTextColor);
        this.mRequestedTabMinWidth = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabMinWidth, -1);
        this.mRequestedTabMaxWidth = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabMaxWidth, -1);
        this.mTabBackgroundResId = a.getResourceId(R.styleable.TvTabLayout_tabBackground, 0);
        this.mContentInsetStart = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabContentStart, 0);
        this.mContentInsetBottom = a.getDimensionPixelOffset(R.styleable.TvTabLayout_tabContentBottom, 0);
        this.mScrollMode = a.getInt(R.styleable.TvTabLayout_tabScrollMode, 1);
        this.mTabTextSelectedCentered = a.getBoolean(R.styleable.TvTabLayout_tabTextSelectedCentered, false);
        this.mTabTextSelectedScaleValue = a.getFloat(R.styleable.TvTabLayout_tabTextSelectedScale, 0.0f);
        a.recycle();
        Resources res = this.getResources();
        this.mTabTextMultiLineSize = res.getDimensionPixelOffset(R.dimen.tablayout_tab_text_size_2line);
        this.mScrollableTabMinWidth = res.getDimensionPixelOffset(R.dimen.tablayout_tab_scrollable_min_width);
        this.applyModeAndGravity();
    }

    public void setTabTextSelectedCentered(boolean tabTextSelectedCentered) {
        this.mTabTextSelectedCentered = tabTextSelectedCentered;
    }

    public void setTabTextSelectedScaleValue(float tabTextSelectedScaleValue) {
        this.mTabTextSelectedScaleValue = tabTextSelectedScaleValue;
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        View selectedView;
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (null != this.mSelectedTab && null != (selectedView = this.mSelectedTab.getView())) {
            selectedView.setActivated(!gainFocus);
            selectedView.setSelected(gainFocus);
        }
        this.mTabStrip.invalidate();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (event.getKeyCode() == 21) {
                    return this.selectTab(this.getSelectedTabPosition() - 1);
                }
                if (event.getKeyCode() != 22) break;
                return this.selectTab(this.getSelectedTabPosition() + 1);
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public void setScrollPosition(int position, float positionOffset, boolean updateSelectedText) {
        this.setScrollPosition(position, positionOffset, updateSelectedText, true);
    }

    private void setScrollPosition(int position, float positionOffset, boolean updateSelectedText, boolean updateIndicatorPosition) {
        int roundedPosition = Math.round((float)position + positionOffset);
        if (roundedPosition < 0 || roundedPosition >= this.mTabStrip.getChildCount()) {
            return;
        }
        if (updateIndicatorPosition) {
            this.mTabStrip.setIndicatorPositionFromTabPosition(position, positionOffset);
        }
        if (this.mScrollAnimator != null && this.mScrollAnimator.isRunning()) {
            this.mScrollAnimator.cancel();
        }
        this.scrollTo(this.calculateScrollXForTab(position, positionOffset), 0);
        if (updateSelectedText) {
            this.setSelectedTabView(roundedPosition);
        }
    }

    private float getScrollPosition() {
        return this.mTabStrip.getIndicatorPosition();
    }

    public void addTab(@NonNull Tab tab) {
        this.addTab(tab, this.mTabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, int position) {
        this.addTab(tab, position, this.mTabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, boolean setSelected) {
        this.addTab(tab, this.mTabs.size(), setSelected);
    }

    public void addTab(final @NonNull Tab tab, int position, boolean setSelected) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab belongs to a different TabLayout.");
        }
        this.configureTab(tab, position);
        this.addTabView(tab);
        if (setSelected) {
            tab.getView().post(new Runnable(){

                @Override
                public void run() {
                    tab.select();
                }
            });
        }
    }

    private void addTabFromItemView(@NonNull TabItem item) {
        Tab tab = this.newTab();
        if (item.mText != null) {
            tab.setText(item.mText);
        }
        if (item.mIcon != null) {
            tab.setIcon(item.mIcon);
        }
        if (item.mCustomLayout != 0) {
            tab.setCustomView(item.mCustomLayout);
        }
        if (!TextUtils.isEmpty((CharSequence)item.getContentDescription())) {
            tab.setContentDescription(item.getContentDescription());
        }
        this.addTab(tab);
    }

    @Deprecated
    public void setOnTabSelectedListener(@Nullable OnTabSelectedListener listener) {
        if (this.mSelectedListener != null) {
            this.removeOnTabSelectedListener(this.mSelectedListener);
        }
        this.mSelectedListener = listener;
        if (listener != null) {
            this.addOnTabSelectedListener(listener);
        }
    }

    public void addOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        if (!this.mSelectedListeners.contains(listener)) {
            this.mSelectedListeners.add(listener);
        }
    }

    public void removeOnTabSelectedListener(@NonNull OnTabSelectedListener listener) {
        this.mSelectedListeners.remove(listener);
    }

    @NonNull
    public Tab newTab() {
        Tab tab = (Tab)sTabPool.acquire();
        if (tab == null) {
            tab = new Tab();
        }
        tab.mParent = this;
        tab.mView = this.createTabView(tab);
        return tab;
    }

    public int getTabCount() {
        return this.mTabs.size();
    }

    @Nullable
    public Tab getTabAt(int index) {
        if (index >= 0 && index < this.mTabs.size()) {
            return this.mTabs.get(index);
        }
        return null;
    }

    public int getSelectedTabPosition() {
        return this.mSelectedTab != null ? this.mSelectedTab.getPosition() : -1;
    }

    public void removeTab(Tab tab) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab does not belong to this TabLayout.");
        }
        this.removeTabAt(tab.getPosition());
    }

    public void removeTabAt(int position) {
        int selectedTabPosition = this.mSelectedTab != null ? this.mSelectedTab.getPosition() : 0;
        this.removeTabViewAt(position);
        Tab removedTab = this.mTabs.remove(position);
        if (removedTab != null) {
            removedTab.reset();
            sTabPool.release((Object)removedTab);
        }
        int newTabCount = this.mTabs.size();
        for (int i = position; i < newTabCount; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
        if (selectedTabPosition == position) {
            this.selectTab(this.mTabs.isEmpty() ? null : this.mTabs.get(Math.max(0, position - 1)));
        }
    }

    public void removeAllTabs() {
        for (int i = this.mTabStrip.getChildCount() - 1; i >= 0; --i) {
            this.removeTabViewAt(i);
        }
        Iterator<Tab> i = this.mTabs.iterator();
        while (i.hasNext()) {
            Tab tab = i.next();
            i.remove();
            tab.reset();
            sTabPool.release((Object)tab);
        }
        this.mSelectedTab = null;
    }

    public void setTabScrollMode(int mode) {
        if (mode != this.mScrollMode) {
            this.mScrollMode = mode;
            this.applyModeAndGravity();
        }
    }

    public int getTabScrollMode() {
        return this.mScrollMode;
    }

    public void setTabGravity(int gravity) {
        if (this.mTabGravity != gravity) {
            this.mTabGravity = gravity;
            this.applyModeAndGravity();
        }
    }

    public int getTabGravity() {
        return this.mTabGravity;
    }

    public void setTabIndicatorGravity(int gravity) {
        if (this.mIndicatorGravity != gravity) {
            this.mIndicatorGravity = gravity;
            if (null != this.mTabStrip) {
                this.mTabStrip.invalidate();
            }
        }
    }

    public int getTabIndicatorGravity() {
        return this.mIndicatorGravity;
    }

    public void setTabTextColor(int color) {
        this.mTabTextColors = ColorStateList.valueOf((int)color);
        this.updateAllTabs();
    }

    public void setTabTextColor(@Nullable ColorStateList textColor) {
        if (this.mTabTextColors != textColor) {
            this.mTabTextColors = textColor;
            this.updateAllTabs();
        }
    }

    @Nullable
    public ColorStateList getTabTextColors() {
        return this.mTabTextColors;
    }

    public void setTabTextColors(int normalColor, int activatedColor, int selectedColor) {
        this.setTabTextColor(TvTabLayout.createColorStateList(normalColor, activatedColor, selectedColor));
    }

    public void setTabIndicatorHeight(int height) {
        this.mTabStrip.setIndicatorHeight(height);
    }

    public int getTabIndicatorHeight() {
        return this.mTabStrip.mIndicatorHeight;
    }

    public void setTabIndicatorWidth(int width) {
        this.mTabStrip.setIndicatorWidth(width);
    }

    public int getTabIndicatorWidth() {
        return this.mTabStrip.mIndicatorWidth;
    }

    public void setIndicatorBackgroundColor(int colcor) {
        this.mTabStrip.setIndicatorBackgroundColor(colcor);
    }

    public void setIndicatorBackgroundHeight(int height) {
        this.mTabStrip.setIndicatorBackgroundHeight(height);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        this.setupWithViewPager(viewPager, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean autoRefresh) {
        this.setupWithViewPager(viewPager, autoRefresh, true, true);
    }

    public void setupWithViewPagerNoScrolledOffset(final @Nullable ViewPager viewPager) {
        if (viewPager != null && this.mPageChangeListener != null) {
            viewPager.removeOnPageChangeListener(this.mPageChangeListener);
        }
        if (this.mCurrentVpSelectedListener != null) {
            this.removeOnTabSelectedListener(this.mCurrentVpSelectedListener);
            this.mCurrentVpSelectedListener = null;
        }
        if (viewPager != null) {
            if (this.mPageChangeListener == null) {
                this.mPageChangeListener = new ViewPager.SimpleOnPageChangeListener(){

                    public void onPageSelected(int position) {
                        TvTabLayout.this.selectTab(position);
                    }
                };
            }
            viewPager.addOnPageChangeListener(this.mPageChangeListener);
            this.mCurrentVpSelectedListener = new SimpleOnTabSelectedListener(){

                @Override
                public void onTabSelected(Tab tab) {
                    viewPager.setCurrentItem(tab.mPosition, true);
                }
            };
            this.addOnTabSelectedListener(this.mCurrentVpSelectedListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                int adapterCount = adapter.getCount();
                for (int i = 0; i < adapterCount; ++i) {
                    this.addTab(this.newTab().setText(adapter.getPageTitle(i)), viewPager.getCurrentItem() == i);
                }
            }
        } else {
            this.mViewPager = null;
            this.setPagerAdapter(null, false);
        }
    }

    private void setupWithViewPager(@Nullable ViewPager viewPager, boolean autoRefresh, boolean implicitSetup, boolean isScrolledOffset) {
        if (this.mViewPager != null) {
            if (this.mPageChangeListener != null) {
                this.mViewPager.removeOnPageChangeListener(this.mPageChangeListener);
            }
            if (this.mAdapterChangeListener != null) {
                this.mViewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
            }
        }
        if (this.mCurrentVpSelectedListener != null) {
            this.removeOnTabSelectedListener(this.mCurrentVpSelectedListener);
            this.mCurrentVpSelectedListener = null;
        }
        if (viewPager != null) {
            this.mViewPager = viewPager;
            if (this.mPageChangeListener == null) {
                this.mPageChangeListener = new TabLayoutOnPageChangeListener(this, isScrolledOffset);
            }
            ((TabLayoutOnPageChangeListener)this.mPageChangeListener).reset();
            viewPager.addOnPageChangeListener(this.mPageChangeListener);
            this.mCurrentVpSelectedListener = new ViewPagerOnTabSelectedListener(viewPager);
            this.addOnTabSelectedListener(this.mCurrentVpSelectedListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.setPagerAdapter(adapter, autoRefresh);
            }
            if (this.mAdapterChangeListener == null) {
                this.mAdapterChangeListener = new AdapterChangeListener();
            }
            this.mAdapterChangeListener.setAutoRefresh(autoRefresh);
            viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
            this.setScrollPosition(viewPager.getCurrentItem(), 0.0f, true);
        } else {
            this.mViewPager = null;
            this.setPagerAdapter(null, false);
        }
        this.mSetupViewPagerImplicitly = implicitSetup;
    }

    @Deprecated
    public void setTabsFromPagerAdapter(@Nullable PagerAdapter adapter) {
        this.setPagerAdapter(adapter, false);
    }

    public boolean shouldDelayChildPressedState() {
        return this.getTabScrollRange() > 0;
    }

    protected void onAttachedToWindow() {
        ViewParent vp;
        super.onAttachedToWindow();
        if (this.mViewPager == null && (vp = this.getParent()) instanceof ViewPager) {
            this.setupWithViewPager((ViewPager)vp, true, true, true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mSetupViewPagerImplicitly) {
            this.setupWithViewPager(null);
            this.mSetupViewPagerImplicitly = false;
        }
    }

    private int getTabScrollRange() {
        return Math.max(0, this.mTabStrip.getWidth() - this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
    }

    private void setPagerAdapter(@Nullable PagerAdapter adapter, boolean addObserver) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver();
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    private void populateFromPagerAdapter() {
        this.removeAllTabs();
        if (this.mPagerAdapter != null) {
            int curItem;
            int adapterCount = this.mPagerAdapter.getCount();
            for (int i = 0; i < adapterCount; ++i) {
                this.addTab(this.newTab().setText(this.mPagerAdapter.getPageTitle(i)), false);
            }
            if (this.mViewPager != null && adapterCount > 0 && (curItem = this.mViewPager.getCurrentItem()) != this.getSelectedTabPosition() && curItem < this.getTabCount()) {
                final Tab tab = this.getTabAt(curItem);
                if (null != tab && null != tab.getView()) {
                    tab.getView().post(new Runnable(){

                        @Override
                        public void run() {
                            TvTabLayout.this.selectTab(tab);
                        }
                    });
                } else {
                    this.selectTab(tab);
                }
            }
        }
    }

    private void updateAllTabs() {
        int z = this.mTabs.size();
        for (int i = 0; i < z; ++i) {
            this.mTabs.get(i).updateView();
        }
    }

    private TabView createTabView(@NonNull Tab tab) {
        TabView tabView;
        TabView tabView2 = tabView = this.mTabViewPool != null ? (TabView)((Object)this.mTabViewPool.acquire()) : null;
        if (tabView == null) {
            tabView = new TabView(this.getContext());
        }
        tabView.setTab(tab);
        tabView.setFocusable(true);
        tabView.setMinimumWidth(this.getTabMinWidth());
        return tabView;
    }

    private void configureTab(Tab tab, int position) {
        tab.setPosition(position);
        this.mTabs.add(position, tab);
        int count = this.mTabs.size();
        for (int i = position + 1; i < count; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
    }

    private void addTabView(Tab tab) {
        TabView tabView = tab.mView;
        this.mTabStrip.addView((View)tabView, tab.getPosition(), (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
    }

    public void addView(View child) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index) {
        this.addViewInternal(child);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    private void addViewInternal(View child) {
        if (!(child instanceof TabItem)) {
            throw new IllegalArgumentException("Only TabItem instances can be added to TabLayout");
        }
        this.addTabFromItemView((TabItem)child);
    }

    public int getFontHeight(float fontSize) {
        Paint paint = new Paint();
        paint.setTextSize(fontSize);
        Paint.FontMetrics fm = paint.getFontMetrics();
        return (int)Math.ceil(fm.descent - fm.ascent);
    }

    private LinearLayout.LayoutParams createLayoutParamsForTabs() {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        this.updateTabViewLayoutParams(lp);
        return lp;
    }

    private void updateTabViewLayoutParams(LinearLayout.LayoutParams lp) {
        if (this.mScrollMode == 1 && this.mTabGravity == 3) {
            lp.height = -1;
            lp.width = 0;
            lp.weight = 1.0f;
        } else {
            lp.height = -2;
            lp.width = -2;
            lp.weight = 0.0f;
        }
        switch (this.mTabGravity) {
            case 0: {
                lp.gravity = 49;
                break;
            }
            case 1: {
                lp.gravity = 17;
                break;
            }
            case 2: {
                lp.gravity = 81;
            }
        }
    }

    private int dpToPx(int dps) {
        return Math.round(this.getResources().getDisplayMetrics().density * (float)dps);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int idealHeight = this.getDefaultHeight() + this.getPaddingTop() + this.getPaddingBottom() + this.mContentInsetBottom;
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(idealHeight, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)0x40000000);
                break;
            }
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)idealHeight, (int)0x40000000);
            }
        }
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0) {
            this.mTabMaxWidth = this.mRequestedTabMaxWidth > 0 ? this.mRequestedTabMaxWidth : specWidth - this.dpToPx(56);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() == 1) {
            View child = this.getChildAt(0);
            boolean remeasure = false;
            switch (this.mScrollMode) {
                case 0: {
                    remeasure = child.getMeasuredWidth() < this.getMeasuredWidth();
                    break;
                }
                case 1: {
                    boolean bl = remeasure = child.getMeasuredWidth() != this.getMeasuredWidth();
                }
            }
            if (remeasure) {
                int childHeightMeasureSpec = TvTabLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)child.getLayoutParams().height);
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private void removeTabViewAt(int position) {
        TabView view = (TabView)this.mTabStrip.getChildAt(position);
        this.mTabStrip.removeViewAt(position);
        if (view != null) {
            view.reset();
            this.mTabViewPool.release((Object)view);
        }
        this.requestLayout();
    }

    private void animateToTab(int newPosition) {
        if (newPosition == -1) {
            return;
        }
        if (this.getWindowToken() == null || !ViewCompat.isLaidOut((View)this) || this.mTabStrip.childrenNeedLayout()) {
            this.setScrollPosition(newPosition, 0.0f, true);
            return;
        }
        if (null == this.mViewPager) {
            int targetScrollX;
            int startScrollX = this.getScrollX();
            if (startScrollX != (targetScrollX = this.calculateScrollXForTab(newPosition, 0.0f))) {
                if (this.mScrollAnimator == null) {
                    this.mScrollAnimator = ViewUtils.createAnimator();
                    this.mScrollAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                    this.mScrollAnimator.setDuration(300L);
                    this.mScrollAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                        @Override
                        public void onAnimationUpdate(ValueAnimatorCompat animator) {
                            TvTabLayout.this.scrollTo(animator.getAnimatedIntValue(), 0);
                        }
                    });
                }
                this.mScrollAnimator.setIntValues(startScrollX, targetScrollX);
                this.mScrollAnimator.start();
            }
            this.mTabStrip.animateIndicatorToPosition(newPosition, 300);
        }
    }

    private void setSelectedTabView(int position) {
        int tabCount = this.mTabStrip.getChildCount();
        if (position < tabCount) {
            for (int i = 0; i < tabCount; ++i) {
                View child = this.mTabStrip.getChildAt(i);
                child.setSelected(i == position && this.hasFocus());
                child.setActivated(i == position && !this.hasFocus());
            }
        }
    }

    public boolean selectTab(int position) {
        return this.selectTab(this.getTabAt(position));
    }

    boolean selectTab(Tab tab) {
        return this.selectTab(tab, true);
    }

    boolean selectTab(Tab tab, boolean updateIndicator) {
        if (null == tab) {
            return false;
        }
        Tab currentTab = this.mSelectedTab;
        if (currentTab == tab) {
            this.dispatchTabReselected(tab);
            this.animateToTab(tab.getPosition());
        } else {
            int newPosition = tab.getPosition();
            if (updateIndicator) {
                if ((currentTab == null || currentTab.getPosition() == -1) && newPosition != -1) {
                    this.setScrollPosition(newPosition, 0.0f, true);
                } else {
                    this.animateToTab(newPosition);
                }
            }
            if (newPosition != -1) {
                this.setSelectedTabView(newPosition);
            }
            if (null != currentTab) {
                this.dispatchTabUnselected(currentTab);
            }
            this.mSelectedTab = tab;
            this.dispatchTabSelected(tab);
        }
        return true;
    }

    public Tab getSelectedTab() {
        return this.mSelectedTab;
    }

    private void dispatchTabSelected(@NonNull Tab tab) {
        this.onTabSelected(tab);
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabSelected(tab);
        }
    }

    private void dispatchTabUnselected(@NonNull Tab tab) {
        this.onTabUnselected(tab);
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabUnselected(tab);
        }
    }

    private void dispatchTabReselected(@NonNull Tab tab) {
        this.onTabReselected(tab);
        for (int i = this.mSelectedListeners.size() - 1; i >= 0; --i) {
            this.mSelectedListeners.get(i).onTabReselected(tab);
        }
    }

    protected void onTabSelected(@NonNull Tab tab) {
        ViewPropertyAnimator animator = tab.getView().animate();
        if (this.mTabTextSelectedCentered) {
            animator.scaleX(this.mTabTextSelectedScaleValue).scaleY(this.mTabTextSelectedScaleValue).translationY((float)((this.getHeight() - tab.getView().getHeight()) / 2)).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).setDuration(700L).start();
        } else if (this.mTabTextSelectedScaleValue > 0.0f) {
            animator.scaleX(this.mTabTextSelectedScaleValue).scaleY(this.mTabTextSelectedScaleValue).setDuration(500L).start();
        }
    }

    protected void onTabUnselected(@NonNull Tab tab) {
        ViewPropertyAnimator animator = tab.getView().animate();
        if (this.mTabTextSelectedCentered) {
            animator.scaleX(1.0f).scaleY(1.0f).translationY(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(500L).start();
        } else if (this.mTabTextSelectedScaleValue > 0.0f) {
            animator.scaleX(1.0f).scaleY(1.0f).setDuration(500L).start();
        }
    }

    protected void onTabReselected(@NonNull Tab tab) {
    }

    private int calculateScrollXForTab(int position, float positionOffset) {
        if (this.mScrollMode == 0) {
            View selectedChild = this.mTabStrip.getChildAt(position);
            View nextChild = position + 1 < this.mTabStrip.getChildCount() ? this.mTabStrip.getChildAt(position + 1) : null;
            int selectedWidth = selectedChild != null ? selectedChild.getWidth() : 0;
            int nextWidth = nextChild != null ? nextChild.getWidth() : 0;
            int scrollBase = selectedChild.getLeft() + selectedWidth / 2 - this.getWidth() / 2;
            int scrollOffset = (int)((float)(selectedWidth + nextWidth) * 0.5f * positionOffset);
            return ViewCompat.getLayoutDirection((View)this) == 0 ? scrollBase + scrollOffset : scrollBase - scrollOffset;
        }
        return 0;
    }

    private void applyModeAndGravity() {
        int paddingStart = 0;
        if (this.mScrollMode == 0) {
            paddingStart = Math.max(0, this.mContentInsetStart - this.mTabPaddingStart);
        }
        ViewCompat.setPaddingRelative((View)this.mTabStrip, (int)paddingStart, (int)0, (int)0, (int)this.mContentInsetBottom);
        switch (this.mScrollMode) {
            case 1: {
                this.mTabStrip.setGravity(1);
                break;
            }
            case 0: {
                this.mTabStrip.setGravity(0x800003);
            }
        }
        this.updateTabViews(true);
    }

    private void updateTabViews(boolean requestLayout) {
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View child = this.mTabStrip.getChildAt(i);
            child.setMinimumWidth(this.getTabMinWidth());
            this.updateTabViewLayoutParams((LinearLayout.LayoutParams)child.getLayoutParams());
            if (!requestLayout) continue;
            child.requestLayout();
        }
    }

    protected void drawableStateChanged() {
        Drawable drawable = this.mTabStrip.mIndicatorDrawable;
        if (drawable != null && drawable.isStateful()) {
            drawable.setState(this.getDrawableState());
        }
        super.drawableStateChanged();
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mTabStrip.mIndicatorDrawable || super.verifyDrawable(who);
    }

    private static ColorStateList createColorStateList(int defaultColor, int activatedColor, int selectedColor) {
        int[][] states = new int[][]{{16843518}, {0x10100A1}, {0}};
        int[] colors = new int[]{activatedColor, selectedColor, defaultColor};
        return new ColorStateList((int[][])states, colors);
    }

    private int getDefaultHeight() {
        boolean hasIconAndText = false;
        int count = this.mTabs.size();
        for (int i = 0; i < count; ++i) {
            Tab tab = this.mTabs.get(i);
            if (tab == null || tab.getIcon() == null || TextUtils.isEmpty((CharSequence)tab.getText())) continue;
            hasIconAndText = true;
            break;
        }
        int defaultHeight = hasIconAndText ? 72 : 48;
        return Math.max(this.mTabStrip.mIndicatorHeight, this.dpToPx(defaultHeight));
    }

    private int getTabMinWidth() {
        if (this.mRequestedTabMinWidth != -1) {
            return this.mRequestedTabMinWidth;
        }
        return this.mScrollMode == 0 ? this.mScrollableTabMinWidth : 0;
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return this.generateDefaultLayoutParams();
    }

    private int getTabMaxWidth() {
        return this.mTabMaxWidth;
    }

    private class AdapterChangeListener
    implements ViewPager.OnAdapterChangeListener {
        private boolean mAutoRefresh;

        private AdapterChangeListener() {
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            if (TvTabLayout.this.mViewPager == viewPager) {
                TvTabLayout.this.setPagerAdapter(newAdapter, this.mAutoRefresh);
            }
        }

        void setAutoRefresh(boolean autoRefresh) {
            this.mAutoRefresh = autoRefresh;
        }
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private PagerAdapterObserver() {
        }

        public void onChanged() {
            TvTabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            TvTabLayout.this.populateFromPagerAdapter();
        }
    }

    public static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager mViewPager;
        private Handler mHandler = new Handler(){

            public void handleMessage(Message msg) {
                if (msg.what == 122) {
                    ViewPagerOnTabSelectedListener.this.mViewPager.setCurrentItem(msg.arg1);
                }
            }
        };

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onTabSelected(Tab tab) {
            this.mHandler.removeMessages(122);
            Message msg = this.mHandler.obtainMessage(122, tab.mPosition, tab.mPosition);
            this.mHandler.sendMessageDelayed(msg, 100L);
        }

        @Override
        public void onTabUnselected(Tab tab) {
        }

        @Override
        public void onTabReselected(Tab tab) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<TvTabLayout> mTabLayoutRef;
        private int mPreviousScrollState;
        private int mScrollState;
        private boolean mIsScrolledOffset;

        public TabLayoutOnPageChangeListener(TvTabLayout tabLayout, boolean isScrolledOffset) {
            this.mTabLayoutRef = new WeakReference<TvTabLayout>(tabLayout);
            this.mIsScrolledOffset = isScrolledOffset;
        }

        public void onPageScrollStateChanged(int state) {
            this.mPreviousScrollState = this.mScrollState;
            this.mScrollState = state;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            TvTabLayout tabLayout = (TvTabLayout)((Object)this.mTabLayoutRef.get());
            if (tabLayout != null && this.mIsScrolledOffset) {
                boolean updateText = this.mScrollState != 2 || this.mPreviousScrollState == 1;
                tabLayout.setScrollPosition(position, positionOffset, updateText, true);
            }
        }

        public void onPageSelected(int position) {
            TvTabLayout tabLayout = (TvTabLayout)((Object)this.mTabLayoutRef.get());
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != position && position < tabLayout.getTabCount()) {
                boolean updateIndicator = this.mScrollState == 0 || this.mScrollState == 2 && this.mPreviousScrollState == 0;
                tabLayout.selectTab(tabLayout.getTabAt(position), updateIndicator);
            }
        }

        private void reset() {
            this.mScrollState = 0;
            this.mPreviousScrollState = 0;
        }
    }

    protected class SlidingTabStrip
    extends LinearLayout {
        private int mIndicatorHeight;
        private int mIndicatorWidth;
        private Drawable mIndicatorDrawable;
        private int mSelectedPosition;
        private float mSelectionOffset;
        private int mIndicatorLeft;
        private int mIndicatorRight;
        private int mIndicatorTop;
        private int mIndicatorBottom;
        private Paint mIndicatorBackgroundPaint;
        private Paint mCircleDotPaint;
        private int mIndicatorBackgroundHeight;
        private int mCircleDotRadius;
        private int mIndicatorBackgroundLeft;
        private int mIndicatorBackgroundRight;
        private int mIndicatorBackgroundTop;
        private int mIndicatorBackgroundBottom;
        private ValueAnimatorCompat mIndicatorAnimator;

        SlidingTabStrip(Context context) {
            super(context);
            this.mSelectedPosition = -1;
            this.mIndicatorLeft = -1;
            this.mIndicatorRight = -1;
            this.mIndicatorTop = -1;
            this.mIndicatorBottom = -1;
            this.setWillNotDraw(false);
            this.mIndicatorBackgroundPaint = new Paint();
            this.mIndicatorBackgroundPaint.setAntiAlias(true);
            this.mCircleDotPaint = new Paint();
            this.mCircleDotPaint.setAntiAlias(true);
        }

        void setIndicatorBackgroundColor(int color) {
            if (this.mIndicatorBackgroundPaint.getColor() != color) {
                this.mIndicatorBackgroundPaint.setColor(color);
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        public void setIndicatorBackgroundHeight(int height) {
            if (this.mIndicatorBackgroundHeight != height) {
                this.mIndicatorBackgroundHeight = height;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setIndicatorDrawable(Drawable indicatorDrawable) {
            if (this.mIndicatorDrawable != indicatorDrawable) {
                this.mIndicatorDrawable = indicatorDrawable;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setIndicatorHeight(int height) {
            if (this.mIndicatorHeight != height) {
                this.mIndicatorHeight = height;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setIndicatorWidth(int width) {
            if (this.mIndicatorWidth != width) {
                this.mIndicatorWidth = width;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setCircleDotRadius(int radius) {
            if (this.mCircleDotRadius != radius) {
                this.mCircleDotRadius = radius;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setCircleDotColor(int color) {
            if (this.mCircleDotPaint.getColor() != color) {
                this.mCircleDotPaint.setColor(color);
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        boolean childrenNeedLayout() {
            int z = this.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = this.getChildAt(i);
                if (child.getWidth() > 0) continue;
                return true;
            }
            return false;
        }

        void setIndicatorPositionFromTabPosition(int position, float positionOffset) {
            if (this.mIndicatorAnimator != null && this.mIndicatorAnimator.isRunning()) {
                this.mIndicatorAnimator.cancel();
            }
            this.mSelectedPosition = position;
            this.mSelectionOffset = positionOffset;
            this.updateIndicatorPosition();
        }

        float getIndicatorPosition() {
            return (float)this.mSelectedPosition + this.mSelectionOffset;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000) {
                return;
            }
            if (TvTabLayout.this.mScrollMode == 1 && TvTabLayout.this.mTabGravity != 3) {
                int count = this.getChildCount();
                int largestTabWidth = 0;
                int z = count;
                for (int i = 0; i < z; ++i) {
                    View child = this.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    largestTabWidth = Math.max(largestTabWidth, child.getMeasuredWidth());
                }
                if (largestTabWidth <= 0) {
                    return;
                }
                int gutter = TvTabLayout.this.dpToPx(16);
                boolean remeasure = false;
                if (largestTabWidth * count <= this.getMeasuredWidth() - gutter * 2) {
                    for (int i = 0; i < count; ++i) {
                        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getChildAt(i).getLayoutParams();
                        if (lp.width == largestTabWidth && lp.weight == 0.0f) continue;
                        lp.width = largestTabWidth;
                        lp.weight = 0.0f;
                        remeasure = true;
                    }
                } else {
                    TvTabLayout.this.mTabGravity = 3;
                    TvTabLayout.this.updateTabViews(false);
                    remeasure = true;
                }
                if (remeasure) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.mIndicatorAnimator != null && this.mIndicatorAnimator.isRunning()) {
                this.mIndicatorAnimator.cancel();
                long duration = this.mIndicatorAnimator.getDuration();
                float oldFraction = 1.0f - this.mIndicatorAnimator.getAnimatedFraction();
                this.animateIndicatorToPosition(this.mSelectedPosition, Math.round(oldFraction * (float)duration));
            } else {
                this.updateIndicatorPosition();
            }
        }

        private void updateIndicatorPosition() {
            int right;
            int left;
            View selectedTitle = this.getChildAt(this.mSelectedPosition);
            if (selectedTitle != null && selectedTitle.getWidth() > 0) {
                int indicatorOffset;
                left = selectedTitle.getLeft();
                right = selectedTitle.getRight();
                int n = indicatorOffset = this.mIndicatorWidth > 0 ? (selectedTitle.getWidth() - this.mIndicatorWidth) / 2 : 0;
                if (this.mSelectionOffset > 0.0f && this.mSelectedPosition < this.getChildCount() - 1) {
                    View nextTitle = this.getChildAt(this.mSelectedPosition + 1);
                    left = (int)(this.mSelectionOffset * (float)nextTitle.getLeft() + (1.0f - this.mSelectionOffset) * (float)left);
                    right = (int)(this.mSelectionOffset * (float)nextTitle.getRight() + (1.0f - this.mSelectionOffset) * (float)right);
                }
                left += indicatorOffset;
                right -= indicatorOffset;
            } else {
                right = -1;
                left = -1;
            }
            this.updateIndicatorTopAndBottom();
            this.updateIndicatorBackgroundBounds();
            this.setIndicatorPosition(left, right);
        }

        private void updateIndicatorTopAndBottom() {
            switch (TvTabLayout.this.mIndicatorGravity) {
                case 2: {
                    this.mIndicatorTop = this.getHeight() - this.mIndicatorHeight;
                    this.mIndicatorBottom = this.getHeight();
                    break;
                }
                case 1: {
                    this.mIndicatorTop = (this.getHeight() - this.mIndicatorHeight) / 2;
                    this.mIndicatorBottom = (this.getHeight() + this.mIndicatorHeight) / 2;
                    break;
                }
                case 0: {
                    this.mIndicatorTop = 0;
                    this.mIndicatorBottom = this.mIndicatorHeight;
                }
            }
        }

        private void updateIndicatorBackgroundBounds() {
            if (this.mIndicatorBackgroundHeight > 0) {
                this.mIndicatorBackgroundLeft = 0;
                this.mIndicatorBackgroundRight = this.getWidth();
                this.mIndicatorBackgroundTop = this.mIndicatorTop + (this.mIndicatorHeight - this.mIndicatorBackgroundHeight) / 2;
                this.mIndicatorBackgroundBottom = this.mIndicatorBackgroundTop + this.mIndicatorBackgroundHeight;
                if (this.mCircleDotRadius > 0) {
                    View leftView = this.getChildAt(0);
                    View rightView = this.getChildAt(this.getChildCount() - 1);
                    this.mIndicatorBackgroundLeft = null == leftView ? TvTabLayout.this.mRequestedTabMinWidth / 2 : leftView.getWidth() / 2;
                    this.mIndicatorBackgroundRight = null == rightView ? this.getChildCount() * TvTabLayout.this.mRequestedTabMinWidth - TvTabLayout.this.mRequestedTabMinWidth / 2 : rightView.getRight() - rightView.getWidth() / 2;
                }
            }
        }

        private void setIndicatorPosition(int left, int right) {
            if (left != this.mIndicatorLeft || right != this.mIndicatorRight) {
                this.mIndicatorLeft = left;
                this.mIndicatorRight = right;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void animateIndicatorToPosition(final int position, int duration) {
            int startRight;
            int startLeft;
            if (this.mIndicatorAnimator != null && this.mIndicatorAnimator.isRunning()) {
                this.mIndicatorAnimator.cancel();
            }
            boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
            View targetView = this.getChildAt(position);
            if (targetView == null) {
                this.updateIndicatorPosition();
                return;
            }
            int indicatorOffset = this.mIndicatorWidth > 0 ? (targetView.getWidth() - this.mIndicatorWidth) / 2 : 0;
            final int targetLeft = targetView.getLeft() + indicatorOffset;
            final int targetRight = targetView.getRight() - indicatorOffset;
            if (Math.abs(position - this.mSelectedPosition) <= 1) {
                startLeft = this.mIndicatorLeft;
                startRight = this.mIndicatorRight;
            } else {
                int offset = TvTabLayout.this.dpToPx(24);
                startLeft = position < this.mSelectedPosition ? (isRtl ? (startRight = targetLeft - offset) : (startRight = targetRight + offset)) : (isRtl ? (startRight = targetRight + offset) : (startRight = targetLeft - offset));
            }
            if (startLeft != targetLeft || startRight != targetRight) {
                ValueAnimatorCompat animator = this.mIndicatorAnimator = ViewUtils.createAnimator();
                animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                animator.setDuration(duration);
                animator.setFloatValues(0.0f, 1.0f);
                animator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimatorCompat animator) {
                        float fraction = animator.getAnimatedFraction();
                        SlidingTabStrip.this.setIndicatorPosition(AnimationUtils.lerp(startLeft, targetLeft, fraction), AnimationUtils.lerp(startRight, targetRight, fraction));
                    }
                });
                animator.setListener(new ValueAnimatorCompat.AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(ValueAnimatorCompat animator) {
                        SlidingTabStrip.this.mSelectedPosition = position;
                        SlidingTabStrip.this.mSelectionOffset = 0.0f;
                    }
                });
                animator.start();
            }
        }

        public void draw(Canvas canvas) {
            canvas.save();
            int childCount = this.getChildCount();
            if (this.mIndicatorBackgroundHeight > 0) {
                canvas.drawRect((float)this.mIndicatorBackgroundLeft, (float)this.mIndicatorBackgroundTop, (float)this.mIndicatorBackgroundRight, (float)this.mIndicatorBackgroundBottom, this.mIndicatorBackgroundPaint);
            }
            if (this.mCircleDotRadius > 0) {
                for (int i = 0; i < childCount; ++i) {
                    View childView = this.getChildAt(i);
                    if (null == childView) continue;
                    canvas.drawCircle((float)(childView.getWidth() / 2 + i * childView.getWidth()), (float)(this.getHeight() - (this.mIndicatorHeight - this.mIndicatorTop) / 2), (float)this.mCircleDotRadius, this.mCircleDotPaint);
                }
            }
            if (null != this.mIndicatorDrawable && this.mIndicatorLeft >= 0 && this.mIndicatorRight > this.mIndicatorLeft) {
                this.mIndicatorDrawable.setBounds(this.mIndicatorLeft, this.mIndicatorTop, this.mIndicatorRight, this.mIndicatorBottom);
                this.mIndicatorDrawable.draw(canvas);
            }
            canvas.restore();
            super.draw(canvas);
        }
    }

    public class TabView
    extends LinearLayout
    implements View.OnLongClickListener {
        private Tab mTab;
        private TextView mTextView;
        private ImageView mIconView;
        private View mCustomView;
        private TextView mCustomTextView;
        private ImageView mCustomIconView;
        private int mDefaultMaxLines;

        public TabView(Context context) {
            super(context);
            this.mDefaultMaxLines = 2;
            if (TvTabLayout.this.mTabBackgroundResId != 0) {
                this.setBackgroundDrawable(this.getResources().getDrawable(TvTabLayout.this.mTabBackgroundResId));
            }
            ViewCompat.setPaddingRelative((View)this, (int)TvTabLayout.this.mTabPaddingStart, (int)TvTabLayout.this.mTabPaddingTop, (int)TvTabLayout.this.mTabPaddingEnd, (int)TvTabLayout.this.mTabPaddingBottom);
            this.setGravity(17);
            this.setOrientation(1);
            this.setClickable(true);
        }

        public boolean performClick() {
            boolean value = super.performClick();
            if (this.mTab != null) {
                this.mTab.select();
                return true;
            }
            return value;
        }

        public void setSelected(boolean selected) {
            boolean changed = this.isSelected() != selected;
            super.setSelected(selected);
            if (changed && selected && Build.VERSION.SDK_INT < 16) {
                this.sendAccessibilityEvent(4);
            }
            if (this.mTextView != null) {
                this.mTextView.setSelected(selected);
            }
            if (this.mIconView != null) {
                this.mIconView.setSelected(selected);
            }
            if (this.mCustomView != null) {
                this.mCustomView.setSelected(selected);
            }
        }

        @TargetApi(value=14)
        public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(event);
        }

        @TargetApi(value=14)
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(info);
        }

        public void onMeasure(int origWidthMeasureSpec, int origHeightMeasureSpec) {
            int specWidthSize = View.MeasureSpec.getSize((int)origWidthMeasureSpec);
            int specWidthMode = View.MeasureSpec.getMode((int)origWidthMeasureSpec);
            int maxWidth = TvTabLayout.this.getTabMaxWidth();
            int heightMeasureSpec = origHeightMeasureSpec;
            int widthMeasureSpec = maxWidth > 0 && (specWidthMode == 0 || specWidthSize > maxWidth) ? View.MeasureSpec.makeMeasureSpec((int)TvTabLayout.this.mTabMaxWidth, (int)Integer.MIN_VALUE) : origWidthMeasureSpec;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.mTextView != null) {
                Resources res = this.getResources();
                float textSize = TvTabLayout.this.mTabTextSize;
                int maxLines = this.mDefaultMaxLines;
                if (this.mIconView != null && this.mIconView.getVisibility() == 0) {
                    maxLines = 1;
                } else if (this.mTextView != null && this.mTextView.getLineCount() > 1) {
                    textSize = TvTabLayout.this.mTabTextMultiLineSize;
                }
                float curTextSize = this.mTextView.getTextSize();
                int curLineCount = this.mTextView.getLineCount();
                int curMaxLines = TextViewCompat.getMaxLines((TextView)this.mTextView);
                if (textSize != curTextSize || curMaxLines >= 0 && maxLines != curMaxLines) {
                    Layout layout2;
                    boolean updateTextView = true;
                    if (TvTabLayout.this.mScrollMode == 1 && textSize > curTextSize && curLineCount == 1 && ((layout2 = this.mTextView.getLayout()) == null || this.approximateLineWidth(layout2, 0, textSize) > (float)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()))) {
                        updateTextView = false;
                    }
                    if (updateTextView) {
                        this.mTextView.setTextSize(0, textSize);
                        this.mTextView.setMaxLines(maxLines);
                        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    }
                }
            }
        }

        private void setTab(@Nullable Tab tab) {
            if (tab != this.mTab) {
                this.mTab = tab;
                this.update();
            }
        }

        private void reset() {
            this.setTab(null);
            this.setSelected(false);
        }

        final void update() {
            View custom;
            Tab tab = this.mTab;
            View view = custom = tab != null ? tab.getCustomView() : null;
            if (custom != null) {
                ViewParent customParent = custom.getParent();
                if (customParent != this) {
                    if (customParent != null) {
                        ((ViewGroup)customParent).removeView(custom);
                    }
                    this.addView(custom);
                }
                this.mCustomView = custom;
                if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                }
                if (this.mIconView != null) {
                    this.mIconView.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
                this.mCustomTextView = (TextView)custom.findViewById(16908308);
                if (this.mCustomTextView != null) {
                    this.mDefaultMaxLines = TextViewCompat.getMaxLines((TextView)this.mCustomTextView);
                }
                this.mCustomIconView = (ImageView)custom.findViewById(16908294);
            } else {
                if (this.mCustomView != null) {
                    this.removeView(this.mCustomView);
                    this.mCustomView = null;
                }
                this.mCustomTextView = null;
                this.mCustomIconView = null;
            }
            if (this.mCustomView == null) {
                if (this.mIconView == null) {
                    ImageView iconView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tab_layout_tab_icon, (ViewGroup)this, false);
                    this.addView((View)iconView, 0);
                    this.mIconView = iconView;
                }
                if (this.mTextView == null) {
                    TextView textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tab_layout_tab_text, (ViewGroup)this, false);
                    this.addView((View)textView);
                    this.mTextView = textView;
                    this.mDefaultMaxLines = TextViewCompat.getMaxLines((TextView)this.mTextView);
                }
                if (TvTabLayout.this.mTabTextColors != null) {
                    this.mTextView.setTextColor(TvTabLayout.this.mTabTextColors);
                }
                this.updateTextAndIcon(this.mTextView, this.mIconView);
            } else if (this.mCustomTextView != null || this.mCustomIconView != null) {
                this.updateTextAndIcon(this.mCustomTextView, this.mCustomIconView);
            }
            this.setSelected(tab != null && tab.isSelected());
        }

        private void updateTextAndIcon(@Nullable TextView textView, @Nullable ImageView iconView) {
            boolean hasText;
            CharSequence contentDesc;
            Drawable icon = this.mTab != null ? this.mTab.getIcon() : null;
            CharSequence text = this.mTab != null ? this.mTab.getText() : null;
            CharSequence charSequence = contentDesc = this.mTab != null ? this.mTab.getContentDescription() : null;
            if (iconView != null) {
                if (icon != null) {
                    iconView.setImageDrawable(icon);
                    iconView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    iconView.setVisibility(8);
                    iconView.setImageDrawable(null);
                }
                iconView.setContentDescription(contentDesc);
            }
            boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
            if (textView != null) {
                if (hasText) {
                    textView.setText(text);
                    textView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    textView.setVisibility(8);
                    textView.setText(null);
                }
                textView.setContentDescription(contentDesc);
            }
            if (iconView != null) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)iconView.getLayoutParams();
                int bottomMargin = 0;
                if (hasText && iconView.getVisibility() == 0) {
                    bottomMargin = TvTabLayout.this.dpToPx(8);
                }
                if (bottomMargin != lp.bottomMargin) {
                    lp.bottomMargin = bottomMargin;
                    iconView.requestLayout();
                }
            }
            if (!hasText && !TextUtils.isEmpty((CharSequence)contentDesc)) {
                this.setOnLongClickListener(this);
            } else {
                this.setOnLongClickListener(null);
                this.setLongClickable(false);
            }
        }

        public boolean onLongClick(View v) {
            int[] screenPos = new int[2];
            Rect displayFrame = new Rect();
            this.getLocationOnScreen(screenPos);
            this.getWindowVisibleDisplayFrame(displayFrame);
            Context context = this.getContext();
            int width = this.getWidth();
            int height = this.getHeight();
            int midy = screenPos[1] + height / 2;
            int referenceX = screenPos[0] + width / 2;
            if (ViewCompat.getLayoutDirection((View)v) == 0) {
                int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
                referenceX = screenWidth - referenceX;
            }
            Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)this.mTab.getContentDescription(), (int)0);
            if (midy < displayFrame.height()) {
                cheatSheet.setGravity(8388661, referenceX, screenPos[1] + height - displayFrame.top);
            } else {
                cheatSheet.setGravity(81, 0, height);
            }
            cheatSheet.show();
            return true;
        }

        public Tab getTab() {
            return this.mTab;
        }

        private float approximateLineWidth(Layout layout2, int line, float textSize) {
            return layout2.getLineWidth(line) * (textSize / layout2.getPaint().getTextSize());
        }
    }

    public static final class Tab {
        public static final int INVALID_POSITION = -1;
        private Object mTag;
        private Drawable mIcon;
        private CharSequence mText;
        private CharSequence mContentDesc;
        private int mPosition = -1;
        private View mCustomView;
        private TvTabLayout mParent;
        private TabView mView;

        private Tab() {
        }

        @Nullable
        public Object getTag() {
            return this.mTag;
        }

        @NonNull
        public Tab setTag(@Nullable Object tag) {
            this.mTag = tag;
            return this;
        }

        public TabView getTabView() {
            return this.mView;
        }

        public View getView() {
            return null != this.mView ? this.mView : this.mCustomView;
        }

        @Nullable
        public View getCustomView() {
            return this.mCustomView;
        }

        @NonNull
        public Tab setCustomView(@Nullable View view) {
            this.mCustomView = view;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setCustomView(@LayoutRes int resId) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mView.getContext());
            return this.setCustomView(inflater.inflate(resId, (ViewGroup)this.mView, false));
        }

        @Nullable
        public Drawable getIcon() {
            return this.mIcon;
        }

        public int getPosition() {
            return this.mPosition;
        }

        void setPosition(int position) {
            this.mPosition = position;
        }

        @Nullable
        public CharSequence getText() {
            return this.mText;
        }

        @NonNull
        public Tab setIcon(@Nullable Drawable icon) {
            this.mIcon = icon;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setIcon(@DrawableRes int resId) {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setIcon(this.mParent.getResources().getDrawable(resId));
        }

        @NonNull
        public Tab setText(@Nullable CharSequence text) {
            this.mText = text;
            this.updateView();
            return this;
        }

        @NonNull
        public Tab setText(@StringRes int resId) {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setText(this.mParent.getResources().getText(resId));
        }

        public void select() {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            this.mParent.selectTab(this);
        }

        public boolean isSelected() {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.mParent.getSelectedTabPosition() == this.mPosition;
        }

        @NonNull
        public Tab setContentDescription(@StringRes int resId) {
            if (this.mParent == null) {
                throw new IllegalArgumentException("Tab not attached to a TabLayout");
            }
            return this.setContentDescription(this.mParent.getResources().getText(resId));
        }

        @NonNull
        public Tab setContentDescription(@Nullable CharSequence contentDesc) {
            this.mContentDesc = contentDesc;
            this.updateView();
            return this;
        }

        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDesc;
        }

        private void updateView() {
            if (this.mView != null) {
                this.mView.update();
            }
        }

        private void reset() {
            this.mParent = null;
            this.mView = null;
            this.mTag = null;
            this.mIcon = null;
            this.mText = null;
            this.mContentDesc = null;
            this.mPosition = -1;
            this.mCustomView = null;
        }
    }

    public class SimpleOnTabSelectedListener
    implements OnTabSelectedListener {
        @Override
        public void onTabReselected(Tab tab) {
        }

        @Override
        public void onTabSelected(Tab tab) {
        }

        @Override
        public void onTabUnselected(Tab tab) {
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(Tab var1);

        public void onTabUnselected(Tab var1);

        public void onTabReselected(Tab var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabGravity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

