/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import org.quickserver.net.server.QuickServer;
import org.quickserver.util.xmlreader.ApplicationConfiguration;
import org.quickserver.util.xmlreader.BasicServerConfig;
import org.quickserver.util.xmlreader.DBObjectPoolConfig;
import org.quickserver.util.xmlreader.InitServerHooks;
import org.quickserver.util.xmlreader.QSAdminServerConfig;

public class QuickServerConfig
extends BasicServerConfig {
    private QSAdminServerConfig qSAdminServerConfig;
    private DBObjectPoolConfig dDObjectPoolConfig;
    private ApplicationConfiguration applicationConfiguration;
    private InitServerHooks initServerHooks;
    private String securityManagerClass = null;
    private String configFile = null;
    private String applicationJarPath = null;

    public QuickServerConfig() {
        this.setName("QuickServer v" + QuickServer.getVersion());
    }

    public void setQSAdminServerConfig(QSAdminServerConfig config) {
        this.qSAdminServerConfig = config;
    }

    public QSAdminServerConfig getQSAdminServerConfig() {
        return this.qSAdminServerConfig;
    }

    public void setDBObjectPoolConfig(DBObjectPoolConfig dDObjectPoolConfig) {
        this.dDObjectPoolConfig = dDObjectPoolConfig;
    }

    public DBObjectPoolConfig getDBObjectPoolConfig() {
        return this.dDObjectPoolConfig;
    }

    public void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public void setSecurityManagerClass(String securityManagerClass) {
        if (securityManagerClass != null) {
            this.securityManagerClass = securityManagerClass;
        }
    }

    public String getSecurityManagerClass() {
        return this.securityManagerClass;
    }

    protected void setConfigFile(String fileName) {
        this.configFile = fileName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setApplicationJarPath(String applicationJarPath) {
        this.applicationJarPath = applicationJarPath;
    }

    public String getApplicationJarPath() {
        return this.applicationJarPath;
    }

    public void setInitServerHooks(InitServerHooks initServerHooks) {
        this.initServerHooks = initServerHooks;
    }

    public InitServerHooks getInitServerHooks() {
        return this.initServerHooks;
    }

    public String toXML(String pad) {
        if (pad == null) {
            pad = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pad + "<quickserver>\n");
        if (this.getName() != null) {
            sb.append(pad + "\t<name>" + this.getName() + "</name>\n");
        }
        if (this.getServerBanner() != null) {
            sb.append(pad + "\t<server-banner>" + this.getServerBanner() + "</server-banner>\n");
        }
        sb.append(pad + "\t<port>" + this.getPort() + "</port>\n");
        if (this.getBindAddr() != null) {
            sb.append(pad + "\t<bind-address>" + this.getBindAddr() + "</bind-address>\n");
        }
        sb.append(this.getServerMode().toXML(pad + "\t"));
        if (this.getClientEventHandler() != null) {
            sb.append(pad + "\t<client-event-handler>" + this.getClientEventHandler() + "</client-event-handler>\n");
        }
        if (this.getClientCommandHandler() != null) {
            sb.append(pad + "\t<client-command-handler>" + this.getClientCommandHandler() + "</client-command-handler>\n");
        }
        if (this.getClientObjectHandler() != null) {
            sb.append(pad + "\t<client-object-handler>" + this.getClientObjectHandler() + "</client-object-handler>\n");
        }
        if (this.getClientBinaryHandler() != null) {
            sb.append(pad + "\t<client-binary-handler>" + this.getClientBinaryHandler() + "</client-binary-handler>\n");
        }
        if (this.getClientWriteHandler() != null) {
            sb.append(pad + "\t<client-write-handler>" + this.getClientWriteHandler() + "</client-write-handler>\n");
        }
        if (this.getClientAuthenticationHandler() != null) {
            sb.append(pad + "\t<client-authentication-handler>" + this.getClientAuthenticationHandler() + "</client-authentication-handler>\n");
        } else if (this.getAuthenticator() != null) {
            sb.append(pad + "\t<authenticator>" + this.getAuthenticator() + "</authenticator>\n");
        }
        if (this.getClientData() != null) {
            sb.append(pad + "\t<client-data>" + this.getClientData() + "</client-data>\n");
        }
        if (this.getClientExtendedEventHandler() != null) {
            sb.append(pad + "\t<client-extended-event-handler>" + this.getClientExtendedEventHandler() + "</client-extended-event-handler>\n");
        }
        sb.append(this.getDefaultDataMode().toXML(pad + "\t"));
        sb.append(pad + "\t<timeout>" + this.getTimeout() + "</timeout>\n");
        if (this.getTimeoutMsg() != null) {
            sb.append(pad + "\t<timeout-msg>" + this.getTimeoutMsg() + "</timeout-msg>\n");
        }
        sb.append(pad + "\t<max-auth-try>" + this.getMaxAuthTry() + "</max-auth-try>\n");
        if (this.getMaxAuthTryMsg() != null) {
            sb.append(pad + "\t<max-auth-try-msg>" + this.getMaxAuthTryMsg() + "</max-auth-try-msg>\n");
        }
        sb.append(pad + "\t<max-connection>" + this.getMaxConnection() + "</max-connection>\n");
        if (this.getMaxConnectionMsg() != null) {
            sb.append(pad + "\t<max-connection-msg>" + this.getMaxConnectionMsg() + "</max-connection-msg>\n");
        }
        if (this.getConsoleLoggingLevel() != null) {
            sb.append(pad + "\t<console-logging-level>" + this.getConsoleLoggingLevel() + "</console-logging-level>\n");
        }
        if (this.getConsoleLoggingFormatter() != null) {
            sb.append(pad + "\t<console-logging-formatter>" + this.getConsoleLoggingFormatter() + "</console-logging-formatter>\n");
        }
        sb.append(this.getObjectPoolConfig().toXML(pad + "\t"));
        sb.append(pad + "\t<communication-logging>\n");
        sb.append(pad + "\t\t<enable>" + this.getCommunicationLogging() + "</enable>\n");
        sb.append(pad + "\t</communication-logging>\n");
        if (this.getDBObjectPoolConfig() != null) {
            sb.append(this.getDBObjectPoolConfig().toXML(pad + "\t"));
        }
        if (this.getSecurityManagerClass() != null) {
            sb.append(pad + "\t<security-manager-class>" + this.getSecurityManagerClass() + "</security-manager-class>\n");
        }
        if (this.getAccessConstraintConfig() != null) {
            sb.append(this.getAccessConstraintConfig().toXML(pad + "\t"));
        }
        if (this.getQSAdminServerConfig() != null) {
            sb.append(this.getQSAdminServerConfig().toXML(pad + "\t"));
        }
        if (this.getApplicationConfiguration() != null) {
            sb.append(this.getApplicationConfiguration().toXML(pad + "\t"));
        }
        if (this.getApplicationJarPath() != null) {
            sb.append(pad + "\t<application-jar-path>" + this.getApplicationJarPath() + "</application-jar-path>\n");
        }
        if (this.getServerHooks() != null) {
            sb.append(this.getServerHooks().toXML(pad + "\t"));
        }
        if (this.getInitServerHooks() != null) {
            sb.append(this.getInitServerHooks().toXML(pad + "\t"));
        }
        sb.append(this.getSecure().toXML(pad + "\t"));
        sb.append(this.getAdvancedSettings().toXML(pad + "\t"));
        sb.append(pad + "</quickserver>\n");
        return sb.toString();
    }

    public String toString() {
        return this.toXML(null);
    }
}

