/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.xmlreader;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.logging.Logger;
import org.quickserver.util.xmlreader.IpFilterConfig;

public class AccessConstraintConfig
implements Serializable {
    private static final Logger logger = Logger.getLogger(AccessConstraintConfig.class.getName());
    private IpFilterConfig ipFilterConfig;

    public IpFilterConfig getIpFilterConfig() {
        return this.ipFilterConfig;
    }

    public void setIpFilterConfig(IpFilterConfig ipFilterConfig) {
        this.ipFilterConfig = ipFilterConfig;
    }

    public String toXML(String pad) {
        if (pad == null) {
            pad = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pad + "<access-constraint>\n");
        if (this.getIpFilterConfig() != null) {
            sb.append(this.getIpFilterConfig().toXML(pad + "\t"));
        }
        sb.append(pad + "</access-constraint>\n");
        return sb.toString();
    }

    public void checkAccept(Socket socket) {
        boolean accessFlag;
        if (socket == null || this.ipFilterConfig == null || !this.ipFilterConfig.getEnable()) {
            return;
        }
        String remoteIp = socket.getInetAddress().getHostAddress();
        boolean bl = accessFlag = this.ipFilterConfig.getAllowAccess();
        if (this.ipFilterConfig.getIpCollection().contains(remoteIp) != accessFlag) {
            try {
                socket.close();
            }
            catch (IOException e) {
                logger.warning("IOException : " + e.getMessage());
            }
            socket = null;
            throw new SecurityException("Accept denied from " + remoteIp);
        }
    }
}

