/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.pool.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quickserver.net.server.ClientEvent;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.util.MyString;
import org.quickserver.util.pool.thread.ClientPool;

public class ClientThread
extends Thread {
    private static final Logger logger = Logger.getLogger(ClientThread.class.getName());
    private static Map idMap = new HashMap();
    private String name = "<ClientThread-Pool#";
    private final ClientPool pool;
    private Runnable client;
    private int id;
    private boolean ready = false;
    protected volatile char state = (char)85;

    public boolean isReady() {
        return this.ready;
    }

    public void clean() {
        this.client = null;
    }

    public ClientThread(ClientPool pool) {
        this(pool, -1);
    }

    private static int getNewId(int instanceCount) {
        InstanceId instanceId = (InstanceId)idMap.get("" + instanceCount);
        if (instanceId == null) {
            instanceId = new InstanceId();
            idMap.put("" + instanceCount, instanceId);
        }
        return instanceId.getNextId();
    }

    public ClientThread(ClientPool pool, int instanceCount) {
        this.id = ClientThread.getNewId(instanceCount);
        this.name = this.name + instanceCount + "-ID:" + this.id + ">";
        this.pool = pool;
        this.setName(this.name);
    }

    public int getInstanceId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeClient() {
        boolean niowriteFlag = false;
        this.state = (char)82;
        try {
            try {
                if (ClientHandler.class.isInstance(this.client)) {
                    niowriteFlag = ((ClientHandler)this.client).isClientEventNext(ClientEvent.WRITE);
                    if (niowriteFlag) {
                        this.pool.nioWriteStart();
                    }
                } else {
                    niowriteFlag = false;
                }
                this.client.run();
            }
            catch (Throwable e) {
                logger.warning("RuntimeException @ thread run() : " + this.getName() + ": " + MyString.getStackTrace(e));
                Object var4_3 = null;
                if (niowriteFlag) {
                    this.pool.nioWriteEnd();
                }
            }
            Object var4_2 = null;
            if (niowriteFlag) {
                this.pool.nioWriteEnd();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (niowriteFlag) {
                this.pool.nioWriteEnd();
            }
            throw throwable;
        }
        this.state = (char)73;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.state = (char)83;
        ClientPool clientPool = this.pool;
        synchronized (clientPool) {
            if (this.pool.isClientAvailable()) {
                this.ready = true;
                this.pool.notify();
            }
        }
        boolean returnToPool = false;
        while (true) {
            if (this.ready) {
                this.state = (char)76;
                this.client = this.pool.getClient();
                if (this.client == null) {
                    logger.fine("ClientPool returned a null client! Other Thread must have taken my client.. Ok");
                } else {
                    this.executeClient();
                    logger.log(Level.FINEST, "Client returned the thread: {0}", this.getName());
                    this.client = null;
                    if (this.pool == null) {
                        logger.log(Level.FINE, "Could not returning client thread {0}, pool was null!", this.getName());
                        this.state = (char)68;
                        break;
                    }
                }
                returnToPool = true;
            }
            ClientThread clientThread = this;
            synchronized (clientThread) {
                if (!this.ready) {
                    this.ready = true;
                }
                if (returnToPool) {
                    logger.log(Level.FINEST, "Returning client thread to pool: {0}", this.getName());
                    this.pool.returnObject(this);
                    returnToPool = false;
                    this.state = (char)80;
                }
                try {
                    this.state = (char)87;
                    this.wait();
                    this.state = (char)78;
                }
                catch (InterruptedException e) {
                    logger.log(Level.FINEST, "Closing thread {0} since interrupted.", Thread.currentThread().getName());
                    this.state = (char)68;
                    break;
                }
            }
        }
    }

    public Runnable getThread() {
        return this.client;
    }

    public String toString() {
        return super.toString() + " - " + this.state + " - Client " + this.client;
    }

    static class InstanceId {
        private int id = 0;

        InstanceId() {
        }

        public int getNextId() {
            return ++this.id;
        }
    }
}

