/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.pool;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.quickserver.util.pool.QSObjectPool;
import org.quickserver.util.pool.QSObjectPoolMaker;

public class MakeQSObjectPool
implements QSObjectPool,
QSObjectPoolMaker {
    protected ObjectPool objectPool = null;
    protected List list = null;
    protected AtomicLong activeCount = new AtomicLong();
    private long highestActiveCount;

    public QSObjectPool getQSObjectPool(ObjectPool objectPool) {
        return new MakeQSObjectPool(objectPool);
    }

    public MakeQSObjectPool() {
        this.activeCount = new AtomicLong();
    }

    public MakeQSObjectPool(ObjectPool objectPool) {
        this.setObjectPool(objectPool);
    }

    protected void setObjectPool(ObjectPool objectPool) {
        this.objectPool = objectPool;
        this.list = Collections.synchronizedList(new LinkedList());
    }

    public void returnObject(Object obj) throws Exception {
        this.objectPool.returnObject(obj);
        if (this.list.remove(obj)) {
            this.activeCount.decrementAndGet();
        }
    }

    public Object borrowObject() throws Exception {
        Object obj = this.objectPool.borrowObject();
        this.list.add(obj);
        if (this.getHighestActiveCount() < this.activeCount.incrementAndGet()) {
            this.setHighestActiveCount(this.activeCount.get());
        }
        return obj;
    }

    public synchronized void close() throws Exception {
        this.list.clear();
        this.objectPool.close();
    }

    public Iterator getAllActiveObjects() {
        return this.list.iterator();
    }

    public Object getObjectToSynchronize() {
        return this.list;
    }

    public void addObject() throws Exception {
        this.objectPool.addObject();
    }

    public void clear() throws Exception {
        this.objectPool.clear();
    }

    public int getNumActive() {
        return this.objectPool.getNumActive();
    }

    public int getNumIdle() {
        return this.objectPool.getNumIdle();
    }

    public void invalidateObject(Object obj) throws Exception {
        this.objectPool.invalidateObject(obj);
    }

    public void setFactory(PoolableObjectFactory factory) {
        this.objectPool.setFactory(factory);
    }

    public long getHighestActiveCount() {
        return this.highestActiveCount;
    }

    public void setHighestActiveCount(long highestActiveCount) {
        this.highestActiveCount = highestActiveCount;
    }
}

