/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.util.pool;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.net.server.impl.BasicClientHandler;
import org.quickserver.net.server.impl.BlockingClientHandler;
import org.quickserver.net.server.impl.NonBlockingClientHandler;

public class ClientHandlerObjectFactory
extends BasePoolableObjectFactory {
    private static int instanceCount = 0;
    private int id = ++instanceCount;
    private boolean blocking = true;

    public ClientHandlerObjectFactory(boolean blocking) {
        this.blocking = blocking;
    }

    public Object makeObject() {
        if (this.blocking) {
            return new BlockingClientHandler(this.id);
        }
        return new NonBlockingClientHandler(this.id);
    }

    public void passivateObject(Object obj) {
        ClientHandler ch = (ClientHandler)obj;
        ch.clean();
    }

    public void activateObject(Object obj) {
    }

    public void destroyObject(Object obj) {
        if (obj == null) {
            return;
        }
        this.passivateObject(obj);
        obj = null;
    }

    public boolean validateObject(Object obj) {
        if (obj == null) {
            return false;
        }
        BasicClientHandler ch = (BasicClientHandler)obj;
        return ch.getInstanceCount() == this.id;
    }
}

